/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.Stack;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.PortView;

public class GraphLayoutCache
extends Observable
implements CellMapper,
Serializable {
    public boolean showAllEdgesForVisibleVertices = true;
    public boolean showEdgesOnShow = true;
    public boolean hideEdgesOnHide = true;
    public boolean hideEdgesOnBecomeInvisible = true;
    public boolean rememberCellViews = true;
    protected GraphModel graphModel;
    protected Map mapping = new Hashtable();
    protected CellMapper mapper;
    protected CellViewFactory factory = null;
    protected JGraph graph = null;
    protected Set visibleSet = new HashSet();
    protected List roots = new ArrayList();
    protected PortView[] ports;
    protected transient Map hiddenSet = new Hashtable();
    protected boolean ordered = false;
    protected boolean partial = false;
    protected boolean askLocalAttribute = true;
    protected Set localAttributes = new HashSet();

    public GraphLayoutCache(JGraph jGraph) {
        this(jGraph, jGraph.getModel(), jGraph, false, false);
    }

    public GraphLayoutCache(JGraph jGraph, Set set) {
        this(jGraph, jGraph.getModel(), jGraph, false, false);
        this.setLocalAttributes(set);
    }

    public GraphLayoutCache(JGraph jGraph, GraphModel graphModel, CellViewFactory cellViewFactory, boolean bl, boolean bl2) {
        this(jGraph, graphModel, cellViewFactory, bl, bl2, true, true, true, true, true);
    }

    public GraphLayoutCache(JGraph jGraph, GraphModel graphModel, CellViewFactory cellViewFactory, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this.graph = jGraph;
        this.factory = cellViewFactory;
        this.ordered = bl;
        this.partial = bl2;
        this.rememberCellViews = bl3;
        this.showAllEdgesForVisibleVertices = bl4;
        this.showEdgesOnShow = bl5;
        this.hideEdgesOnHide = bl6;
        this.hideEdgesOnBecomeInvisible = bl7;
        this.setModel(graphModel);
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public void setFactory(CellViewFactory cellViewFactory) {
        this.factory = cellViewFactory;
    }

    public CellViewFactory getFactory() {
        return this.factory;
    }

    public void setModel(GraphModel graphModel) {
        this.roots.clear();
        this.mapping.clear();
        this.hiddenSet.clear();
        this.visibleSet.clear();
        this.graphModel = graphModel;
        Object[] objectArray = DefaultGraphModel.getRoots(graphModel);
        if (!this.isPartial()) {
            this.insertRoots(this.getMapping(objectArray, true));
        }
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.factory.updateAutoSize(this.getGraph(), this.getMapping(objectArray[n], false));
                ++n;
            }
        }
        this.updatePorts();
    }

    public synchronized void reload() {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        Hashtable hashtable = new Hashtable(this.mapping);
        this.mapping.clear();
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            CellView cellView = (CellView)hashtable.get(k);
            CellView cellView2 = this.getMapping(k, true);
            cellView2.setAttributes(cellView.getAttributes());
            if (!this.roots.contains(cellView)) continue;
            arrayList.add(cellView2);
        }
        this.hiddenSet.clear();
        this.roots = arrayList;
    }

    public GraphModel getModel() {
        return this.graphModel;
    }

    public CellView[] getRoots() {
        CellView[] cellViewArray = new CellView[this.roots.size()];
        this.roots.toArray(cellViewArray);
        return cellViewArray;
    }

    public CellView[] getRoots(Rectangle2D rectangle2D) {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        CellView[] cellViewArray = this.getRoots();
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n].getBounds().intersects(rectangle2D)) {
                arrayList.add(cellViewArray[n]);
            }
            ++n;
        }
        cellViewArray = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray);
        return cellViewArray;
    }

    public PortView[] getPorts() {
        return this.ports;
    }

    protected void updatePorts() {
        Object[] objectArray = DefaultGraphModel.getRoots(this.graphModel);
        Set set = DefaultGraphModel.getDescendants(this.graphModel, objectArray);
        if (set != null) {
            Object[] objectArray2 = set.toArray();
            ArrayList<CellView> arrayList = new ArrayList<CellView>();
            int n = 0;
            while (n < objectArray2.length) {
                CellView cellView;
                if (this.graphModel.isPort(objectArray2[n]) && (cellView = this.getMapping(objectArray2[n], false)) != null) {
                    arrayList.add(cellView);
                    cellView.refresh(false);
                }
                ++n;
            }
            this.ports = new PortView[arrayList.size()];
            arrayList.toArray(this.ports);
        }
    }

    public void refresh(CellView[] cellViewArray, boolean bl) {
        if (cellViewArray != null) {
            int n = 0;
            while (n < cellViewArray.length) {
                this.refresh(cellViewArray[n], bl);
                ++n;
            }
        }
    }

    public void refresh(CellView cellView, boolean bl) {
        if (cellView != null) {
            cellView.refresh(bl);
            CellView[] cellViewArray = cellView.getChildViews();
            int n = 0;
            while (n < cellViewArray.length) {
                this.refresh(cellViewArray[n], bl);
                ++n;
            }
        }
    }

    public void update(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            int n = 0;
            while (n < cellViewArray.length) {
                this.update(cellViewArray[n]);
                ++n;
            }
        }
    }

    public void update(CellView cellView) {
        if (cellView != null) {
            cellView.update();
            CellView[] cellViewArray = cellView.getChildViews();
            int n = 0;
            while (n < cellViewArray.length) {
                this.update(cellViewArray[n]);
                ++n;
            }
        }
    }

    public void graphChanged(GraphModelEvent.GraphModelChange graphModelChange) {
        Object[] objectArray;
        CellView[] cellViewArray = graphModelChange.getViews(this);
        if (cellViewArray != null) {
            int n = 0;
            while (n < cellViewArray.length) {
                if (cellViewArray[n] != null) {
                    this.mapping.put(cellViewArray[n].getCell(), cellViewArray[n]);
                }
                ++n;
            }
            this.setVisibleImpl(this.getCells(cellViewArray), true);
        }
        Object[] objectArray2 = this.order(graphModelChange.getChanged());
        CellView[] cellViewArray2 = this.getMapping(graphModelChange.getInserted(), true);
        cellViewArray = this.removeRoots(graphModelChange.getRemoved());
        graphModelChange.putViews(this, cellViewArray);
        this.insertRoots(cellViewArray2);
        if (this.isPartial()) {
            this.showCellsForChange(graphModelChange);
            this.hideCellsForChange(graphModelChange);
        }
        if (objectArray2 != null && objectArray2.length > 0) {
            Object object;
            if (!this.isOrdered()) {
                this.roots.clear();
                Object[] objectArray3 = DefaultGraphModel.getRoots(this.graphModel);
                object = this.getMapping(objectArray3, false);
                int n = 0;
                while (n < ((CellView[])object).length) {
                    if (object[n] != null) {
                        this.roots.add(object[n]);
                        object[n].refresh(true);
                        this.factory.updateAutoSize(this.getGraph(), (CellView)object[n]);
                    }
                    ++n;
                }
            }
            int n = 0;
            while (n < objectArray2.length) {
                object = this.getMapping(objectArray2[n], false);
                if (object != null) {
                    object.refresh(true);
                    this.update((CellView)object);
                    this.factory.updateAutoSize(this.getGraph(), (CellView)object);
                    if (this.isOrdered()) {
                        CellView cellView = object.getParentView();
                        Object object2 = cellView != null ? cellView.getCell() : null;
                        boolean bl = this.roots.contains(object);
                        if (object2 == null && !bl) {
                            this.roots.add(object);
                        } else if (object2 != null && bl) {
                            this.roots.remove(object);
                        }
                    }
                }
                ++n;
            }
        }
        if ((objectArray = graphModelChange.getInserted()) != null && objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                this.factory.updateAutoSize(this.getGraph(), this.getMapping(objectArray[n], false));
                ++n;
            }
        }
        this.refresh(this.getMapping(graphModelChange.getContext(), false), false);
        Object[] objectArray4 = graphModelChange.getRemoved();
        if (objectArray4 != null && objectArray4.length > 0 || objectArray != null && objectArray.length > 0 || !this.isOrdered()) {
            this.updatePorts();
        }
    }

    protected void hideCellsForChange(GraphModelEvent.GraphModelChange graphModelChange) {
        Object[] objectArray = graphModelChange.getRemoved();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                hashSet.add(objectArray[n]);
                ++n;
            }
        }
        if (this.hideEdgesOnBecomeInvisible) {
            Object[] objectArray2 = graphModelChange.getChanged();
            int n = 0;
            while (n < objectArray2.length) {
                CellView cellView = this.getMapping(objectArray2[n], false);
                if (cellView instanceof EdgeView) {
                    EdgeView edgeView = (EdgeView)cellView;
                    Object object = edgeView.getSource() == null ? null : edgeView.getSource().getCell();
                    Object object2 = edgeView.getTarget() == null ? null : edgeView.getTarget().getCell();
                    Object object3 = this.graphModel.getSource(objectArray2[n]);
                    Object object4 = this.graphModel.getTarget(objectArray2[n]);
                    if (hashSet.contains(object) || hashSet.contains(object2) || object3 != null && !this.isVisible(object3) || object4 != null && !this.isVisible(object4)) {
                        this.setVisibleImpl(new Object[]{objectArray2[n]}, false);
                    }
                }
                ++n;
            }
        }
    }

    protected void showCellsForChange(GraphModelEvent.GraphModelChange graphModelChange) {
        if (this.showAllEdgesForVisibleVertices) {
            Object[] objectArray;
            Object object;
            Object[] objectArray2 = graphModelChange.getInserted();
            if (objectArray2 != null) {
                int n = 0;
                while (n < objectArray2.length) {
                    if (!this.isVisible(objectArray2[n]) && this.showAllEdgesForVisibleVertices) {
                        Object object2 = this.graphModel.getSource(objectArray2[n]);
                        object = this.graphModel.getTarget(objectArray2[n]);
                        if ((object2 != null || object != null) && this.isVisible(object2) && this.isVisible(object)) {
                            this.setVisible(objectArray2[n], true);
                        }
                    }
                    ++n;
                }
            }
            if ((objectArray = graphModelChange.getChanged()) != null) {
                int n = 0;
                while (n < objectArray.length) {
                    if (!this.isVisible(objectArray[n])) {
                        object = this.graphModel.getSource(objectArray[n]);
                        Object object3 = this.graphModel.getTarget(objectArray[n]);
                        if ((object != null || object3 != null) && this.isVisible(object) && this.isVisible(object3)) {
                            this.setVisible(objectArray[n], true);
                        }
                    }
                    ++n;
                }
            }
        }
    }

    public void insertRoots(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            this.refresh(cellViewArray, true);
            int n = 0;
            while (n < cellViewArray.length) {
                if (cellViewArray[n] != null && this.getMapping(cellViewArray[n].getCell(), false) != null) {
                    Object object;
                    CellView cellView = cellViewArray[n].getParentView();
                    Object object2 = object = cellView != null ? cellView.getCell() : null;
                    if (!(cellViewArray[n] instanceof PortView) && !this.roots.contains(cellViewArray[n]) && object == null) {
                        this.roots.add(cellViewArray[n]);
                    }
                }
                ++n;
            }
        }
    }

    public CellView[] removeRoots(Object[] objectArray) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                cellViewArray[n] = this.removeMapping(objectArray[n]);
                if (cellViewArray[n] != null) {
                    cellViewArray[n].removeFromParent();
                    this.roots.remove(cellViewArray[n]);
                }
                ++n;
            }
            this.setVisibleImpl(objectArray, false);
            return cellViewArray;
        }
        return null;
    }

    public Object[] getCells(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            Object[] objectArray = new Object[cellViewArray.length];
            int n = 0;
            while (n < cellViewArray.length) {
                if (cellViewArray[n] != null) {
                    objectArray[n] = cellViewArray[n].getCell();
                }
                ++n;
            }
            return objectArray;
        }
        return null;
    }

    public CellView getMapping(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        CellView cellView = (CellView)this.mapping.get(object);
        if (cellView == null && bl) {
            cellView = (CellView)this.hiddenSet.get(object);
            if (cellView != null && this.isVisible(object)) {
                this.putMapping(object, cellView);
                this.hiddenSet.remove(object);
            } else {
                cellView = this.factory.createView(this.getGraph(), this, object);
            }
        }
        return cellView;
    }

    public CellView[] getMapping(Object[] objectArray) {
        return this.getMapping(objectArray, false);
    }

    public CellView[] getMapping(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                cellViewArray[n] = this.getMapping(objectArray[n], bl);
                ++n;
            }
            return cellViewArray;
        }
        return null;
    }

    public void putMapping(Object object, CellView cellView) {
        if (object != null && cellView != null && this.isVisible(object)) {
            this.mapping.put(object, cellView);
        }
    }

    public CellView removeMapping(Object object) {
        if (object != null) {
            CellView cellView = (CellView)this.mapping.remove(object);
            return cellView;
        }
        return null;
    }

    public boolean isVisible(Object object) {
        return !this.isPartial() || this.visibleSet.contains(object) || object == null;
    }

    public Set getVisibleSet() {
        return new HashSet(this.visibleSet);
    }

    public void setVisibleSet(Set set) {
        this.visibleSet = set;
    }

    public void setVisible(Object object, boolean bl) {
        this.setVisible(new Object[]{object}, bl);
    }

    public void setVisible(Object[] objectArray, boolean bl) {
        if (bl) {
            this.setVisible(objectArray, null);
        } else {
            this.setVisible(null, objectArray);
        }
    }

    public void setVisible(Object[] objectArray, Object[] objectArray2) {
        objectArray = this.addVisibleDependencies(objectArray, true);
        objectArray2 = this.addVisibleDependencies(objectArray2, false);
        GraphViewEdit graphViewEdit = new GraphViewEdit(null, objectArray, objectArray2);
        graphViewEdit.end();
        this.graphModel.edit(null, null, null, new UndoableEdit[]{graphViewEdit});
    }

    public Object[] addVisibleDependencies(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            if (bl) {
                HashSet<Object> hashSet = new HashSet<Object>();
                int n = 0;
                while (n < objectArray.length) {
                    hashSet.add(objectArray[n]);
                    hashSet.addAll(this.getPorts(objectArray[n]));
                    hashSet.addAll(this.getParentPorts(this.graphModel.getSource(objectArray[n])));
                    hashSet.addAll(this.getParentPorts(this.graphModel.getTarget(objectArray[n])));
                    ++n;
                }
                if (this.showEdgesOnShow) {
                    Set set = DefaultGraphModel.getEdges(this.getModel(), objectArray);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        Object object = this.graphModel.getSource(e);
                        Object object2 = this.graphModel.getTarget(e);
                        if (!this.isVisible(object) && !hashSet.contains(object) || !this.isVisible(object2) && !hashSet.contains(object2)) continue;
                        hashSet.add(e);
                    }
                }
                hashSet.removeAll(this.visibleSet);
                return hashSet.toArray();
            }
            if (this.hideEdgesOnHide) {
                HashSet<Object> hashSet = new HashSet<Object>();
                int n = 0;
                while (n < objectArray.length) {
                    hashSet.addAll(this.getPorts(objectArray[n]));
                    hashSet.add(objectArray[n]);
                    ++n;
                }
                hashSet.addAll(DefaultGraphModel.getEdges(this.graphModel, objectArray));
                hashSet.retainAll(this.visibleSet);
                return hashSet.toArray();
            }
        }
        return null;
    }

    public boolean setVisibleImpl(Object[] objectArray, boolean bl) {
        if (objectArray != null && this.isPartial()) {
            boolean bl2 = false;
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null) {
                    if (bl) {
                        this.visibleSet.add(objectArray[n]);
                    } else {
                        this.visibleSet.remove(objectArray[n]);
                    }
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] != null) {
                    CellView cellView;
                    if (!bl) {
                        cellView = this.getMapping(objectArray[n2], false);
                        if (cellView != null) {
                            cellView.removeFromParent();
                            cellView.refresh(false);
                            this.removeMapping(objectArray[n2]);
                            this.roots.remove(cellView);
                            if (this.graphModel.contains(objectArray[n2]) && this.rememberCellViews) {
                                this.hiddenSet.put(cellView.getCell(), cellView);
                            }
                            bl2 = true;
                        }
                    } else {
                        cellView = this.getMapping(objectArray[n2], true);
                        CellView[] cellViewArray = AbstractCellView.getDescendantViews(new CellView[]{cellView});
                        int n3 = 0;
                        while (n3 < cellViewArray.length) {
                            this.roots.remove(cellViewArray[n3]);
                            ++n3;
                        }
                        cellView.refresh(false);
                        this.factory.updateAutoSize(this.getGraph(), cellView);
                        CellView cellView2 = cellView.getParentView();
                        if (cellView2 != null) {
                            cellView2.refresh(true);
                        } else {
                            this.insertRoots(new CellView[]{cellView});
                        }
                        bl2 = true;
                    }
                }
                ++n2;
            }
            return bl2;
        }
        return false;
    }

    protected Collection getParentPorts(Object object) {
        Object object2 = this.graphModel.getParent(object);
        Collection collection = this.getPorts(object2);
        collection.add(object2);
        return collection;
    }

    protected Collection getPorts(Object object) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        int n = 0;
        while (n < this.graphModel.getChildCount(object)) {
            Object object2 = this.graphModel.getChild(object, n);
            if (this.graphModel.isPort(object2)) {
                linkedList.add(object2);
            }
            ++n;
        }
        return linkedList;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void valueForCellChanged(Object object, Object object2) {
        Map map = GraphConstants.createAttributes(object, (Object)"value", object2);
        this.edit(map, null, null, null);
    }

    public void insert(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        Serializable serializable;
        Object[] objectArray2 = null;
        if (this.isPartial()) {
            serializable = new HashSet(DefaultGraphModel.getDescendants(this.graphModel, objectArray));
            serializable.removeAll(this.visibleSet);
            if (!serializable.isEmpty()) {
                objectArray2 = serializable.toArray();
            }
        }
        serializable = this.createLocalEdit(map, objectArray2, null);
        this.setVisibleImpl(objectArray2, true);
        if (serializable != null) {
            undoableEditArray = this.augment(undoableEditArray, (UndoableEdit)((Object)serializable));
        }
        this.graphModel.insert(objectArray, map, connectionSet, parentMap, undoableEditArray);
    }

    public void remove(Object[] objectArray) {
        this.graphModel.remove(objectArray);
    }

    public void edit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        Serializable serializable;
        Object[] objectArray = null;
        if (this.isPartial()) {
            serializable = new HashSet(map.keySet());
            serializable.removeAll(this.visibleSet);
            if (!serializable.isEmpty()) {
                objectArray = serializable.toArray();
            }
        }
        if ((serializable = this.createLocalEdit(map, objectArray, null)) != null) {
            undoableEditArray = this.augment(undoableEditArray, (UndoableEdit)((Object)serializable));
        }
        this.graphModel.edit(map, connectionSet, parentMap, undoableEditArray);
    }

    protected UndoableEdit[] augment(UndoableEdit[] undoableEditArray, UndoableEdit undoableEdit) {
        if (undoableEdit != null) {
            int n = undoableEditArray != null ? undoableEditArray.length + 1 : 1;
            UndoableEdit[] undoableEditArray2 = new UndoableEdit[n];
            if (undoableEditArray != null) {
                System.arraycopy(undoableEditArray, 0, undoableEditArray2, 0, n - 2);
            }
            undoableEditArray2[n - 1] = undoableEdit;
            return undoableEditArray2;
        }
        return undoableEditArray;
    }

    public void toBack(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            if (this.isOrdered()) {
                Object[] objectArray2 = this.getMapping(objectArray, false);
                GraphViewLayerEdit graphViewLayerEdit = new GraphViewLayerEdit(this, objectArray2, -2);
                this.graphModel.edit(null, null, null, new UndoableEdit[]{graphViewLayerEdit});
            } else {
                this.graphModel.toBack(objectArray);
            }
        }
    }

    public void toFront(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            if (this.isOrdered()) {
                Object[] objectArray2 = this.getMapping(objectArray, false);
                GraphViewLayerEdit graphViewLayerEdit = new GraphViewLayerEdit(this, objectArray2, -1);
                this.graphModel.edit(null, null, null, new UndoableEdit[]{graphViewLayerEdit});
            } else {
                this.graphModel.toFront(objectArray);
            }
        }
    }

    protected GraphViewEdit createLocalEdit(Map map, Object[] objectArray, Object[] objectArray2) {
        if (map != null && !map.isEmpty() && this.isAskLocalAttribute()) {
            Object object;
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                AttributeMap attributeMap = this.graphModel.createAttributes();
                object = iterator.next();
                Object k = object.getKey();
                AttributeMap attributeMap2 = (AttributeMap)object.getValue();
                CellView cellView = this.getMapping(k, false);
                if (cellView != null) {
                    attributeMap2 = cellView.getAllAttributes().diff(attributeMap2);
                }
                Iterator iterator2 = attributeMap2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    Object k2 = entry.getKey();
                    Object v = entry.getValue();
                    boolean bl = this.isControlAttribute(k, k2, v);
                    if (!this.isLocalAttribute(k, k2, v) && !bl) continue;
                    attributeMap.put(k2, v);
                    if (bl) continue;
                    iterator2.remove();
                }
                if (!attributeMap.isEmpty()) {
                    hashtable2.put(k, attributeMap);
                }
                if (attributeMap2.isEmpty()) continue;
                hashtable.put(k, attributeMap2);
            }
            map.clear();
            map.putAll(hashtable);
            object = new GraphViewEdit(new Hashtable(hashtable2), objectArray, objectArray2);
            ((CompoundEdit)object).end();
            return object;
        }
        if (objectArray != null || objectArray2 != null) {
            GraphViewEdit graphViewEdit = new GraphViewEdit(null, objectArray, objectArray2);
            graphViewEdit.end();
            return graphViewEdit;
        }
        return null;
    }

    protected boolean isLocalAttribute(Object object, Object object2, Object object3) {
        return this.localAttributes.contains(object2);
    }

    protected boolean isControlAttribute(Object object, Object object2, Object object3) {
        return "removeAll".equals(object2) || "removeAttributes".equals(object2);
    }

    public Object[] order(Object[] objectArray) {
        if (objectArray != null) {
            if (this.graphModel != null && this.isOrdered()) {
                Object[] objectArray2;
                HashSet<Object> hashSet = new HashSet<Object>();
                int n = 0;
                while (n < objectArray.length) {
                    hashSet.add(objectArray[n]);
                    ++n;
                }
                CellView[] cellViewArray = this.getRoots();
                Stack<Object> stack = new Stack<Object>();
                int n2 = 0;
                while (n2 < cellViewArray.length) {
                    stack.add(cellViewArray[n2]);
                    ++n2;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (!stack.isEmpty()) {
                    CellView cellView = (CellView)stack.pop();
                    if (hashSet.contains(cellView.getCell())) {
                        arrayList.add(cellView.getCell());
                    }
                    objectArray2 = cellView.getChildViews();
                    int n3 = 0;
                    while (n3 < objectArray2.length) {
                        stack.add(objectArray2[n3]);
                        ++n3;
                    }
                    int n4 = this.graphModel.getChildCount(cellView.getCell()) - 1;
                    while (n4 >= 0) {
                        CellView cellView2;
                        Object object = this.graphModel.getChild(cellView.getCell(), n4);
                        if (this.graphModel.isPort(object) && (cellView2 = this.getMapping(object, false)) != null) {
                            stack.add(cellView2);
                        }
                        --n4;
                    }
                }
                int n5 = arrayList.size();
                objectArray2 = new Object[n5];
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    objectArray2[--n5] = iterator.next();
                }
                return objectArray2;
            }
            Object[] objectArray3 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray3[objectArray.length - n - 1] = objectArray[n];
                ++n;
            }
            return objectArray3;
        }
        return objectArray;
    }

    protected Map handleAttributes(Map map) {
        Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
        CellView[] cellViewArray = new CellView[map.size()];
        Iterator iterator = map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            CellView cellView;
            Map.Entry entry = iterator.next();
            cellViewArray[n] = cellView = this.getMapping(entry.getKey(), false);
            ++n;
            if (cellView == null) continue;
            AttributeMap attributeMap = (AttributeMap)entry.getValue();
            AttributeMap attributeMap2 = cellView.setAttributes(attributeMap);
            cellView.refresh(false);
            hashtable.put(cellView.getCell(), attributeMap2);
            this.factory.updateAutoSize(this.getGraph(), cellView);
        }
        this.update(cellViewArray);
        return hashtable;
    }

    public static void translateViews(CellView[] cellViewArray, double d, double d2) {
        cellViewArray = AbstractCellView.getDescendantViews(cellViewArray);
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n].isLeaf()) {
                cellViewArray[n].getAllAttributes().translate(d, d2);
            }
            ++n;
        }
    }

    public CellView[] getAllDescendants(CellView[] cellViewArray) {
        Object object;
        Stack<CellView> stack = new Stack<CellView>();
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n] != null) {
                stack.add(cellViewArray[n]);
            }
            ++n;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (!stack.isEmpty()) {
            object = (CellView)stack.pop();
            CellView[] cellViewArray2 = object.getChildViews();
            int n2 = 0;
            while (n2 < cellViewArray2.length) {
                stack.add(cellViewArray2[n2]);
                ++n2;
            }
            arrayList.add(object);
            int n3 = 0;
            while (n3 < this.graphModel.getChildCount(object.getCell())) {
                CellView cellView;
                Object object2 = this.graphModel.getChild(object.getCell(), n3);
                if (this.graphModel.isPort(object2) && (cellView = this.getMapping(object2, false)) != null) {
                    stack.add(cellView);
                }
                ++n3;
            }
        }
        object = new CellView[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public Map getHiddenSet() {
        return this.hiddenSet;
    }

    public boolean isHideEdgesOnBecomeInvisible() {
        return this.hideEdgesOnBecomeInvisible;
    }

    public boolean isHideEdgesOnHide() {
        return this.hideEdgesOnHide;
    }

    public boolean isRememberCellViews() {
        return this.rememberCellViews;
    }

    public boolean isShowAllEdgesForVisibleVertices() {
        return this.showAllEdgesForVisibleVertices;
    }

    public boolean isShowEdgesOnShow() {
        return this.showEdgesOnShow;
    }

    public void setHiddenSet(Map map) {
        this.hiddenSet = map;
    }

    public void setHideEdgesOnBecomeInvisible(boolean bl) {
        this.hideEdgesOnBecomeInvisible = bl;
    }

    public void setHideEdgesOnHide(boolean bl) {
        this.hideEdgesOnHide = bl;
    }

    public void setRememberCellViews(boolean bl) {
        this.rememberCellViews = bl;
    }

    public void setShowAllEdgesForVisibleVertices(boolean bl) {
        this.showAllEdgesForVisibleVertices = bl;
    }

    public void setShowEdgesOnShow(boolean bl) {
        this.showEdgesOnShow = bl;
    }

    public Set getLocalAttributes() {
        return this.localAttributes;
    }

    public void setLocalAttributes(Set set) {
        this.localAttributes = set;
    }

    public boolean isAskLocalAttribute() {
        return this.askLocalAttribute;
    }

    public void setAskLocalAttribute(boolean bl) {
        this.askLocalAttribute = bl;
    }

    public static class GraphViewLayerEdit
    extends AbstractUndoableEdit
    implements GraphModelEvent.GraphViewChange,
    GraphModelEvent.ExecutableGraphChange {
        public static final int FRONT = -1;
        public static final int BACK = -2;
        protected Object changeSource;
        protected transient Object[] cells;
        protected transient int[] next;
        protected transient int[] prev;
        protected int layer;

        public GraphViewLayerEdit(Object object, Object[] objectArray, int n) {
            this.changeSource = object;
            this.cells = objectArray;
            this.layer = n;
            this.next = new int[objectArray.length];
            this.prev = new int[objectArray.length];
            this.updateNext();
        }

        protected void updateNext() {
            int n = 0;
            while (n < this.next.length) {
                this.next[n] = this.layer;
                ++n;
            }
        }

        public Object getSource() {
            return this.changeSource;
        }

        public Object[] getChanged() {
            return this.cells;
        }

        public Object[] getContext() {
            return null;
        }

        public Map getAttributes() {
            return null;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.updateNext();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            int n = 0;
            while (n < this.cells.length) {
                List list = this.getParentList(this.cells[n]);
                if (list != null) {
                    this.prev[n] = list.indexOf(this.cells[n]);
                    if (this.prev[n] >= 0) {
                        list.remove(this.prev[n]);
                        int n2 = this.next[n];
                        if (n2 == -1) {
                            n2 = list.size();
                        } else if (n2 == -2) {
                            n2 = 0;
                        }
                        list.add(n2, this.cells[n]);
                        this.next[n] = this.prev[n];
                    }
                }
                ++n;
            }
            this.updateListeners();
        }

        protected void updateListeners() {
            ((GraphLayoutCache)this.changeSource).setChanged();
            ((GraphLayoutCache)this.changeSource).notifyObservers(this);
        }

        protected List getParentList(Object object) {
            if (object instanceof CellView) {
                CellView cellView = ((CellView)object).getParentView();
                List list = null;
                if (cellView == null) {
                    list = ((GraphLayoutCache)this.changeSource).roots;
                } else if (cellView instanceof AbstractCellView) {
                    list = ((AbstractCellView)cellView).childViews;
                }
                return list;
            }
            return null;
        }
    }

    public class GraphViewEdit
    extends CompoundEdit
    implements GraphModelEvent.GraphViewChange,
    GraphModelEvent.ExecutableGraphChange {
        protected Object[] cells;
        protected CellView[] context;
        protected CellView[] hidden;
        protected Map attributes;
        protected Object[] visible;
        protected Object[] invisible;

        public GraphViewEdit(Map map) {
            this(map, null, null);
            this.attributes = map;
        }

        public GraphViewEdit(Map map, Object[] objectArray, Object[] objectArray2) {
            this.attributes = map;
            if (map != null) {
                this.cells = map.keySet().toArray();
                Set set = DefaultGraphModel.getEdges(GraphLayoutCache.this.getModel(), this.cells);
                this.context = GraphLayoutCache.this.getMapping(set.toArray());
            }
            this.visible = objectArray;
            this.invisible = objectArray2;
        }

        public boolean isSignificant() {
            return true;
        }

        public Object getSource() {
            return GraphLayoutCache.this;
        }

        public Object[] getChanged() {
            if (this.attributes != null) {
                return this.attributes.keySet().toArray();
            }
            return null;
        }

        public Object[] getContext() {
            return this.context;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            if (this.hidden != null) {
                int n = 0;
                while (n < this.hidden.length) {
                    if (this.hidden[n] != null) {
                        GraphLayoutCache.this.mapping.put(this.hidden[n].getCell(), this.hidden[n]);
                    }
                    ++n;
                }
            }
            if (!GraphLayoutCache.this.rememberCellViews) {
                this.hidden = GraphLayoutCache.this.getMapping(this.invisible);
            }
            boolean bl = GraphLayoutCache.this.setVisibleImpl(this.visible, true) | GraphLayoutCache.this.setVisibleImpl(this.invisible, false);
            Object[] objectArray = this.visible;
            this.visible = this.invisible;
            this.invisible = objectArray;
            if (this.attributes != null) {
                this.attributes = GraphLayoutCache.this.handleAttributes(this.attributes);
            }
            if (bl) {
                GraphLayoutCache.this.updatePorts();
            }
            if (this.context != null) {
                int n = 0;
                while (n < this.context.length) {
                    if (this.context[n] != null) {
                        this.context[n].refresh(false);
                    }
                    ++n;
                }
            }
            GraphLayoutCache.this.setChanged();
            GraphLayoutCache.this.notifyObservers(this);
        }
    }
}

