/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.packaging.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.ow2.easybeans.component.util.Property;
import org.ow2.jonas.Version;
import org.ow2.jonas.addon.deploy.impl.xml.JonasAddonDesc;
import org.ow2.jonas.addon.deploy.jonasaddon.v1.generated.JonasAddonType;
import org.ow2.jonas.addon.deploy.jonasaddon.v1.generated.ObjectFactory;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.jpaas.util.clouddescriptors.cloudapplication.CloudApplicationDesc;
import org.ow2.jonas.jpaas.util.clouddescriptors.cloudapplication.artefact.v1.generated.ArtefactDeployableType;
import org.ow2.jonas.jpaas.util.clouddescriptors.cloudapplication.artefact.v1.generated.RequirementsType;
import org.ow2.jonas.jpaas.util.clouddescriptors.cloudapplication.v1.generated.CloudApplicationType;
import org.ow2.jonas.jpaas.util.clouddescriptors.cloudapplication.v1.generated.DeployablesType;
import org.ow2.jonas.jpaas.util.clouddescriptors.cloudapplication.xml.v1.generated.XmlDeployableType;
import org.ow2.jonas.jpaas.util.clouddescriptors.deployment.DeploymentDesc;
import org.ow2.jonas.jpaas.util.clouddescriptors.deployment.v1.generated.DeploymentType;
import org.ow2.jonas.jpaas.util.clouddescriptors.environmenttemplate.EnvironmentTemplateDesc;
import org.ow2.jonas.jpaas.util.clouddescriptors.environmenttemplate.v1.generated.EnvironmentTemplateType;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.packaging.IPackagingManager;
import org.ow2.jonas.packaging.IPackagingStructure;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.bindings.deploymentplan.DeploymentPlan;
import org.ow2.util.plan.bindings.deploymentplan.ExtendedDeploymentPlan;
import org.ow2.util.plan.bindings.deploymentplan.maven2.Maven2Deployment;

public class PackagingManager
extends AbsServiceImpl
implements IPackagingManager,
IPackagingStructure,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(PackagingManager.class);
    private static JmxService jmxService = null;
    private static final Pattern BASENAME_PATTERN = Pattern.compile(".*?([^/]*)$");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\(.*=.*\\)");
    private boolean __Fcollocated;
    private Map<String, List<String>> collocated;
    private boolean __FnotCollocated;
    private Map<String, List<String>> notCollocated;
    private boolean __Fdeployables;
    private Map<String, Object> deployables;
    private static final String COLLOCATED_TO_PROPERTY_NAME = "collocated-to";
    private static final String NOT_COLLOCATED_TO_PROPERTY_NAME = "not-collocated-to";
    private static final String GROUP_ID = "org.ow2.jonas.jpaas";
    private boolean __Fgraph;
    UndirectedGraph<String, DefaultEdge> graph;
    private static final String JONAS_BASE = JProp.getJonasBase();
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __MgenerateAddon$java_net_URL$java_lang_String;
    private boolean __MgenerateAddon$java_net_URL$java_lang_String$java_lang_String;
    private boolean __MgenerateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL;
    private boolean __MgenerateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL$java_lang_String;
    private boolean __MgenerateAddon$java_lang_String$java_lang_String;
    private boolean __MgenerateAddon$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MgenerateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MgenerateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MgetListOf$java_lang_String$java_util_List;
    private boolean __MisProperty$java_lang_String;
    private boolean __MgetProperty$java_lang_String;
    private boolean __MmakeZipPackages;
    private boolean __MaddVertex$java_lang_String$java_util_List;
    private boolean __McheckConstraintsCompatibility$java_util_Set;
    private boolean __MconnectedComponentsGarbageCollector;
    private boolean __McanCollocate$java_util_List$java_util_List;
    private boolean __MmakeJonasAddon$org_ow2_jonas_jpaas_util_clouddescriptors_cloudapplication_v1_generated_CloudApplicationType$java_lang_String$java_util_zip_ZipOutputStream;
    private boolean __MupdateArtefactDeployableName$java_lang_String$java_lang_String;
    private boolean __MupdateDeployableZipEntryName$java_lang_String$java_lang_String$java_lang_String;
    private boolean __McreateWorkAddonsDir;

    Map __getcollocated() {
        if (!this.__Fcollocated) {
            return this.collocated;
        }
        return (Map)this.__IM.onGet((Object)this, "collocated");
    }

    void __setcollocated(Map map) {
        if (!this.__Fcollocated) {
            this.collocated = map;
            return;
        }
        this.__IM.onSet((Object)this, "collocated", (Object)map);
    }

    Map __getnotCollocated() {
        if (!this.__FnotCollocated) {
            return this.notCollocated;
        }
        return (Map)this.__IM.onGet((Object)this, "notCollocated");
    }

    void __setnotCollocated(Map map) {
        if (!this.__FnotCollocated) {
            this.notCollocated = map;
            return;
        }
        this.__IM.onSet((Object)this, "notCollocated", (Object)map);
    }

    Map __getdeployables() {
        if (!this.__Fdeployables) {
            return this.deployables;
        }
        return (Map)this.__IM.onGet((Object)this, "deployables");
    }

    void __setdeployables(Map map) {
        if (!this.__Fdeployables) {
            this.deployables = map;
            return;
        }
        this.__IM.onSet((Object)this, "deployables", (Object)map);
    }

    UndirectedGraph __getgraph() {
        if (!this.__Fgraph) {
            return this.graph;
        }
        return (UndirectedGraph)this.__IM.onGet((Object)this, "graph");
    }

    void __setgraph(UndirectedGraph undirectedGraph) {
        if (!this.__Fgraph) {
            this.graph = undirectedGraph;
            return;
        }
        this.__IM.onSet((Object)this, "graph", (Object)undirectedGraph);
    }

    public PackagingManager() {
        this(null);
    }

    private PackagingManager(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setcollocated(new LinkedHashMap());
        this.__setnotCollocated(new LinkedHashMap());
        this.__setdeployables(new LinkedHashMap());
        this.__setgraph(new SimpleGraph(DefaultEdge.class));
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__M_setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__M_setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __M_setJmxService(JmxService jmxService) {
        PackagingManager.jmxService = jmxService;
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__M_doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__M_doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __M_doStart() throws ServiceException {
        jmxService.loadDescriptors(((Object)((Object)this)).getClass().getPackage().getName(), ((Object)((Object)this)).getClass().getClassLoader());
        try {
            jmxService.registerModelMBean((Object)this, JonasObjectName.packaging((String)this.getDomainName()));
        }
        catch (Exception e) {
            throw new ServiceException("Cannot register 'packaging' service MBean", (Throwable)e);
        }
        logger.info((Object)"Packaging service management bean has been registered successfully", new Object[0]);
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__M_doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__M_doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __M_doStop() throws ServiceException {
    }

    public List<String> generateAddon(URL urlCloudApplication, String tenantId) throws Exception {
        List<String> list;
        if (!this.__MgenerateAddon$java_net_URL$java_lang_String) {
            return this.__M_generateAddon(urlCloudApplication, tenantId);
        }
        try {
            this.__IM.onEntry((Object)this, "generateAddon$java_net_URL$java_lang_String", new Object[]{urlCloudApplication, tenantId});
            list = this.__M_generateAddon(urlCloudApplication, tenantId);
            this.__IM.onExit((Object)this, "generateAddon$java_net_URL$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateAddon$java_net_URL$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_generateAddon(URL urlCloudApplication, String tenantId) throws Exception {
        return this.generateAddon(PackagingManager.readURL(urlCloudApplication), tenantId, "", "", "");
    }

    public List<String> generateAddon(URL urlCloudApplication, String tenantId, String outputDir) throws Exception {
        List<String> list;
        if (!this.__MgenerateAddon$java_net_URL$java_lang_String$java_lang_String) {
            return this.__M_generateAddon(urlCloudApplication, tenantId, outputDir);
        }
        try {
            this.__IM.onEntry((Object)this, "generateAddon$java_net_URL$java_lang_String$java_lang_String", new Object[]{urlCloudApplication, tenantId, outputDir});
            list = this.__M_generateAddon(urlCloudApplication, tenantId, outputDir);
            this.__IM.onExit((Object)this, "generateAddon$java_net_URL$java_lang_String$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateAddon$java_net_URL$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_generateAddon(URL urlCloudApplication, String tenantId, String outputDir) throws Exception {
        return this.generateAddon(PackagingManager.readURL(urlCloudApplication), tenantId, "", "", outputDir);
    }

    public List<String> generateAddon(URL urlCloudApplication, String tenantId, URL urlEnvironmentTemplate, URL urlMappingTopology) throws Exception {
        List<String> list;
        if (!this.__MgenerateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL) {
            return this.__M_generateAddon(urlCloudApplication, tenantId, urlEnvironmentTemplate, urlMappingTopology);
        }
        try {
            this.__IM.onEntry((Object)this, "generateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL", new Object[]{urlCloudApplication, tenantId, urlEnvironmentTemplate, urlMappingTopology});
            list = this.__M_generateAddon(urlCloudApplication, tenantId, urlEnvironmentTemplate, urlMappingTopology);
            this.__IM.onExit((Object)this, "generateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_generateAddon(URL urlCloudApplication, String tenantId, URL urlEnvironmentTemplate, URL urlMappingTopology) throws Exception {
        return this.generateAddon(PackagingManager.readURL(urlCloudApplication), tenantId, PackagingManager.readURL(urlEnvironmentTemplate), PackagingManager.readURL(urlMappingTopology), "");
    }

    public List<String> generateAddon(URL urlCloudApplication, String tenantId, URL urlEnvironmentTemplate, URL urlMappingTopology, String outputDir) throws Exception {
        List<String> list;
        if (!this.__MgenerateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL$java_lang_String) {
            return this.__M_generateAddon(urlCloudApplication, tenantId, urlEnvironmentTemplate, urlMappingTopology, outputDir);
        }
        try {
            this.__IM.onEntry((Object)this, "generateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL$java_lang_String", new Object[]{urlCloudApplication, tenantId, urlEnvironmentTemplate, urlMappingTopology, outputDir});
            list = this.__M_generateAddon(urlCloudApplication, tenantId, urlEnvironmentTemplate, urlMappingTopology, outputDir);
            this.__IM.onExit((Object)this, "generateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_generateAddon(URL urlCloudApplication, String tenantId, URL urlEnvironmentTemplate, URL urlMappingTopology, String outputDir) throws Exception {
        return this.generateAddon(PackagingManager.readURL(urlCloudApplication), tenantId, PackagingManager.readURL(urlEnvironmentTemplate), PackagingManager.readURL(urlMappingTopology), outputDir);
    }

    public List<String> generateAddon(String xmlCloudApplication, String tenantId) throws Exception {
        List<String> list;
        if (!this.__MgenerateAddon$java_lang_String$java_lang_String) {
            return this.__M_generateAddon(xmlCloudApplication, tenantId);
        }
        try {
            this.__IM.onEntry((Object)this, "generateAddon$java_lang_String$java_lang_String", new Object[]{xmlCloudApplication, tenantId});
            list = this.__M_generateAddon(xmlCloudApplication, tenantId);
            this.__IM.onExit((Object)this, "generateAddon$java_lang_String$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateAddon$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_generateAddon(String xmlCloudApplication, String tenantId) throws Exception {
        return this.generateAddon(xmlCloudApplication, tenantId, "", "", "");
    }

    public List<String> generateAddon(String xmlCloudApplication, String tenantId, String outputDir) throws Exception {
        List<String> list;
        if (!this.__MgenerateAddon$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_generateAddon(xmlCloudApplication, tenantId, outputDir);
        }
        try {
            this.__IM.onEntry((Object)this, "generateAddon$java_lang_String$java_lang_String$java_lang_String", new Object[]{xmlCloudApplication, tenantId, outputDir});
            list = this.__M_generateAddon(xmlCloudApplication, tenantId, outputDir);
            this.__IM.onExit((Object)this, "generateAddon$java_lang_String$java_lang_String$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateAddon$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_generateAddon(String xmlCloudApplication, String tenantId, String outputDir) throws Exception {
        return this.generateAddon(xmlCloudApplication, tenantId, "", "", outputDir);
    }

    public List<String> generateAddon(String xmlCloudApplication, String tenantId, String xmlEnvironmentTemplate, String xmlMappingTopology) throws Exception {
        List<String> list;
        if (!this.__MgenerateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_generateAddon(xmlCloudApplication, tenantId, xmlEnvironmentTemplate, xmlMappingTopology);
        }
        try {
            this.__IM.onEntry((Object)this, "generateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{xmlCloudApplication, tenantId, xmlEnvironmentTemplate, xmlMappingTopology});
            list = this.__M_generateAddon(xmlCloudApplication, tenantId, xmlEnvironmentTemplate, xmlMappingTopology);
            this.__IM.onExit((Object)this, "generateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_generateAddon(String xmlCloudApplication, String tenantId, String xmlEnvironmentTemplate, String xmlMappingTopology) throws Exception {
        return this.generateAddon(xmlCloudApplication, tenantId, xmlEnvironmentTemplate, xmlMappingTopology, "");
    }

    public List<String> generateAddon(String xmlCloudApplication, String tenantId, String xmlEnvironmentTemplate, String xmlMappingTopology, String outputDir) throws Exception {
        List<String> list;
        if (!this.__MgenerateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_generateAddon(xmlCloudApplication, tenantId, xmlEnvironmentTemplate, xmlMappingTopology, outputDir);
        }
        try {
            this.__IM.onEntry((Object)this, "generateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", new Object[]{xmlCloudApplication, tenantId, xmlEnvironmentTemplate, xmlMappingTopology, outputDir});
            list = this.__M_generateAddon(xmlCloudApplication, tenantId, xmlEnvironmentTemplate, xmlMappingTopology, outputDir);
            this.__IM.onExit((Object)this, "generateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> __M_generateAddon(String xmlCloudApplication, String tenantId, String xmlEnvironmentTemplate, String xmlMappingTopology, String outputDir) throws Exception {
        String zipsDir;
        if (tenantId == null || "".equals(tenantId)) {
            logger.warn((Object)"The tenant identifier of this application is null !", new Object[0]);
        }
        CloudApplicationDesc cloudApplicationDesc = new CloudApplicationDesc(xmlCloudApplication);
        CloudApplicationType cloudApplication = (CloudApplicationType)cloudApplicationDesc.getCloudApplication();
        EnvironmentTemplateDesc environmentTemplateDesc = null;
        EnvironmentTemplateType environmentTemplate = null;
        DeploymentDesc deploymentDesc = null;
        DeploymentType deploymentType = null;
        if (!"".equals(xmlEnvironmentTemplate)) {
            environmentTemplateDesc = new EnvironmentTemplateDesc(xmlEnvironmentTemplate);
            environmentTemplate = (EnvironmentTemplateType)environmentTemplateDesc.getEnvironmentTemplate();
        }
        if (!"".equals(xmlMappingTopology)) {
            deploymentDesc = new DeploymentDesc(xmlMappingTopology);
            deploymentType = (DeploymentType)deploymentDesc.getDeployment();
        }
        DeployablesType deployables = cloudApplication.getDeployables();
        List listDeployables = deployables.getDeployables();
        for (Object deployable : listDeployables) {
            RequirementsType requirements;
            String id = null;
            List listRequirements = null;
            if (deployable instanceof ArtefactDeployableType) {
                ArtefactDeployableType artefactDeployable = (ArtefactDeployableType)deployable;
                id = artefactDeployable.getId();
                requirements = artefactDeployable.getRequirements();
                listRequirements = requirements.getRequirement();
            } else if (deployable instanceof XmlDeployableType) {
                XmlDeployableType xmlDeployable = (XmlDeployableType)deployable;
                id = xmlDeployable.getId();
                requirements = xmlDeployable.getRequirements();
                listRequirements = requirements.getRequirement();
            }
            if (id == null || listRequirements == null) continue;
            this.__getdeployables().put(id, deployable);
            this.__getcollocated().put(id, this.getListOf(COLLOCATED_TO_PROPERTY_NAME, listRequirements));
            this.__getnotCollocated().put(id, this.getListOf(NOT_COLLOCATED_TO_PROPERTY_NAME, listRequirements));
        }
        List<Set<String>> packages = this.makeZipPackages();
        System.gc();
        int i = 1;
        String zipNamePrefix = cloudApplication.getName() + "_";
        if (tenantId != null && !"".equals(tenantId)) {
            zipNamePrefix = zipNamePrefix + tenantId + "_";
        }
        LinkedHashMap zips = new LinkedHashMap();
        for (Set<String> zipPackage : packages) {
            LinkedList zipDeployables = new LinkedList();
            zips.put(zipNamePrefix + i, zipDeployables);
            ++i;
            for (String deployable : zipPackage) {
                zipDeployables.add(this.__getdeployables().get(deployable));
            }
        }
        LinkedList<String> zipsLocations = new LinkedList<String>();
        if ("".equals(outputDir)) {
            this.createWorkAddonsDir();
            zipsDir = JONAS_BASE + File.separator + ADDONS_DIR;
        } else {
            if (!new File(outputDir).exists()) {
                logger.error((Object)("No such file or directory for the URL ''" + outputDir + "''"), new Object[0]);
            }
            zipsDir = outputDir;
        }
        for (Map.Entry zip : zips.entrySet()) {
            String zipName = zipsDir + File.separator + (String)zip.getKey() + ".zip";
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipName));
            ExtendedDeploymentPlan deploymentPlan = new ExtendedDeploymentPlan();
            List deployments = deploymentPlan.getDeployments();
            byte[] buf = new byte[1024];
            try {
                for (Object deployable : (List)zip.getValue()) {
                    String zipEntryName = "repository" + File.separator + PackagingManager.groupIdPath(GROUP_ID) + File.separator;
                    String artifact = null;
                    String type = null;
                    byte[] content = null;
                    if (deployable instanceof ArtefactDeployableType) {
                        String path = ((ArtefactDeployableType)deployable).getLocation();
                        File file = new File(path);
                        if (!file.exists()) {
                            throw new Exception("File '" + file.getPath() + "' was not found.");
                        }
                        byte[] b = new byte[(int)file.length()];
                        FileInputStream in = new FileInputStream(file.getPath());
                        in.read(b);
                        content = b;
                        artifact = this.updateArtefactDeployableName(((ArtefactDeployableType)deployable).getName(), tenantId);
                        type = PackagingManager.getExtension(file.getPath());
                    } else if (deployable instanceof XmlDeployableType) {
                        content = ((XmlDeployableType)deployable).getXmlContent().getBytes();
                        artifact = ((XmlDeployableType)deployable).getName();
                        type = "xml";
                    }
                    if (artifact != null && type != null && content != null) {
                        zipEntryName = zipEntryName + artifact + File.separator + cloudApplication.getVersion() + File.separator + this.updateDeployableZipEntryName(artifact, cloudApplication.getVersion(), type);
                        out.putNextEntry(new ZipEntry(zipEntryName));
                        out.write(content, 0, content.length);
                        out.closeEntry();
                        Maven2Deployment maven2Deployment = new Maven2Deployment();
                        maven2Deployment.setGroupId(GROUP_ID);
                        maven2Deployment.setArtifactId(artifact);
                        maven2Deployment.setVersion(cloudApplication.getVersion());
                        maven2Deployment.setType(type);
                        maven2Deployment.setIdAttr(PackagingManager.basename(zipEntryName));
                        deployments.add(maven2Deployment);
                        continue;
                    }
                    throw new Exception("Cannot create zip entry '" + zipEntryName + "'.");
                }
                org.ow2.util.plan.bindings.deploymentplan.ObjectFactory depPlanObjectFactory = new org.ow2.util.plan.bindings.deploymentplan.ObjectFactory();
                String deploymentPlanFileName = "deploy" + File.separator + "plan";
                if (tenantId != null && !"".equals(tenantId)) {
                    deploymentPlanFileName = deploymentPlanFileName + tenantId;
                }
                deploymentPlanFileName = deploymentPlanFileName + ".xml";
                out.putNextEntry(new ZipEntry(deploymentPlanFileName));
                PackagingManager.generateXml(depPlanObjectFactory.createDeploymentPlan((DeploymentPlan)deploymentPlan), out, ExtendedDeploymentPlan.class);
                out.closeEntry();
                this.makeJonasAddon(cloudApplication, tenantId, out);
                String cloudApplicationFileName = "deploy" + File.separator + "cloud-application";
                if (tenantId != null && !"".equals(tenantId)) {
                    cloudApplicationFileName = cloudApplicationFileName + "_" + tenantId;
                }
                cloudApplicationFileName = cloudApplicationFileName + ".xml";
                out.putNextEntry(new ZipEntry(cloudApplicationFileName));
                out.write(xmlCloudApplication.getBytes());
                out.closeEntry();
                if (!"".equals(xmlEnvironmentTemplate)) {
                    String environmentTemplateFileName = "deploy" + File.separator + "environment-template";
                    if (tenantId != null && !"".equals(tenantId)) {
                        environmentTemplateFileName = environmentTemplateFileName + "_" + tenantId;
                    }
                    environmentTemplateFileName = environmentTemplateFileName + ".xml";
                    out.putNextEntry(new ZipEntry(environmentTemplateFileName));
                    out.write(xmlEnvironmentTemplate.getBytes());
                    out.closeEntry();
                }
                if (!"".equals(xmlMappingTopology)) {
                    String deploymentFileName = "deploy" + File.separator + "deployment";
                    if (tenantId != null && !"".equals(tenantId)) {
                        deploymentFileName = deploymentFileName + "_" + tenantId;
                    }
                    deploymentFileName = deploymentFileName + ".xml";
                    out.putNextEntry(new ZipEntry(deploymentFileName));
                    out.write(xmlMappingTopology.getBytes());
                    out.closeEntry();
                }
                logger.info((Object)("Addon generated '" + zipName + "'."), new Object[0]);
            }
            finally {
                out.close();
            }
            zipsLocations.add(zipName);
        }
        return zipsLocations;
    }

    private List<String> getListOf(String p, List<String> requirements) {
        List<String> list;
        if (!this.__MgetListOf$java_lang_String$java_util_List) {
            return this.__M_getListOf(p, requirements);
        }
        try {
            this.__IM.onEntry((Object)this, "getListOf$java_lang_String$java_util_List", new Object[]{p, requirements});
            list = this.__M_getListOf(p, requirements);
            this.__IM.onExit((Object)this, "getListOf$java_lang_String$java_util_List", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getListOf$java_lang_String$java_util_List", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __M_getListOf(String p, List<String> requirements) {
        LinkedList<String> list = new LinkedList<String>();
        for (String requirement : requirements) {
            Property property;
            if (!this.isProperty(requirement) || !p.equals((property = this.getProperty(requirement)).getName())) continue;
            list.add(property.getValue());
        }
        return list;
    }

    private boolean isProperty(String requirement) {
        boolean bl;
        if (!this.__MisProperty$java_lang_String) {
            return this.__M_isProperty(requirement);
        }
        try {
            this.__IM.onEntry((Object)this, "isProperty$java_lang_String", new Object[]{requirement});
            bl = this.__M_isProperty(requirement);
            this.__IM.onExit((Object)this, "isProperty$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isProperty$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isProperty(String requirement) {
        return PROPERTY_PATTERN.matcher(requirement).matches();
    }

    private Property getProperty(String requirement) {
        Property property;
        if (!this.__MgetProperty$java_lang_String) {
            return this.__M_getProperty(requirement);
        }
        try {
            this.__IM.onEntry((Object)this, "getProperty$java_lang_String", new Object[]{requirement});
            property = this.__M_getProperty(requirement);
            this.__IM.onExit((Object)this, "getProperty$java_lang_String", (Object)property);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProperty$java_lang_String", throwable);
            throw throwable;
        }
        return property;
    }

    private Property __M_getProperty(String requirement) {
        Property property = new Property();
        String name = requirement.substring(requirement.indexOf(40) + 1, requirement.indexOf(61));
        String value = requirement.substring(requirement.indexOf(61) + 1, requirement.indexOf(41));
        property.setName(name);
        property.setValue(value);
        return property;
    }

    private List<Set<String>> makeZipPackages() throws Exception {
        List<Set<String>> list;
        if (!this.__MmakeZipPackages) {
            return this.__M_makeZipPackages();
        }
        try {
            this.__IM.onEntry((Object)this, "makeZipPackages", new Object[0]);
            list = this.__M_makeZipPackages();
            this.__IM.onExit((Object)this, "makeZipPackages", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "makeZipPackages", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Set<String>> __M_makeZipPackages() throws Exception {
        for (Map.Entry entry : this.__getcollocated().entrySet()) {
            this.addVertex((String)entry.getKey(), (List)entry.getValue());
        }
        List connectedComponents = new ConnectivityInspector(this.__getgraph()).connectedSets();
        for (Set<String> set : connectedComponents) {
            this.checkConstraintsCompatibility(set);
        }
        this.connectedComponentsGarbageCollector();
        return new ConnectivityInspector(this.__getgraph()).connectedSets();
    }

    private void addVertex(String vertex, List<String> edges) throws Exception {
        if (!this.__MaddVertex$java_lang_String$java_util_List) {
            this.__M_addVertex(vertex, edges);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addVertex$java_lang_String$java_util_List", new Object[]{vertex, edges});
            this.__M_addVertex(vertex, edges);
            this.__IM.onExit((Object)this, "addVertex$java_lang_String$java_util_List", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addVertex$java_lang_String$java_util_List", throwable);
            throw throwable;
        }
    }

    private void __M_addVertex(String vertex, List<String> edges) throws Exception {
        if (!this.__getgraph().containsVertex(vertex)) {
            this.__getgraph().addVertex(vertex);
        }
        for (String edgeVertex : edges) {
            if (this.__getdeployables().get(vertex) == null) {
                throw new Exception("Deployable with the name '" + vertex + "' was not found.");
            }
            if (this.__getgraph().containsVertex(edgeVertex)) continue;
            this.__getgraph().addVertex(edgeVertex);
        }
        for (String edge : edges) {
            this.__getgraph().addEdge(vertex, edge);
        }
    }

    private void checkConstraintsCompatibility(Set<String> connectedComponent) throws Exception {
        if (!this.__McheckConstraintsCompatibility$java_util_Set) {
            this.__M_checkConstraintsCompatibility(connectedComponent);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "checkConstraintsCompatibility$java_util_Set", new Object[]{connectedComponent});
            this.__M_checkConstraintsCompatibility(connectedComponent);
            this.__IM.onExit((Object)this, "checkConstraintsCompatibility$java_util_Set", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkConstraintsCompatibility$java_util_Set", throwable);
            throw throwable;
        }
    }

    private void __M_checkConstraintsCompatibility(Set<String> connectedComponent) throws Exception {
        ConnectivityInspector connectivityInspector = new ConnectivityInspector(this.__getgraph());
        for (String vertex : connectedComponent) {
            if (this.__getdeployables().get(vertex) == null) {
                throw new Exception("Deployable with the name '" + vertex + "' was not found.");
            }
            List notCollocatedDeployables = (List)this.__getnotCollocated().get(vertex);
            for (String notCollocatedDeployable : notCollocatedDeployables) {
                if (!connectivityInspector.pathExists(vertex, notCollocatedDeployable)) continue;
                throw new Exception("Wrong constraint. '" + vertex + "' and '" + notCollocatedDeployable + "' cannot " + "be collocated");
            }
        }
    }

    private void connectedComponentsGarbageCollector() throws Exception {
        if (!this.__MconnectedComponentsGarbageCollector) {
            this.__M_connectedComponentsGarbageCollector();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "connectedComponentsGarbageCollector", new Object[0]);
            this.__M_connectedComponentsGarbageCollector();
            this.__IM.onExit((Object)this, "connectedComponentsGarbageCollector", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "connectedComponentsGarbageCollector", throwable);
            throw throwable;
        }
    }

    private void __M_connectedComponentsGarbageCollector() throws Exception {
        ConnectivityInspector connectivityInspector = new ConnectivityInspector(this.__getgraph());
        List connectedComponents = connectivityInspector.connectedSets();
        if (connectedComponents.size() > 1) {
            boolean merge = false;
            for (int i = 0; !merge && i < connectedComponents.size(); ++i) {
                LinkedList<String> toCollocate = new LinkedList<String>(connectedComponents.get(i));
                for (int j = i + 1; !merge && j < connectedComponents.size(); ++j) {
                    LinkedList<String> toTest = new LinkedList<String>(connectedComponents.get(j));
                    if (!this.canCollocate(toCollocate, toTest)) continue;
                    merge = true;
                    this.addVertex((String)toCollocate.get(0), toTest);
                }
            }
            if (merge) {
                this.connectedComponentsGarbageCollector();
            }
        }
    }

    private boolean canCollocate(List<String> listToCollocate, List<String> listToTest) {
        boolean bl;
        if (!this.__McanCollocate$java_util_List$java_util_List) {
            return this.__M_canCollocate(listToCollocate, listToTest);
        }
        try {
            this.__IM.onEntry((Object)this, "canCollocate$java_util_List$java_util_List", new Object[]{listToCollocate, listToTest});
            bl = this.__M_canCollocate(listToCollocate, listToTest);
            this.__IM.onExit((Object)this, "canCollocate$java_util_List$java_util_List", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "canCollocate$java_util_List$java_util_List", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_canCollocate(List<String> listToCollocate, List<String> listToTest) {
        for (String elementOnListToCollocate : listToCollocate) {
            List elementNotCollocated = (List)this.__getnotCollocated().get(elementOnListToCollocate);
            for (String elementOnListToTest : listToTest) {
                if (elementNotCollocated.contains(elementOnListToTest)) {
                    return false;
                }
                List elementTestNotCollocated = (List)this.__getnotCollocated().get(elementOnListToTest);
                if (!elementTestNotCollocated.contains(elementOnListToCollocate)) continue;
                return false;
            }
        }
        return true;
    }

    private void makeJonasAddon(CloudApplicationType cloudApplication, String tenantId, ZipOutputStream out) throws Exception {
        if (!this.__MmakeJonasAddon$org_ow2_jonas_jpaas_util_clouddescriptors_cloudapplication_v1_generated_CloudApplicationType$java_lang_String$java_util_zip_ZipOutputStream) {
            this.__M_makeJonasAddon(cloudApplication, tenantId, out);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "makeJonasAddon$org_ow2_jonas_jpaas_util_clouddescriptors_cloudapplication_v1_generated_CloudApplicationType$java_lang_String$java_util_zip_ZipOutputStream", new Object[]{cloudApplication, tenantId, out});
            this.__M_makeJonasAddon(cloudApplication, tenantId, out);
            this.__IM.onExit((Object)this, "makeJonasAddon$org_ow2_jonas_jpaas_util_clouddescriptors_cloudapplication_v1_generated_CloudApplicationType$java_lang_String$java_util_zip_ZipOutputStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "makeJonasAddon$org_ow2_jonas_jpaas_util_clouddescriptors_cloudapplication_v1_generated_CloudApplicationType$java_lang_String$java_util_zip_ZipOutputStream", throwable);
            throw throwable;
        }
    }

    private void __M_makeJonasAddon(CloudApplicationType cloudApplication, String tenantId, ZipOutputStream out) throws Exception {
        JonasAddonDesc jonasAddonDesc = new JonasAddonDesc();
        JonasAddonType jonasAddon = new JonasAddonType();
        if (tenantId != null && !"".equals(tenantId)) {
            jonasAddon.setName(cloudApplication.getName() + "_" + tenantId);
            jonasAddon.setTenantId(tenantId);
        } else {
            jonasAddon.setName(cloudApplication.getName());
        }
        if (cloudApplication.getInstance() != null && !"".equals(cloudApplication.getInstance())) {
            jonasAddon.setInstance(cloudApplication.getInstance());
        }
        if (cloudApplication.getDescription() != null && !"".equals(cloudApplication.getDescription())) {
            jonasAddon.setDescription(cloudApplication.getDescription());
        }
        jonasAddon.setAuthor("The JOnAS Team");
        jonasAddon.setLicence("LGPL");
        jonasAddon.setJonasVersion("[" + Version.getNumber() + "]");
        jonasAddon.setJvmVersion("[1.0,2.0]");
        if (cloudApplication.getCapabilities().getService() != null && !"".equals(cloudApplication.getCapabilities().getService())) {
            jonasAddon.setProvides(cloudApplication.getCapabilities().getService());
        } else {
            jonasAddon.setProvides("");
        }
        jonasAddon.setRequirements("");
        String jonasAddonFileName = "META-INF/jonas-addon.xml";
        out.putNextEntry(new ZipEntry(jonasAddonFileName));
        ObjectFactory objectFactory = new ObjectFactory();
        jonasAddonDesc.generateJonasAddon(objectFactory.createJonasAddon(jonasAddon), out);
        out.closeEntry();
    }

    private static void generateXml(JAXBElement<?> jaxbElement, ZipOutputStream out, Class<?> clazz) throws IOException, JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(jaxbElement, (OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readURL(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("No such file or directory for the URL ''" + url + "''"), new Object[0]);
        }
        try {
            String inputLine;
            StringBuilder sb = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(inputLine);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    private static String basename(String url) {
        Matcher matcher = BASENAME_PATTERN.matcher(url);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Can't parse " + url);
    }

    private static String groupIdPath(String groupId) {
        return groupId.replace(".", File.separator);
    }

    private String updateArtefactDeployableName(String name, String tenantId) {
        String string;
        if (!this.__MupdateArtefactDeployableName$java_lang_String$java_lang_String) {
            return this.__M_updateArtefactDeployableName(name, tenantId);
        }
        try {
            this.__IM.onEntry((Object)this, "updateArtefactDeployableName$java_lang_String$java_lang_String", new Object[]{name, tenantId});
            string = this.__M_updateArtefactDeployableName(name, tenantId);
            this.__IM.onExit((Object)this, "updateArtefactDeployableName$java_lang_String$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateArtefactDeployableName$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_updateArtefactDeployableName(String name, String tenantId) {
        if (tenantId != null && !"".equals(tenantId)) {
            return name + "_" + tenantId;
        }
        return name;
    }

    private String updateDeployableZipEntryName(String artifact, String version, String extension) {
        String string;
        if (!this.__MupdateDeployableZipEntryName$java_lang_String$java_lang_String$java_lang_String) {
            return this.__M_updateDeployableZipEntryName(artifact, version, extension);
        }
        try {
            this.__IM.onEntry((Object)this, "updateDeployableZipEntryName$java_lang_String$java_lang_String$java_lang_String", new Object[]{artifact, version, extension});
            string = this.__M_updateDeployableZipEntryName(artifact, version, extension);
            this.__IM.onExit((Object)this, "updateDeployableZipEntryName$java_lang_String$java_lang_String$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateDeployableZipEntryName$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_updateDeployableZipEntryName(String artifact, String version, String extension) {
        return artifact + "-" + version + "." + extension;
    }

    private static String getExtension(String filename) {
        return filename.substring(filename.lastIndexOf(46) + 1);
    }

    private void createWorkAddonsDir() throws Exception {
        if (!this.__McreateWorkAddonsDir) {
            this.__M_createWorkAddonsDir();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createWorkAddonsDir", new Object[0]);
            this.__M_createWorkAddonsDir();
            this.__IM.onExit((Object)this, "createWorkAddonsDir", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createWorkAddonsDir", throwable);
            throw throwable;
        }
    }

    private void __M_createWorkAddonsDir() throws Exception {
        File work = new File(JONAS_BASE + File.separator + "work");
        if (!work.exists() && !work.mkdir()) {
            throw new Exception("Fail when creating 'work' directory");
        }
        File addons = new File(JONAS_BASE + File.separator + ADDONS_DIR);
        if (!addons.exists() && !addons.mkdir()) {
            throw new Exception("Fail when creating '" + ADDONS_DIR + "' directory");
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("collocated")) {
                this.__Fcollocated = true;
            }
            if (set.contains("deployables")) {
                this.__Fdeployables = true;
            }
            if (set.contains("graph")) {
                this.__Fgraph = true;
            }
            if (set.contains("notCollocated")) {
                this.__FnotCollocated = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("generateAddon$java_net_URL$java_lang_String")) {
                this.__MgenerateAddon$java_net_URL$java_lang_String = true;
            }
            if (set.contains("generateAddon$java_net_URL$java_lang_String$java_lang_String")) {
                this.__MgenerateAddon$java_net_URL$java_lang_String$java_lang_String = true;
            }
            if (set.contains("generateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL")) {
                this.__MgenerateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL = true;
            }
            if (set.contains("generateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL$java_lang_String")) {
                this.__MgenerateAddon$java_net_URL$java_lang_String$java_net_URL$java_net_URL$java_lang_String = true;
            }
            if (set.contains("generateAddon$java_lang_String$java_lang_String")) {
                this.__MgenerateAddon$java_lang_String$java_lang_String = true;
            }
            if (set.contains("generateAddon$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MgenerateAddon$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("generateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MgenerateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("generateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MgenerateAddon$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getListOf$java_lang_String$java_util_List")) {
                this.__MgetListOf$java_lang_String$java_util_List = true;
            }
            if (set.contains("isProperty$java_lang_String")) {
                this.__MisProperty$java_lang_String = true;
            }
            if (set.contains("getProperty$java_lang_String")) {
                this.__MgetProperty$java_lang_String = true;
            }
            if (set.contains("makeZipPackages")) {
                this.__MmakeZipPackages = true;
            }
            if (set.contains("addVertex$java_lang_String$java_util_List")) {
                this.__MaddVertex$java_lang_String$java_util_List = true;
            }
            if (set.contains("checkConstraintsCompatibility$java_util_Set")) {
                this.__McheckConstraintsCompatibility$java_util_Set = true;
            }
            if (set.contains("connectedComponentsGarbageCollector")) {
                this.__MconnectedComponentsGarbageCollector = true;
            }
            if (set.contains("canCollocate$java_util_List$java_util_List")) {
                this.__McanCollocate$java_util_List$java_util_List = true;
            }
            if (set.contains("makeJonasAddon$org_ow2_jonas_jpaas_util_clouddescriptors_cloudapplication_v1_generated_CloudApplicationType$java_lang_String$java_util_zip_ZipOutputStream")) {
                this.__MmakeJonasAddon$org_ow2_jonas_jpaas_util_clouddescriptors_cloudapplication_v1_generated_CloudApplicationType$java_lang_String$java_util_zip_ZipOutputStream = true;
            }
            if (set.contains("updateArtefactDeployableName$java_lang_String$java_lang_String")) {
                this.__MupdateArtefactDeployableName$java_lang_String$java_lang_String = true;
            }
            if (set.contains("updateDeployableZipEntryName$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MupdateDeployableZipEntryName$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("createWorkAddonsDir")) {
                this.__McreateWorkAddonsDir = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

