/*
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer(s): ____________________________________.
 * Contributor(s): Michel Bruno and Guillaume Riviere
 *
 * --------------------------------------------------------------------------
 * $Id: JOnASResourceServiceMBean.java 12246 2007-12-09 21:42:38Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.resource.internal;

import java.rmi.RemoteException;

import java.util.List;
import java.util.Set;

import org.ow2.jonas.resource.ResourceServiceException;


/**
 * MBean Interface for Resource Service Management
 * MBean type: Standard
 * MBean model: Inheritance (ResourceServiceImpl)
 */
public interface JOnASResourceServiceMBean {

    /**
     * Deploy an RAR, used by the JMX Management.
     * @param fileName the fileName of the rar which must be be deployed.
     * @return The ObjectName of the MBean associated to the deployed J2EE Application
     * @throws RemoteException if rmi call failed.
     * @throws ResourceServiceException if the deployment of the RAR failed.
     */
    String deployRarMBean(String fileName) throws RemoteException, ResourceServiceException;


    /**
     * Undeploy an RAR, used by the JMX Management.
     * @param fileName the fileName of the rar which must be be undeployed.
     * @throws RemoteException if rmi call failed.
     * @throws ResourceServiceException if the undeployment of the RAR failed.
     */
    void unDeployRarMBean(String fileName) throws RemoteException, ResourceServiceException;

    /**
     * @return current number of rars deployed in the JOnAS server
     */
    Integer getCurrentNumberOfResource();

    /**
     * @return current number of rars deployed in the JOnAS server
     */
    Integer getCurrentNumberOfRars();

    /**
     * @return the list of RAR files found in JONAS_BASE/rars and in JONAS_BASE/rars/autoload
     * @throws Exception if error retrieving the list
     */
    List getInstalledRars() throws Exception;

    /**
     * This method is added temporarily. It will disapear when Rars will have their associated MBeans
     * (when Rars will become manageable)
     * @return the names of the rars currently deployed in the JOnAS server
     */
    Set getRarNames();


    /**
     * Return the list of "autoload" directories for RAR containers.
     * @return The list of all "autoload" directories
     */
    List getAutoloadDirectories();

    /**
     * Return the Rars directory.
     * @return The Rars directory
     */
    String getRarsDirectory();

    /**
     * @return the list of RAR files deployed
     * @throws Exception if error retrieving the list
     */
    List getDeployedRars() throws Exception;

    /**
     * Return the list of installed RAR container ready to deploy.
     *
     * @return The list of deployable RAR container
     * @throws Exception if error retrieving the list
     */
    List getDeployableRars() throws Exception;
}
