/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: Activator.java 12246 2007-12-09 21:42:38Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.resource.internal.osgi;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.resource.internal.JOnASResourceService;
import org.ow2.jonas.tm.TransactionService;
import org.ow2.jonas.workmanager.WorkManagerService;

/**
 * JOnAS JMX Service Activator.
 * @author Philippe Durieux
 * TODO Needs a better logging solution :)
 *
 * Currently not used because of LoaderManager that exit the JVM.
 */
public class Activator implements BundleActivator {

    /**
     * The service instance.
     */
    private JOnASResourceService resource;

    /**
     * Registration handler.
     */
    private ServiceRegistration myServiceRegistration;


    /**
     * Start JOnAS Resource Service Bundle.
     * @param bc OSGi {@link BundleContext}
     * @throws Exception when {@link ResourceService} startup has failed.
     * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
     */
    public void start(final BundleContext bc) throws Exception {
        System.out.println("Starting JOnAS Resource Service Bundle...");

        // Create the Service
        resource = new JOnASResourceService();

        // Get Configuration.
        ServiceReference sr = bc.getServiceReference(ServerProperties.class.getName());
        final ServerProperties props = (ServerProperties) bc.getService(sr);
        resource.setServerProperties(props);

        // dependencies
        // Assume that the TransactionService instance is already bound
        sr = bc.getServiceReference(TransactionService.class.getName());
        final TransactionService transactionService = (TransactionService) bc.getService(sr);
        resource.setTransactionService(transactionService);

        // Retrieve the JmxService
        sr = bc.getServiceReference(JmxService.class.getName());
        final JmxService jmxService = (JmxService) bc.getService(sr);
        resource.setJmxService(jmxService);

        // Retrieve the WorkManagerService
        sr = bc.getServiceReference(WorkManagerService.class.getName());
        final WorkManagerService workManagerService = (WorkManagerService) bc.getService(sr);
        resource.setWorkManagerService(workManagerService);

        // Check dependencies
        resource.checkRequirements();

        // Start the Service
        resource.start();

        // Register the Service to OSGi registry
        myServiceRegistration = bc.registerService(ResourceService.class.getName(), resource, null);
    }

    /**
     * {@inheritDoc}
     * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
     */
    public void stop(final BundleContext bc) throws Exception {
        System.out.println("Stopping JOnAS Resource Service Bundle...");

        myServiceRegistration.unregister();
        if (resource != null) {
            resource.stop();
        }
    }

}
