/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2008 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer(s): ____________________________________.
 * Contributor(s): Michel Bruno and Guillaume Riviere
 *
 * --------------------------------------------------------------------------
 * $Id: JOnASResourceServiceMBean.java 13315 2008-03-25 12:16:51Z fornacif $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.resource.internal;

import java.util.List;


/**
 * MBean Interface for Resource Service Management.
 * MBean type: Standard
 * MBean model: Inheritance (ResourceServiceImpl)
 */
public interface JOnASResourceServiceMBean {

    /**
     * @return current number of rars deployed in the JOnAS server
     */
    Integer getCurrentNumberOfRars();

    /**
     * @return the list of RAR files deployed
     * @throws Exception if error retrieving the list
     */
    List<String> getDeployedRars() throws Exception;
}
