/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Release: 1.0
 *
 * Author: Eric HARDESTY
 * --------------------------------------------------------------------------
 * $Id:PoolItemStats.java
 * --------------------------------------------------------------------------
 *
 */
package org.ow2.jonas.resource.internal.pool;

/** <p>This class holds information about each pool entry.
 *
 *  @author      Eric Hardesty
**/
public class PoolItemStats {

    /**
     * Max age timeout of the pool item
     */
    private long maxAgeTimeout = 0L;
    /**
     * Max open timeout of the pool item
     */
    private long maxOpenTimeout = 0L;
    /**
     * Start time of the pool item
     */
    private long startTime = 0L;
    /**
     * Total connection time of the pool item
     */
    private long totalConnectionTime = 0L;

    /**
     * number of uses
     */
    private int uses = 0;

    /**
     * Default Constructor
     */
    public PoolItemStats() {
    }

    /**
     * Get the max age timeout
     * @return long max age timeout
     */
    public long getMaxAgeTimeout() {
        return maxAgeTimeout;
    }

    /**
     * Set the max age timeout
     * @param pTime long max age timeout
     */
    public void setMaxAgeTimeout(long pTime) {
        maxAgeTimeout = pTime;
    }

    /**
     * Get the max open timeout
     * @return long max open timeout
     */
    public long getMaxOpenTimeout() {
        return maxOpenTimeout;
    }

    /**
     * Set the max open timeout
     * @param pTime long max open timeout
     */
    public void setMaxOpenTimeout(long pTime) {
        maxOpenTimeout = pTime;
    }

    /**
     * Get the start time
     * @return long start time
     */
    public long getStartTime() {
        return startTime;
    }

    /**
     * Set the start time
     * @param pTime long start time
     */
    public void setStartTime(long pTime) {
        startTime = pTime;
    }

    /**
     * Get the total connection time
     * @return long total connection time
     */
    public long getTotalConnectionTime() {
        return totalConnectionTime;
    }

    /**
     * Set the total connection time
     * @param pTime long total connection time
     */
    public void setTotalConnectionTime(long pTime) {
        totalConnectionTime += pTime;
    }

    /**
     * Get the number of uses
     * @return int number of uses
     */
    public int getUses() {
        return uses;
    }

    /**
     * Increment the number of uses
     */
    public void incrementUses() {
        uses++;
    }

    /**
     * String representing this object
     * @return String representing the object
     */
    public String toString() {
       String out = "MaxAgeTimeout = " + maxAgeTimeout
                    + "\nMaxOpenTimeout = " + maxOpenTimeout
                    + "\nStartTime = " + startTime
                    + "\nTotalConnectionTime = " + totalConnectionTime
                    + "\nUses = " + uses;
       return out;
    }

}