/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal;

import java.io.File;
import java.net.URL;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.RARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RARDeployer
implements IDeployer {
    private Log logger = LogFactory.getLog(RARDeployer.class);
    private ResourceService resourceService = null;

    protected void undeployRAR(RARDeployable rarDeployable) throws DeployerException {
        this.logger.info((Object)"Undeploying {0}", new Object[]{rarDeployable});
        try {
            this.resourceService.unDeployRar(this.getFile(rarDeployable).getAbsolutePath());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the RAR deployable '" + rarDeployable + "'.", (Throwable)e);
        }
    }

    protected void deployRAR(RARDeployable rarDeployable) throws DeployerException {
        this.logger.info((Object)"Deploying {0}", new Object[]{rarDeployable});
        try {
            this.resourceService.deployRar(this.getFile(rarDeployable).getPath());
        }
        catch (Exception e) {
            throw new DeployerException("Cannot deploy the RAR deployable '" + rarDeployable + "'.", (Throwable)e);
        }
    }

    protected File getFile(RARDeployable rarDeployable) throws DeployerException {
        URL rarURL = null;
        try {
            rarURL = rarDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL from RAR deployable '" + rarDeployable + "'.", (Throwable)e);
        }
        return URLUtils.urlToFile((URL)rarURL);
    }

    public void deploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof RARDeployable) {
            this.deployRAR((RARDeployable)deployable);
        }
    }

    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof RARDeployable) {
            return this.resourceService.isRarLoaded(this.getFile((RARDeployable)deployable).getAbsolutePath());
        }
        return false;
    }

    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof RARDeployable;
    }

    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof RARDeployable) {
            this.undeployRAR((RARDeployable)deployable);
        }
    }

    private void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }
}

