/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.cm.jta;

import javax.resource.ResourceException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.resource.internal.cm.ManagedConnectionInfo;
import org.ow2.jonas.tm.Enlistable;

public class JResourceManagerEvent
implements Enlistable {
    private ManagedConnectionInfo mci = null;
    private Logger trace = null;
    private boolean isValid = false;

    public JResourceManagerEvent(ManagedConnectionInfo mci, Logger trace) {
        this.mci = mci;
        this.trace = trace;
    }

    public boolean equals(Object o) {
        return o instanceof JResourceManagerEvent && this.mci.equals(((JResourceManagerEvent)o).mci);
    }

    public void enlistConnection(Transaction tx) throws SystemException {
        try {
            if (this.isValid) {
                if (this.trace.isLoggable(BasicLevel.DEBUG)) {
                    this.trace.log(BasicLevel.DEBUG, (Object)("Enlist the XA Resource " + this.mci.getXAResource() + " in Tx:" + tx));
                }
                tx.enlistResource(this.mci.getXAResource());
            }
        }
        catch (RollbackException rbe) {
            throw new SystemException(rbe.getMessage());
        }
        catch (ResourceException re) {
            throw new SystemException(re.getMessage());
        }
    }

    public void delistConnection(Transaction tx) throws SystemException {
        try {
            if (this.isValid) {
                if (this.trace.isLoggable(BasicLevel.DEBUG)) {
                    this.trace.log(BasicLevel.DEBUG, (Object)("Delist the XA Resource " + this.mci.getXAResource() + " from Tx:" + tx));
                }
                tx.delistResource(this.mci.getXAResource(), 0x4000000);
            }
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)("Cannot delist Resource:" + e));
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }
}

