/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.interceptors.jrmp.ctxcheck;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import org.ow2.carol.rmi.jrmp.interceptor.api.JServerRequestInfo;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JServerRequestInterceptor;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;
import org.ow2.jonas.security.interceptors.jrmp.ctxcheck.CtxCheckConfig;

public class ServerInterceptor
implements JServerRequestInterceptor {
    private static final String JPROP_CLASSNAME = "org.ow2.jonas.lib.bootstrap.JProp";
    private static final SecurityContext ANON_CTX = new SecurityContext();
    private static SecurityContext alteredCtx = null;
    private static final String NAME = "CHECK_CTX_INTERCEPTOR";
    private static CtxCheckConfig config = null;

    public ServerInterceptor() {
        if (config == null) {
            boolean hasJonasBase = System.getProperty("jonas.base") != null;
            boolean hasJonasRoot = System.getProperty("install.root") != null;
            boolean server = true;
            try {
                Thread.currentThread().getContextClassLoader().loadClass(JPROP_CLASSNAME);
            }
            catch (ClassNotFoundException cnfe) {
                server = false;
            }
            if (server && hasJonasBase && hasJonasRoot) {
                config = new CtxCheckConfig();
            }
        }
        if (alteredCtx == null) {
            alteredCtx = new SecurityContext("JOnAS_ALTERED_IDENTITY");
        }
    }

    public void receive_request(JServerRequestInfo jri) throws IOException {
        SecurityContext sctx;
        SecurityCurrent current = SecurityCurrent.getCurrent();
        if (current != null && (sctx = current.getSecurityContext()) != null) {
            if (ANON_CTX.getPrincipalName().equals(sctx.getPrincipalName()) && Arrays.equals(ANON_CTX.getRoles(), sctx.getRoles())) {
                return;
            }
            if (sctx.getSignature() == null) {
                current.setSecurityContext(alteredCtx);
                throw new IOException("The security context '" + sctx + "' has no signature which is illegal with this configuration. Check that the SignLoginModule has been used.");
            }
            PublicKey publickey = config.getPublicKey();
            Signature signature = null;
            try {
                signature = Signature.getInstance("SHA1withDSA");
            }
            catch (NoSuchAlgorithmException e) {
                current.setSecurityContext(alteredCtx);
                throw new IOException("Error while getting the algorithm 'SHA1withDSA' :" + e.getMessage());
            }
            try {
                signature.initVerify(publickey);
            }
            catch (InvalidKeyException e) {
                current.setSecurityContext(alteredCtx);
                throw new IOException("Cannot initialize the signature with the given public key:" + e.getMessage());
            }
            try {
                signature.update(sctx.getPrincipalName().getBytes());
            }
            catch (SignatureException e) {
                current.setSecurityContext(alteredCtx);
                throw new IOException("Cannot add the bytes for the principal name '" + sctx.getPrincipalName() + "' :" + e.getMessage());
            }
            String[] roles = sctx.getRoles();
            for (int r = 0; r < roles.length; ++r) {
                try {
                    signature.update(roles[r].getBytes());
                    continue;
                }
                catch (SignatureException e) {
                    current.setSecurityContext(alteredCtx);
                    throw new IOException("Cannot add the bytes for the role '" + roles[r] + "' :" + e.getMessage());
                }
            }
            boolean trusted = false;
            try {
                trusted = signature.verify(sctx.getSignature());
            }
            catch (SignatureException e) {
                current.setSecurityContext(alteredCtx);
                throw new IOException("The signature found in the security context '" + sctx + "' is invalid:" + e.getMessage());
            }
            if (!trusted) {
                current.setSecurityContext(alteredCtx);
                throw new IOException("The signature for the security context '" + sctx + "' has been altered by an unknown source.");
            }
        }
    }

    public void send_reply(JServerRequestInfo jri) throws IOException {
    }

    public String name() {
        return NAME;
    }

    public void send_exception(JServerRequestInfo jri) throws IOException {
    }

    public void send_other(JServerRequestInfo jri) throws IOException {
    }
}

