/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2004 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SecurityInitializer.java 12246 2007-12-09 21:42:38Z benoitf $
 * --------------------------------------------------------------------------
 *
 */
package org.ow2.jonas.security.interceptors.jrmp;

// carol import
import org.ow2.carol.rmi.jrmp.interceptor.spi.JInitializer;
import org.ow2.carol.rmi.jrmp.interceptor.api.JInitInfo;

/**
 * Class <code>SecurityInitializer</code> is a JRMP Initiliazer for security
 * context propagation
 * @author Guillaume Riviere (Guillaume.Riviere@inrialpes.fr)
 * @version 1.0, 13/09/2002
 */
public class SecurityInitializer implements JInitializer {

    /**
     * In JRMP the 2 method( per and post init have the same consequences ...
     * @param JInitInfo the JInit Information
     */
    public void pre_init(JInitInfo info) {
        try {
            info.add_client_request_interceptor(new ClientSecurityInterceptor());
            info.add_server_request_interceptor(new ServerSecurityInterceptor());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * In JRMP the 2 method( per and post init have the same consequences ...
     * @param JInitInfo the JInit Information
     */
    public void post_init(JInitInfo info) {
        // do nothing
    }

}
