/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.security;

import org.ow2.jonas.antmodular.jonasbase.bootstrap.AbstractJOnASBaseAntTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.BaseTaskItf;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JReplace;
import org.ow2.jonas.antmodular.jonasbase.security.JResourceLoginModule;
import org.ow2.jonas.antmodular.jonasbase.security.JaasEntry;
import org.ow2.jonas.antmodular.jonasbase.security.LoginModule;

public class Jaas
extends AbstractJOnASBaseAntTask {
    private static final String INFO = "[JAAS] ";
    private static final String TOKEN_BEGIN_CONF_FILE = "jaasclient {";
    public static final String JAAS_CONF_FILE = "jaas.config";
    public static final String DEFAULT_LOGIN_MODULE_NAME = "org.ow2.jonas.security.auth.spi.JResourceLoginModule";

    public void addConfiguredJaasEntry(JaasEntry entry) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(JAAS_CONF_FILE);
        propertyReplace.setToken(TOKEN_BEGIN_CONF_FILE);
        StringBuffer value = new StringBuffer();
        value.append(entry.getName() + "{" + "\n");
        for (LoginModule lm : entry.getLoginModules()) {
            if (lm instanceof JResourceLoginModule) {
                JResourceLoginModule rlm = (JResourceLoginModule)lm;
                value.append("    org.ow2.jonas.security.auth.spi.JResourceLoginModule " + lm.getFlag() + "\n");
                value.append("    resourceName=\"" + rlm.getResourceName() + "\"" + "\n");
                if (rlm.getServerName() != null && !"".equals(rlm.getServerName())) {
                    value.append("    serverName=\"" + rlm.getServerName() + "\"" + "\n");
                }
                if (rlm.isUseUpperCaseUsername()) {
                    value.append("    useUpperCaseUsername=\"" + rlm.isUseUpperCaseUsername() + "\"" + "\n");
                }
                if (rlm.isCertCallback()) {
                    value.append("    certCallback=\"" + rlm.isCertCallback() + "\"" + "\n");
                }
            }
            value.append("\n");
        }
        value.append("    ;\n");
        value.append("};\n");
        value.append("\n");
        value.append(TOKEN_BEGIN_CONF_FILE);
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[JAAS] Add the JAAS entry : " + entry.getName());
        this.addTask((BaseTaskItf)propertyReplace);
    }

    public void execute() {
        super.execute();
        this.executeAllTask();
    }
}

