/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.security;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.AbstractJOnASBaseAntTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.BaseTaskItf;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JReplace;
import org.ow2.jonas.antmodular.jonasbase.security.EmptyEntityResolver;
import org.ow2.jonas.antmodular.jonasbase.security.JResourceLoginModule;
import org.ow2.jonas.antmodular.jonasbase.security.JaasEntry;
import org.ow2.jonas.antmodular.jonasbase.security.LoginModule;
import org.ow2.jonas.antmodular.jonasbase.security.User;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Jaas
extends AbstractJOnASBaseAntTask {
    private static final String INFO = "[JAAS] ";
    private static final String TOKEN_BEGIN_CONF_FILE = "jaasclient {";
    public static final String JAAS_CONF_FILE = "jaas.config";
    public static final String DEFAULT_LOGIN_MODULE_NAME = "org.ow2.jonas.security.auth.spi.JResourceLoginModule";
    public static final String JMX_AUTHENTIFICATION_METHOD_TOKEN = "jonas.service.jmx.authentication.method";
    public static final String JMX_AUTHENTIFICATION_METHOD_VALUE = "jmx.remote.x.login.config";
    public static final String JMX_AUTHENTIFICATION_PARAMETER_TOKEN = "jonas.service.jmx.authentication.parameter";
    public static final String JMX_AUTHENTIFICATION_PARAMETER_VALUE = "jaas-jmx";
    public static final String JMX_IS_SECURED_TOKEN = "jonas.service.jmx.secured";
    public static final String JMX_IS_SECURED_VALUE = "true";
    public static final String JONAS_ADMIN_USERNAME_TOKEN = "jonas.adminClient.username";
    public static final String JONAS_ADMIN_PASSWORD_TOKEN = "jonas.adminClient.password";
    public static final String JONAS_REALM_CONF_FILE = "jonas-realm.xml";
    private List<User> users = new ArrayList<User>();
    private List<User> admins = new ArrayList<User>();
    private List<User> templateUsers = new ArrayList<User>();
    private Map<String, String> templateRoles = new HashMap<String, String>();
    private boolean secureJmx = false;
    public static String EOL = "\n";
    public static String REALME_SEPARATOR = "      ";
    public static String USERS_TOKEN = "</users>";
    public static String ROLES_TOKEN = "</roles>";

    public void addConfiguredJaasEntry(JaasEntry entry) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile(JAAS_CONF_FILE);
        propertyReplace.setToken(TOKEN_BEGIN_CONF_FILE);
        StringBuffer value = new StringBuffer();
        value.append(entry.getName() + "{" + "\n");
        for (LoginModule lm : entry.getLoginModules()) {
            if (lm instanceof JResourceLoginModule) {
                JResourceLoginModule rlm = (JResourceLoginModule)lm;
                value.append("    org.ow2.jonas.security.auth.spi.JResourceLoginModule " + lm.getFlag() + "\n");
                value.append("    resourceName=\"" + rlm.getResourceName() + "\"" + "\n");
                if (rlm.getServerName() != null && !"".equals(rlm.getServerName())) {
                    value.append("    serverName=\"" + rlm.getServerName() + "\"" + "\n");
                }
                if (rlm.isUseUpperCaseUsername()) {
                    value.append("    useUpperCaseUsername=\"" + rlm.isUseUpperCaseUsername() + "\"" + "\n");
                }
                if (rlm.isCertCallback()) {
                    value.append("    certCallback=\"" + rlm.isCertCallback() + "\"" + "\n");
                }
            }
            value.append("\n");
        }
        value.append("    ;\n");
        value.append("};\n");
        value.append("\n");
        value.append(TOKEN_BEGIN_CONF_FILE);
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[JAAS] Add the JAAS entry : " + entry.getName());
        this.addTask((BaseTaskItf)propertyReplace);
    }

    public void addConfiguredAdmin(User admin) {
        if (admin.getName() == null) {
            throw new BuildException("Admin username is not set.");
        }
        if (admin.getPassword() == null) {
            throw new BuildException("Admin password is not set");
        }
        this.admins.add(admin);
    }

    public void addConfiguredUser(User user) {
        if (user.getName() == null) {
            throw new BuildException("Username is not set.");
        }
        if (user.getPassword() == null) {
            throw new BuildException("User's password is not set");
        }
        this.users.add(user);
    }

    public void setSecureJmx(boolean enabled) {
        this.secureJmx = enabled;
    }

    public void execute() {
        JReplace propertyReplace;
        String userValue;
        String password;
        String username;
        super.execute();
        String confDirPath = this.getJOnASBase() + "/conf";
        if (this.secureJmx) {
            if (this.admins.isEmpty()) {
                throw new BuildException("JMX security is enabled, but with no admin user defined. Please correct your configuration and run again.");
            }
            super.createServiceNameReplace(JMX_IS_SECURED_VALUE, INFO, confDirPath, JMX_IS_SECURED_TOKEN);
            super.createServiceNameReplace(JMX_AUTHENTIFICATION_METHOD_VALUE, INFO, confDirPath, JMX_AUTHENTIFICATION_METHOD_TOKEN);
            super.createServiceNameReplace(JMX_AUTHENTIFICATION_PARAMETER_VALUE, INFO, confDirPath, JMX_AUTHENTIFICATION_PARAMETER_TOKEN);
        }
        if (this.admins.size() > 0) {
            super.createServiceNameReplace(this.admins.get(0).getName(), INFO, confDirPath, JONAS_ADMIN_USERNAME_TOKEN);
            super.createServiceNameReplace(this.admins.get(0).getPassword(), INFO, confDirPath, JONAS_ADMIN_PASSWORD_TOKEN);
        }
        this.initUsers(new File(confDirPath, JONAS_REALM_CONF_FILE));
        for (User user : this.users) {
            username = user.getName();
            password = user.getPassword();
            String roles = user.getRoles();
            String description = user.getDescription();
            User templateUser = this.isUserAlreadyDefined(user);
            if (templateUser != null) {
                String templateUserName = templateUser.getName();
                String templateUserPassword = templateUser.getPassword();
                String templateUserRoles = templateUser.getRoles();
                String templateUserGroups = templateUser.getGroups();
                if (!templateUserPassword.equals(user.getPassword())) {
                    if (templateUserGroups != null && templateUserGroups.contains("jonas") || templateUserRoles != null && templateUserRoles.contains("jonas-admin")) {
                        throw new BuildException("Cannot update the password and/or role of the username '" + templateUserName + "'. An admin is already defined with this name.");
                    }
                    String userToken = "<user name=\"" + templateUserName + "\" password=\"" + templateUserPassword + "\" roles=\"" + templateUserRoles + "\" />";
                    String userValue2 = "<user name=\"" + username + "\" password=\"" + password + "\" roles=\"" + roles + "\" />";
                    JReplace propertyReplace2 = new JReplace();
                    propertyReplace2.setConfigurationFile(JONAS_REALM_CONF_FILE);
                    propertyReplace2.setToken(userToken);
                    propertyReplace2.setValue(userValue2);
                    propertyReplace2.setDestDir(this.destDir);
                    propertyReplace2.setLogInfo("[JAAS] Setting password of '" + username + "' to '" + password + "'");
                    propertyReplace2.execute();
                }
            } else {
                userValue = "  <user name=\"" + username + "\" password=\"" + password + "\" roles=\"" + roles + "\" />" + EOL + REALME_SEPARATOR + USERS_TOKEN;
                propertyReplace = new JReplace();
                propertyReplace.setConfigurationFile(JONAS_REALM_CONF_FILE);
                propertyReplace.setToken(USERS_TOKEN);
                propertyReplace.setValue(userValue);
                propertyReplace.setDestDir(this.destDir);
                propertyReplace.setLogInfo("[JAAS] Creating a new user with name equals to '" + username + "'  ,password equals to '" + password + "' and role equals to '" + roles + "'");
                propertyReplace.execute();
            }
            if (!this.templateRoles.containsKey(roles)) {
                StringBuilder roleValue = new StringBuilder();
                roleValue.append("  <role name=\"" + roles + "\" ");
                if (description != null) {
                    roleValue.append("description=\"" + description + "\" ");
                }
                roleValue.append("/>" + EOL + REALME_SEPARATOR + ROLES_TOKEN);
                propertyReplace = new JReplace();
                propertyReplace.setConfigurationFile(JONAS_REALM_CONF_FILE);
                propertyReplace.setToken(ROLES_TOKEN);
                propertyReplace.setValue(roleValue.toString());
                propertyReplace.setDestDir(this.destDir);
                propertyReplace.setLogInfo("[JAAS] Creating a new role with name equals to '" + roles + "'  and " + "description equals to '" + description + "'");
                propertyReplace.execute();
                continue;
            }
            String templateDescription = this.templateRoles.get(roles);
            if (description == null || templateDescription.equals(description)) continue;
            String roleToken = "<role name=\"" + roles + "\" description=\"" + templateDescription + "\" />";
            StringBuilder roleValue = new StringBuilder();
            roleValue.append("<role name=\"" + roles + "\" ");
            if (description != null) {
                roleValue.append("description=\"" + description + "\" ");
            }
            roleValue.append("/>");
            JReplace propertyReplace3 = new JReplace();
            propertyReplace3.setConfigurationFile(JONAS_REALM_CONF_FILE);
            propertyReplace3.setToken(roleToken);
            propertyReplace3.setValue(roleValue.toString());
            propertyReplace3.setDestDir(this.destDir);
            propertyReplace3.setLogInfo("[JAAS] Setting the description of role " + roles + "  to : " + description);
            propertyReplace3.execute();
        }
        for (User admin : this.admins) {
            username = admin.getName();
            password = admin.getPassword();
            User userAdmin = new User();
            userAdmin.setName(username);
            userAdmin.setPassword(password);
            User templateAdmin = this.isUserAlreadyDefined(userAdmin);
            if (templateAdmin != null) {
                if (templateAdmin.getPassword().equals(userAdmin.getPassword())) continue;
                String userToken = null;
                if (templateAdmin.getRoles() != null) {
                    userToken = "<user name=\"" + templateAdmin.getName() + "\" password=\"" + templateAdmin.getPassword() + "\" roles=\"" + templateAdmin.getRoles() + "\" />";
                } else if (templateAdmin.getGroups() != null) {
                    userToken = "<user name=\"" + templateAdmin.getName() + "\" password=\"" + templateAdmin.getPassword() + "\" groups=\"" + templateAdmin.getGroups() + "\" />";
                } else {
                    throw new BuildException("jonas-realm.xml template configuration file is incorrect. No 'groups' or 'roles' attribute for the user " + templateAdmin.getName());
                }
                userValue = "<user name=\"" + username + "\" password=\"" + password + "\" groups=\"jonas\"/>";
                propertyReplace = new JReplace();
                propertyReplace.setConfigurationFile(JONAS_REALM_CONF_FILE);
                propertyReplace.setToken(userToken);
                propertyReplace.setValue(userValue);
                propertyReplace.setDestDir(this.destDir);
                propertyReplace.setLogInfo("[JAAS] Setting password of '" + username + "' to '" + password + "'");
                propertyReplace.execute();
                continue;
            }
            String userValue3 = "  <user name=\"" + username + "\" password=\"" + password + "\" groups=\"jonas\"/>" + EOL + REALME_SEPARATOR + USERS_TOKEN;
            JReplace propertyReplace4 = new JReplace();
            propertyReplace4.setConfigurationFile(JONAS_REALM_CONF_FILE);
            propertyReplace4.setToken(USERS_TOKEN);
            propertyReplace4.setValue(userValue3);
            propertyReplace4.setDestDir(this.destDir);
            propertyReplace4.setLogInfo("[JAAS] Creating a new admin user with name equals to '" + username + "'  and password equals to '" + password + "'");
            propertyReplace4.execute();
        }
        this.executeAllTask();
    }

    private void initUsers(File realmConfFile) {
        Element elt;
        int i;
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new BuildException("Cannot instanciate a new DocumentBuilder", (Throwable)e);
        }
        db.setEntityResolver(new EmptyEntityResolver());
        try {
            document = db.parse(realmConfFile);
        }
        catch (SAXException e) {
            throw new BuildException("Cannot parse the resource " + realmConfFile, (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("Cannot parse the resource " + realmConfFile, (Throwable)e);
        }
        NodeList nodeList = document.getElementsByTagName("user");
        for (i = 0; i < nodeList.getLength(); ++i) {
            String groups;
            String roles;
            String password;
            elt = (Element)nodeList.item(i);
            User user = new User();
            String name = elt.getAttribute("name");
            if (name != null && !"".equals(name)) {
                user.setName(name);
            }
            if ((password = elt.getAttribute("password")) != null && !"".equals(password)) {
                user.setPassword(password);
            }
            if ((roles = elt.getAttribute("roles")) != null && !"".equals(roles)) {
                user.setRoles(roles);
            }
            if ((groups = elt.getAttribute("groups")) != null && !"".equals(groups)) {
                user.setGroups(groups);
            }
            this.templateUsers.add(user);
        }
        nodeList = document.getElementsByTagName("role");
        for (i = 0; i < nodeList.getLength(); ++i) {
            elt = (Element)nodeList.item(i);
            this.templateRoles.put(elt.getAttribute("name"), elt.getAttribute("description"));
        }
    }

    private User isUserAlreadyDefined(User user) {
        for (User templateUser : this.templateUsers) {
            if (!templateUser.getName().equals(user.getName())) continue;
            return templateUser;
        }
        return null;
    }
}

