/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.security.context;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ow2.jonas.lib.security.context.SecurityContext;

public class Marshalling {
    public static final int SEC_CTX_ID = 101;

    private Marshalling() {
    }

    public static byte[] marshallSecurityContext(SecurityContext ctx) {
        byte[] result = null;
        try {
            if (ctx != null) {
                ArrayList cResult = new ArrayList();
                Marshalling.addBytes(cResult, ctx.getPrincipalName());
                String[] roles = ctx.getRoles();
                int nbRoles = 0;
                if (roles != null) {
                    nbRoles = roles.length;
                }
                Marshalling.addBytes(cResult, new Integer(nbRoles).toString());
                for (int i = 0; i < nbRoles; ++i) {
                    Marshalling.addBytes(cResult, roles[i]);
                }
                Marshalling.addBytes(cResult, new Integer(ctx.getRunAsRoleStack().size()).toString());
                Iterator iRunAs = ctx.getRunAsRoleStack().iterator();
                while (iRunAs.hasNext()) {
                    Marshalling.addBytes(cResult, (String)iRunAs.next());
                }
                Marshalling.addBytes(cResult, new Integer(ctx.getRunAsPrincipalStack().size()).toString());
                iRunAs = ctx.getRunAsPrincipalStack().iterator();
                while (iRunAs.hasNext()) {
                    Marshalling.addBytes(cResult, (String)iRunAs.next());
                }
                Marshalling.addBytes(cResult, new Integer(ctx.getRunAsPrincipalRolesStack().size()).toString());
                iRunAs = ctx.getRunAsPrincipalRolesStack().iterator();
                while (iRunAs.hasNext()) {
                    Marshalling.addBytes(cResult, (String[])iRunAs.next());
                }
                result = new byte[cResult.size()];
                for (int i = 0; i < cResult.size(); ++i) {
                    result[i] = (Byte)cResult.get(i);
                }
            }
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        return result;
    }

    public static SecurityContext unmarshallSecurityContext(byte[] byteCtx) {
        SecurityContext result = null;
        if (byteCtx != null && byteCtx.length > 0) {
            try {
                Iterator istrs = Marshalling.getBytes2Strings(byteCtx).iterator();
                String principalName = (String)istrs.next();
                int nbRoles = new Integer((String)istrs.next());
                ArrayList roles = null;
                if (nbRoles > 0) {
                    roles = new ArrayList();
                }
                while (nbRoles > 0) {
                    roles.add(istrs.next());
                    --nbRoles;
                }
                int nbRunas = new Integer((String)istrs.next());
                ArrayList runas = null;
                if (nbRunas > 0) {
                    runas = new ArrayList();
                }
                while (nbRunas > 0) {
                    runas.add(istrs.next());
                    --nbRunas;
                }
                int nbRunasPrincipal = new Integer((String)istrs.next());
                ArrayList runasPrincipal = null;
                if (nbRunasPrincipal > 0) {
                    runasPrincipal = new ArrayList();
                }
                while (nbRunasPrincipal > 0) {
                    runasPrincipal.add(istrs.next());
                    --nbRunasPrincipal;
                }
                int nbRunasRoles = new Integer((String)istrs.next());
                ArrayList<String[]> runasRoles = null;
                if (nbRunasRoles > 0) {
                    int arrayLength = new Integer((String)istrs.next());
                    if (nbRunasRoles > 0) {
                        runasRoles = new ArrayList<String[]>();
                    }
                    while (nbRunasRoles > 0) {
                        String[] st = new String[arrayLength];
                        for (int j = 0; j < arrayLength; ++j) {
                            st[j] = (String)istrs.next();
                        }
                        runasRoles.add(st);
                        --nbRunasRoles;
                    }
                }
                result = new SecurityContext(principalName, roles, runas, runasPrincipal, runasRoles);
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }
        return result;
    }

    private static void addBytes(Collection c, String toAdd) throws UnsupportedEncodingException {
        byte[] b = toAdd.getBytes("UTF8");
        c.add(new Byte((byte)b.length));
        for (int i = 0; i < b.length; ++i) {
            c.add(new Byte(b[i]));
        }
    }

    private static void addBytes(Collection c, String[] toAdd) throws UnsupportedEncodingException {
        Marshalling.addBytes(c, new Integer(toAdd.length).toString());
        for (int n = 0; n < toAdd.length; ++n) {
            byte[] b = toAdd[n].getBytes("UTF8");
            c.add(new Byte((byte)b.length));
            for (int i = 0; i < b.length; ++i) {
                c.add(new Byte(b[i]));
            }
        }
    }

    private static List getBytes2Strings(byte[] bytes) throws UnsupportedEncodingException {
        ArrayList<String> strs = new ArrayList<String>();
        int index = 0;
        while (bytes.length > index) {
            int rSize = bytes[index];
            ++index;
            byte[] rName = new byte[rSize];
            for (int j = 0; j < rSize; ++j) {
                rName[j] = bytes[index];
                ++index;
            }
            strs.add(new String(rName, "UTF8"));
        }
        return strs;
    }
}

