/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal.realm.factory;

import java.io.Serializable;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.reconfig.ReconfigEmitter;
import org.ow2.jonas.lib.reconfig.XMLConfigurationData;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.security.internal.realm.factory.JResourceMBean;
import org.ow2.jonas.security.internal.realm.principal.Group;
import org.ow2.jonas.security.internal.realm.principal.Role;
import org.ow2.jonas.security.internal.realm.principal.User;
import org.ow2.jonas.security.realm.factory.JResource;

public abstract class AbstractJResource
extends ReconfigEmitter
implements Serializable,
Referenceable,
JResourceMBean,
JResource {
    private String name = null;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.security");
    private Hashtable users = new Hashtable();
    private long sequenceNumber = 0L;
    private SecurityService securityService = null;
    private JmxService jmxService = null;
    private String domainName = null;

    public void setDomainName(String domain) {
        this.domainName = domain;
    }

    public void setJmxService(JmxService jmx) {
        this.jmxService = jmx;
    }

    public void setSecurityService(SecurityService sec) {
        this.securityService = sec;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Hashtable getUsers() {
        return this.users;
    }

    protected long getSequenceNumber() {
        return ++this.sequenceNumber;
    }

    public void saveConfig() {
        if (this.securityService != null) {
            String xml = this.securityService.toXML();
            XMLConfigurationData data = new XMLConfigurationData(xml);
            this.sendReconfigNotification(this.getSequenceNumber(), this.name, data);
            this.sendSaveNotification(this.getSequenceNumber(), this.name);
            try {
                InitialContext ictx = new InitialContext();
                ictx.rebind(this.getName(), (Object)this);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("jResource " + this.getName() + " is rebind into the registry."));
                }
            }
            catch (NamingException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot rebind factory to the jndi : '" + e.getMessage() + "'"));
            }
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        AbstractJResource.logger = logger;
    }

    public void setUsers(Hashtable users) {
        this.users = users;
    }

    public void clearCache() {
        this.setUsers(new Hashtable());
    }

    public void addNotificationListener(NotificationListener arg0, NotificationFilter arg1, Object arg2) {
        super.addNotificationListener(arg0, arg1, arg2);
    }

    protected void registerUserMBean(User user) throws MalformedObjectNameException {
        if (this.jmxService != null) {
            String userName = user.getName();
            ObjectName on = JonasObjectName.user((String)this.domainName, (String)this.getName(), (String)userName);
            this.jmxService.registerMBean((Object)user, on);
        }
    }

    protected void unregisterUserMBean(String resourceName, String userName) throws MalformedObjectNameException {
        if (this.jmxService != null) {
            this.jmxService.unregisterMBean(JonasObjectName.user((String)this.domainName, (String)resourceName, (String)userName));
        }
    }

    protected void registerGroupMBean(Group group) throws MalformedObjectNameException {
        if (this.jmxService != null) {
            String groupName = group.getName();
            ObjectName on = JonasObjectName.group((String)this.domainName, (String)this.getName(), (String)groupName);
            this.jmxService.registerMBean((Object)group, on);
        }
    }

    protected void unregisterGroupMBean(String resourceName, String groupName) throws MalformedObjectNameException {
        if (this.jmxService != null) {
            this.jmxService.unregisterMBean(JonasObjectName.group((String)this.domainName, (String)resourceName, (String)groupName));
        }
    }

    protected void registerRoleMBean(Role role) throws MalformedObjectNameException {
        if (this.jmxService != null) {
            String roleName = role.getName();
            ObjectName on = JonasObjectName.role((String)this.domainName, (String)this.getName(), (String)roleName);
            this.jmxService.registerMBean((Object)role, on);
        }
    }

    protected void unregisterRoleMBean(String resourceName, String roleName) throws MalformedObjectNameException {
        if (this.jmxService != null) {
            this.jmxService.unregisterMBean(JonasObjectName.role((String)this.domainName, (String)resourceName, (String)roleName));
        }
    }
}

