/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2004 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer: Florent Benoit
 * --------------------------------------------------------------------------
 * $Id: JResourceDSMBean.java 14368 2008-06-23 15:49:31Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.security.internal.realm.factory;

/**
 * Define the methods for the MBean
 * @author Florent Benoit
 */
public interface JResourceDSMBean extends JResourceMBean {

    /**
     * Clear the cache
     */
    void clearCache();

    // Setters

    /**
     * Set the name of the resource to use
     * @param dsName name of the resource
     */
    void setDsName(String dsName);

    /**
     * Set the name of the table which have the username/password
     * @param userTable name of the table which have the username/password
     */
    void setUserTable(String userTable);

    /**
     * Set the name of the column of the username of the user table
     * @param userTableUsernameCol name of the column of the username of the
     *        user table
     */
    void setUserTableUsernameCol(String userTableUsernameCol);

    /**
     * Set the name of column of the password of the user table
     * @param userTablePasswordCol name of column of the password of the user
     *        table
     */
    void setUserTablePasswordCol(String userTablePasswordCol);

    /**
     * Set the name of table which have the username/role
     * @param roleTable name of table which have the username/role
     */
    void setRoleTable(String roleTable);

    /**
     * Set the name of the column of the username of the role table
     * @param roleTableUsernameCol name of the column of the username of the
     *        role table
     */
    void setRoleTableUsernameCol(String roleTableUsernameCol);

    /**
     * Set the name of the column of the role of the role table
     * @param roleTableRolenameCol name of the column of the role of the role
     *        table
     */
    void setRoleTableRolenameCol(String roleTableRolenameCol);

    /**
     * Set the default algorithm to use
     * @param algorithm algorithm to be used
     */
    void setAlgorithm(String algorithm);

    // Getters

    /**
     * Get the name of the resource to use
     * @return name of the resource
     */
    String getDsName();

    /**
     * Get the name of the table which have the username/password
     * @return name of the table which have the username/password
     */
    String getUserTable();

    /**
     * Get the name of the column of the username of the user table
     * @return name of the column of the username of the user table
     */
    String getUserTableUsernameCol();

    /**
     * Get the name of column of the password of the user table
     * @return name of column of the password of the user table
     */
    String getUserTablePasswordCol();

    /**
     * Get the name of table which have the username/role
     * @return name of table which have the username/role
     */
    String getRoleTable();

    /**
     * Get the name of the column of the username of the role table
     * @return name of the column of the username of the role table
     */
    String getRoleTableUsernameCol();

    /**
     * Get the name of the column of the role of the role table
     * @return name of the column of the role of the role table
     */
    String getRoleTableRolenameCol();

    /**
     * Get the default algorithm
     * @return the default algorithm
     */
    String getAlgorithm();

}