/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2004 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer: Florent Benoit
 * --------------------------------------------------------------------------
 * $Id: JResourceMemoryMBean.java 14368 2008-06-23 15:49:31Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.security.internal.realm.factory;

/**
 * Define the methods for the MBean
 * @author Florent Benoit
 */
public interface JResourceMemoryMBean extends JResourceMBean {

    /**
     * Add a user with a given principal and credential
     * @param username the name of the user
     * @param password password of the user
     * @throws Exception if the user already exists
     */
    void addUser(String username, String password) throws Exception;

    /**
     * Add a group with a given name
     * @param groupname the name of the group
     * @throws Exception if the group already exists
     */
    void addGroup(String groupname) throws Exception;

    /**
     * Add a role with a given name
     * @param rolename the name of the role
     * @throws Exception if the role already exists
     */
    void addRole(String rolename) throws Exception;

    /**
     * Remove a user with a given principal and credential
     * @param username the name of the user
     * @throws Exception if the user was not found
     */
    void removeUser(String username) throws Exception;

    /**
     * Remove a group with a given name
     * @param groupname the name of the group
     * @throws Exception if the group was not found
     */
    void removeGroup(String groupname) throws Exception;

    /**
     * Remove a role with a given name
     * @param rolename the name of the role
     * @throws Exception if the role was not found
     */
    void removeRole(String rolename) throws Exception;

    /**
     * Get the roles
     * @return the array of the roles
     */
    String[] listRoles();

    /**
     * Get the groups
     * @return the array of the groups
     */
    String[] listGroups();

}