/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.lib;

import java.io.Reader;
import java.net.URL;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.security.internal.JResources;
import org.ow2.jonas.security.internal.SecurityServiceException;
import org.ow2.jonas.security.lib.JErrorHandler;
import org.ow2.jonas.security.rules.JDSRuleSet;
import org.ow2.jonas.security.rules.JLDAPRuleSet;
import org.ow2.jonas.security.rules.JMemoryRuleSet;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class JResourceManager {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.security");
    protected static final String CONFIG_FILE_DTD = "jonas-realm_1_0.dtd";
    protected static final String DTD_RESOURCE = "org/ow2/jonas/security/realm/dtd/jonas-realm_1_0.dtd";
    private static JResourceManager instance = null;

    private JResourceManager() {
    }

    public static JResourceManager getInstance() {
        if (instance == null) {
            instance = new JResourceManager();
        }
        return instance;
    }

    protected Digester createRealmDigester() {
        boolean validating = true;
        URL dtdUrl = this.getClass().getResource("/org/ow2/jonas/security/realm/dtd/jonas-realm_1_0.dtd");
        if (dtdUrl == null) {
            logger.log(BasicLevel.INFO, (Object)"Unable to find the 'org/ow2/jonas/security/realm/dtd/jonas-realm_1_0.dtd' resource. no validation will be done.");
            validating = false;
        }
        Digester digester = null;
        try {
            digester = new Digester();
        }
        catch (Throwable e) {
            System.out.println("new Digester: " + e);
            throw new RuntimeException("Cannot create Digester" + e);
        }
        if (validating) {
            digester.register("-//ObjectWeb//DTD JOnAS realm 1.0//EN", dtdUrl.toExternalForm());
        }
        digester.setValidating(validating);
        digester.setErrorHandler((ErrorHandler)new JErrorHandler());
        digester.addRuleSet((RuleSet)new JMemoryRuleSet("jonas-realm/jonas-memoryrealm/"));
        digester.addRuleSet((RuleSet)new JDSRuleSet("jonas-realm/jonas-dsrealm/"));
        digester.addRuleSet((RuleSet)new JLDAPRuleSet("jonas-realm/jonas-ldaprealm/"));
        return digester;
    }

    public void addResources(JResources res, Reader reader, String xml) throws SecurityServiceException {
        try {
            Digester realmDigester = this.createRealmDigester();
            realmDigester.setClassLoader(this.getClass().getClassLoader());
            realmDigester.push((Object)res);
            realmDigester.parse(reader);
            reader.close();
        }
        catch (SAXException saxe) {
            throw new SecurityServiceException("Error when parsing the XML of the file " + xml, saxe);
        }
        catch (Exception e) {
            throw new SecurityServiceException("Error when reading config file from the xml file " + xml, e);
        }
    }
}

