/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.auth.spi;

import java.io.File;
import java.io.FileInputStream;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ow2.jonas.lib.security.auth.JPrincipal;
import org.ow2.jonas.security.auth.callback.CertificateCallback;

public class CRLLoginModule
implements LoginModule {
    private Subject subject = null;
    private CallbackHandler callbackHandler = null;
    private Map sharedState = null;
    private Map options = null;
    private String principalName = null;
    private String password = null;
    private ArrayList principalRoles = null;
    private X509Certificate cert = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No handler has been defined.");
        }
        String crlsResourceName = (String)this.options.get("CRLsResourceName");
        String certStoreAccessName = null;
        NameCallback nameCallback = null;
        CertificateCallback certificateCallback = null;
        try {
            nameCallback = new NameCallback("User :");
            certificateCallback = new CertificateCallback();
            Callback[] callbacks = new Callback[]{nameCallback, certificateCallback};
            this.callbackHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new LoginException("Problem while getting informations in the callbackhandler: " + e.getMessage());
        }
        try {
            this.cert = (X509Certificate)certificateCallback.getUserCertificate();
            if (nameCallback.getName().startsWith("##DN##")) {
                if (this.cert == null) {
                    throw new LoginException("Client certificate not present, it can be verified with CRL");
                }
            } else {
                return true;
            }
            CertStoreParameters certStoreParameters = null;
            if (crlsResourceName.equalsIgnoreCase("Directory")) {
                certStoreAccessName = "Collection";
                String crlsDirectoryName = (String)this.options.get("CRLsDirectoryName");
                if (crlsDirectoryName == null) {
                    throw new LoginException("You have to give an argument to this login module. The \"CRLsDirectoryName\" parameter is required.");
                }
                File crlsDirectory = new File(crlsDirectoryName);
                if (!crlsDirectory.isDirectory()) {
                    throw new LoginException(crlsDirectoryName + " is not a directory");
                }
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                FileInputStream fis = null;
                String[] crlFileName = crlsDirectory.list();
                ArrayList<X509CRL> crls = new ArrayList<X509CRL>(crlFileName.length);
                X509CRL crl = null;
                for (int i = 0; i < crlFileName.length; ++i) {
                    if (!crlFileName[i].matches(".+\\.crl")) continue;
                    fis = new FileInputStream(crlsDirectory.getAbsolutePath() + File.separatorChar + crlFileName[i]);
                    crl = (X509CRL)cf.generateCRL(fis);
                    crls.add(crl);
                    fis.close();
                    fis = null;
                    crl = null;
                }
                certStoreParameters = new CollectionCertStoreParameters(crls);
            } else if (crlsResourceName.equalsIgnoreCase("LDAP")) {
                certStoreAccessName = "LDAP";
                String address = (String)this.options.get("address");
                int port = Integer.parseInt((String)this.options.get("port"));
                if (address == null) {
                    throw new LoginException("You have to give an argument to this login module. The \"address\" and \"port\" parameter are required.");
                }
                certStoreParameters = new LDAPCertStoreParameters(address, port);
            } else {
                throw new LoginException("You have to give an argument to this login module. The \"CRLsResourceName\" is not valid. Must be set to \"Directory\" or \"LDAP\"");
            }
            CertStore crlsStore = CertStore.getInstance(certStoreAccessName, certStoreParameters);
            X509CRLSelector x509CRLSelector = new X509CRLSelector();
            x509CRLSelector.addIssuerName(this.cert.getIssuerX500Principal().getEncoded());
            Iterator<? extends CRL> crlIterator = crlsStore.getCRLs(x509CRLSelector).iterator();
            while (crlIterator.hasNext()) {
                if (!((X509CRL)crlIterator.next()).isRevoked(this.cert)) continue;
                throw new LoginException("Client certificate has been revoked");
            }
        }
        catch (Exception e) {
            throw new LoginException("Error during the login phase : " + e.getMessage());
        }
        return true;
    }

    public boolean commit() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        this.principalName = null;
        this.principalRoles = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(new JPrincipal(this.principalName));
        return true;
    }
}

