/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.auth.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ow2.jonas.security.internal.realm.factory.JResourceRemote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteLoginModule
implements LoginModule {
    private static final String DEFAULT_SERVER_NAME = "jonas";
    private Subject subject = null;
    private Subject remoteSubject = null;
    private CallbackHandler callbackHandler = null;
    private Map options = null;
    private String password = null;
    private boolean loginWasDoneWithSuccess = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No handler has been defined.");
        }
        String entryName = (String)this.options.get("entryName");
        String providerURLsProp = (String)this.options.get("providerURLs");
        List<String> providerURLs = null;
        if (providerURLsProp != null) {
            String[] providerURLsArray = providerURLsProp.split(",");
            providerURLs = Arrays.asList(providerURLsArray);
        }
        String serverNameProp = (String)this.options.get("serverName");
        String serverNamesProp = (String)this.options.get("serverNames");
        ArrayList<String> serverNames = new ArrayList<String>();
        if (serverNameProp == null && serverNamesProp == null) {
            serverNames.add(DEFAULT_SERVER_NAME);
        } else {
            if (serverNameProp != null) {
                serverNames.add(serverNameProp);
            }
            if (serverNamesProp != null) {
                String[] servNames = serverNamesProp.split(",");
                for (int i = 0; i < servNames.length; ++i) {
                    serverNames.add(servNames[i]);
                }
            }
        }
        if (entryName == null) {
            throw new LoginException("The 'entryName' argument is a required argument of this login module.");
        }
        ArrayList<String> resourceNames = new ArrayList<String>();
        for (String sName : serverNames) {
            sName = sName.trim();
            resourceNames.add(sName + "_remoteres");
        }
        try {
            JResourceRemote jResourceRemote = this.findRemoteResource(resourceNames, providerURLs);
            NameCallback nameCallback = new NameCallback("User :");
            PasswordCallback passwordCallback = new PasswordCallback("Password :", false);
            Callback[] callbacks = new Callback[]{nameCallback, passwordCallback};
            this.callbackHandler.handle(callbacks);
            String principalName = nameCallback.getName();
            if (principalName == null) {
                throw new LoginException("A null username is not a valid username");
            }
            char[] arrayPass = passwordCallback.getPassword();
            if (arrayPass == null) {
                throw new LoginException("A null password is not a valid password");
            }
            this.password = new String(arrayPass);
            try {
                this.remoteSubject = jResourceRemote.authenticateJAAS(principalName, arrayPass, entryName);
            }
            catch (Exception e) {
                throw new LoginException("Cannot authenticate with principal name = '" + principalName + "' : " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new LoginException("Error during the login phase : " + e.getMessage());
        }
        this.loginWasDoneWithSuccess = true;
        return true;
    }

    protected JResourceRemote findRemoteResource(List<String> resourceNames, List<String> userProviderURLs) throws LoginException {
        List<Object> providerURLs = null;
        if (userProviderURLs == null || userProviderURLs.size() == 0) {
            providerURLs = new ArrayList();
            providerURLs.add(null);
        } else {
            providerURLs = userProviderURLs;
        }
        String strategy = (String)this.options.get("strategy");
        ArrayList<Object> myproviderURLs = new ArrayList<Object>(providerURLs);
        int index = 0;
        for (int i = 0; i < providerURLs.size(); ++i) {
            Context ictx;
            if (strategy != null && strategy.equals("random")) {
                index = (int)(System.currentTimeMillis() % (long)myproviderURLs.size());
            }
            String providerURL = (String)myproviderURLs.get(index);
            myproviderURLs.remove(index);
            providerURL = providerURL.trim();
            try {
                ictx = this.getInitialContext(providerURL);
            }
            catch (NamingException e) {
                continue;
            }
            for (String remoteResourceName : resourceNames) {
                JResourceRemote jResourceRemote = null;
                try {
                    Object o = ictx.lookup(remoteResourceName);
                    jResourceRemote = (JResourceRemote)PortableRemoteObject.narrow((Object)o, JResourceRemote.class);
                }
                catch (NamingException ne) {
                    // empty catch block
                }
                if (jResourceRemote == null) continue;
                return jResourceRemote;
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("The resources named '");
        Iterator<String> itResourceNames = resourceNames.iterator();
        while (itResourceNames.hasNext()) {
            sb.append(itResourceNames.next());
            if (!itResourceNames.hasNext()) continue;
            sb.append(",");
        }
        sb.append("' have not been found in the ");
        if (userProviderURLs == null) {
            sb.append("default InitialContext");
        } else {
            Iterator<String> itProv = userProviderURLs.iterator();
            sb.append("Inital Context with PROVIDER_URL = '");
            while (itProv.hasNext()) {
                sb.append(itProv.next());
                if (!itProv.hasNext()) continue;
                sb.append(",");
            }
            sb.append("'");
        }
        sb.append(". Check that the server names are correct and that resources are bound.");
        throw new LoginException(sb.toString());
    }

    protected Context getInitialContext(String providerURL) throws NamingException {
        if (providerURL == null) {
            return new InitialContext();
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", providerURL);
        return new InitialContext(env);
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.loginWasDoneWithSuccess && this.remoteSubject != null) {
            this.subject.getPrincipals().addAll(this.remoteSubject.getPrincipals());
            this.subject.getPrivateCredentials().add(this.password);
        }
        return this.loginWasDoneWithSuccess;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.loginWasDoneWithSuccess && this.remoteSubject != null) {
            this.remoteSubject = null;
        }
        return this.loginWasDoneWithSuccess;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.loginWasDoneWithSuccess && this.remoteSubject != null) {
            this.subject.getPrincipals().remove(this.remoteSubject.getPrincipals());
        }
        return this.loginWasDoneWithSuccess;
    }
}

