/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.auth.spi;

import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ow2.jonas.lib.security.auth.JSubject;
import org.ow2.jonas.security.auth.callback.CertificateCallback;
import org.ow2.jonas.security.internal.realm.factory.JResourceRemote;

public class JResourceLoginModule
implements LoginModule {
    private static final String DEFAULT_SERVER_NAME = "jonas";
    private Subject subject = null;
    private Subject remoteSubject = null;
    private CallbackHandler callbackHandler = null;
    private Map options = null;
    private String password = null;
    private boolean loginWasDoneWithSuccess = false;
    private boolean useUpperCaseUsername = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
    }

    public boolean login() throws LoginException {
        String useUpperCaseUsernameTxt;
        if (this.callbackHandler == null) {
            throw new LoginException("No handler has been defined.");
        }
        String resourceName = (String)this.options.get("resourceName");
        String serverName = (String)this.options.get("serverName");
        if (serverName == null) {
            serverName = DEFAULT_SERVER_NAME;
        }
        if ((useUpperCaseUsernameTxt = (String)this.options.get("useUpperCaseUsername")) != null && Boolean.valueOf(useUpperCaseUsernameTxt).booleanValue()) {
            this.useUpperCaseUsername = true;
        }
        String certCallback = (String)this.options.get("certCallback");
        if (resourceName == null) {
            throw new LoginException("You have to give an argument to this login module. The 'resourceName' parameter is required.");
        }
        String remoteResourceName = serverName + "_remoteres";
        try {
            InitialContext ictx = new InitialContext();
            JResourceRemote jResourceRemote = null;
            try {
                Object o;
                try {
                    o = ictx.lookup(remoteResourceName);
                }
                catch (NameNotFoundException e) {
                    Thread.sleep(2000L);
                    o = ictx.lookup(remoteResourceName);
                }
                jResourceRemote = (JResourceRemote)PortableRemoteObject.narrow((Object)o, JResourceRemote.class);
            }
            catch (Exception e) {
                throw JResourceLoginModule.createChainedLoginException("Cannot retrieve the resource '" + remoteResourceName + "'. Check that this resource is bound in the registry and that the server name is correct", e);
            }
            NameCallback nameCallback = new NameCallback("User :");
            PasswordCallback passwordCallback = new PasswordCallback("Password :", false);
            CertificateCallback certificateCallback = new CertificateCallback();
            Callback[] callbacks = null;
            callbacks = certCallback != null && Boolean.valueOf(certCallback) != false ? new Callback[]{nameCallback, passwordCallback, certificateCallback} : new Callback[]{nameCallback, passwordCallback};
            this.callbackHandler.handle(callbacks);
            String principalName = nameCallback.getName();
            if (principalName == null) {
                throw new LoginException("A null username is not a valid username");
            }
            if (principalName.startsWith("##DN##") && certificateCallback.getUserCertificate() == null) {
                throw new LoginException("Name must have a certificate to access this certificate based access login");
            }
            char[] arrayPass = passwordCallback.getPassword();
            if (arrayPass == null) {
                throw new LoginException("A null password is not a valid password");
            }
            if (this.useUpperCaseUsername) {
                principalName = principalName.toUpperCase();
            }
            this.password = new String(arrayPass);
            JSubject jSubject = null;
            try {
                jSubject = jResourceRemote.authenticate(principalName, arrayPass, resourceName);
            }
            catch (Exception e) {
                throw JResourceLoginModule.createChainedLoginException("Cannot authenticate with principal name = '" + principalName + "' : " + e.getMessage(), e);
            }
            this.remoteSubject = new Subject();
            this.remoteSubject.getPrivateCredentials().add(this.password);
            this.remoteSubject.getPrincipals().add(jSubject.getName());
            this.remoteSubject.getPrincipals().add(jSubject.getGroup());
        }
        catch (Exception e) {
            throw JResourceLoginModule.createChainedLoginException("Error during the login phase : " + e.getMessage(), e);
        }
        this.loginWasDoneWithSuccess = true;
        return true;
    }

    private static LoginException createChainedLoginException(String msg, Exception e) {
        LoginException le = new LoginException(msg);
        le.initCause(e);
        return le;
    }

    public boolean commit() throws LoginException {
        if (this.loginWasDoneWithSuccess && this.remoteSubject != null) {
            this.subject.getPrincipals().addAll(this.remoteSubject.getPrincipals());
            this.subject.getPrivateCredentials().add(this.password);
        }
        return this.loginWasDoneWithSuccess;
    }

    public boolean abort() throws LoginException {
        if (this.loginWasDoneWithSuccess && this.remoteSubject != null) {
            this.remoteSubject = null;
        }
        return this.loginWasDoneWithSuccess;
    }

    public boolean logout() throws LoginException {
        if (this.loginWasDoneWithSuccess && this.remoteSubject != null) {
            this.subject.getPrincipals().remove(this.remoteSubject.getPrincipals());
        }
        return this.loginWasDoneWithSuccess;
    }
}

