/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.service.manager;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.configuration.DeploymentPlanDeployer;
import org.ow2.jonas.depmonitor.MonitoringService;
import org.ow2.jonas.lib.management.javaee.J2EEServiceState;
import org.ow2.jonas.lib.service.manager.DeployableEnumeration;
import org.ow2.jonas.lib.service.manager.RequireJOnASServicesHandler;
import org.ow2.jonas.lib.service.manager.ServiceItem;
import org.ow2.jonas.lib.service.manager.ServiceTracker;
import org.ow2.jonas.lib.service.manager.ServiceUtil;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.management.ServiceManager;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.archive.api.IArchiveMetadata;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManagerCallback;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerImpl
implements ServiceManager {
    private Log logger = LogFactory.getLog(J2EEServerService.class);
    private List<ServiceItem> serviceItems = null;
    private BundleContext bundleContext;
    private ConfigurationManager configurationManager = null;
    private J2EEServerService j2eeServer = null;
    private IDeployerManager deployerManager = null;
    private DeploymentPlanDeployer deploymentPlanDeployer = null;
    private IDeployerManagerCallback deployerManagerCallback = null;
    private ServerProperties serverProperties = null;
    private static final String JONAS_STANDBY = "jonas.standby";
    private static final String REQUIRE_JONAS_SERVICES = "Require-JOnAS-Services";
    private static final String JPA_PROVIDER = "jpa.provider";
    private static final String EASYBANS_PERSISTENCE_PREFIX_SYMBOLIC_NAME = "org.ow2.easybeans.osgi.persistence.";
    private static final int WAITING_TIME = 20000;
    private static final int SERVICE_REGISTRATION_TIMEOUT = 10000;
    private boolean checkServiceStates = false;

    public ServiceManagerImpl(BundleContext bc) {
        this.bundleContext = bc;
        this.serviceItems = new ArrayList<ServiceItem>();
    }

    public void start() {
        this.deployerManagerCallback = new RequireJOnASServicesHandler(this);
        this.deployerManager.addCallback(this.deployerManagerCallback);
        this.updateServiceItems(true);
        if (this.getAllServices().contains("discovery")) {
            try {
                this.startService("discovery", ServiceItem.ServiceLevel.MANDATORY, true);
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot start the discovery service", new Object[]{e});
            }
        }
        if (!Boolean.getBoolean(JONAS_STANDBY)) {
            this.startServices(false);
        }
    }

    public void stop() {
        this.deployerManager.removeCallback(this.deployerManagerCallback);
    }

    private void addServiceItem(ServiceItem serviceItem) {
        this.serviceItems.add(serviceItem);
    }

    private void deleteAllServiceItems() {
        this.serviceItems.clear();
    }

    public List<String> getAllServices() {
        ArrayList<String> result = new ArrayList<String>();
        for (ServiceItem serviceItem : this.serviceItems) {
            result.add(serviceItem.getName());
        }
        return result;
    }

    public List<String> getOptionalServices() {
        ArrayList<String> result = new ArrayList<String>();
        for (ServiceItem serviceItem : this.serviceItems) {
            if (serviceItem.getServiceLevel() == ServiceItem.ServiceLevel.MANDATORY) continue;
            result.add(serviceItem.getName());
        }
        return result;
    }

    public J2EEServiceState setServiceState(String service, J2EEServiceState state) {
        ServiceItem serviceItem = this.getServiceItem(service);
        if (serviceItem == null) {
            this.logger.error((Object)("Service " + service + " not known"), new Object[0]);
            return null;
        }
        serviceItem.setState(state);
        if (serviceItem.getServiceLevel() != ServiceItem.ServiceLevel.MANDATORY) {
            this.checkServerState(service);
        }
        return state;
    }

    public String getServiceState(String service) {
        ServiceItem serviceItem = this.getServiceItem(service);
        if (serviceItem != null) {
            return serviceItem.getState().toString();
        }
        this.logger.error((Object)("getServiceState called but service " + service + " not known"), new Object[0]);
        return null;
    }

    public String getServiceDescription(String service) {
        ServiceItem serviceItem = this.getServiceItem(service);
        if (serviceItem != null) {
            return serviceItem.getDescription();
        }
        this.logger.error((Object)("getServiceDescription called but service " + service + " not known"), new Object[0]);
        return null;
    }

    private List<String> getNonRunningServices() {
        ArrayList<String> services = new ArrayList<String>();
        for (ServiceItem serviceItem : this.serviceItems) {
            J2EEServiceState state = serviceItem.getState();
            if (state.equals((Object)J2EEServiceState.RUNNING)) continue;
            services.add(serviceItem.getName());
        }
        return services;
    }

    private boolean allOptionalServicesStopped() {
        for (ServiceItem serviceItem : this.serviceItems) {
            J2EEServiceState state = serviceItem.getState();
            if (serviceItem.getServiceLevel() == ServiceItem.ServiceLevel.MANDATORY || state.equals((Object)J2EEServiceState.STOPPED)) continue;
            return false;
        }
        return true;
    }

    private void checkServerState(String service) {
        if (this.j2eeServer != null) {
            if (this.j2eeServer.isStarting() && this.getNonRunningServices().isEmpty() && !this.startMonitoring()) {
                this.j2eeServer.setRunning();
            }
            if (this.j2eeServer.isRunning() && "depmonitor".equals(service) && this.depMonitorRunning()) {
                this.startMonitoring();
            }
            if ((this.j2eeServer.isRunning() || this.j2eeServer.isStopping()) && this.allOptionalServicesStopped()) {
                this.j2eeServer.setStopped();
            }
        }
    }

    private boolean startMonitoring() {
        ServiceReference reference = this.depMonitorReference();
        if (reference != null) {
            MonitoringService monitoringService = (MonitoringService)this.bundleContext.getService(reference);
            monitoringService.startMonitoring();
            return true;
        }
        return false;
    }

    private boolean depMonitorRunning() {
        return this.depMonitorReference() != null;
    }

    private ServiceReference depMonitorReference() {
        return this.bundleContext.getServiceReference(MonitoringService.class.getName());
    }

    public void startService(String service, boolean deployOSGiResources) throws Exception {
        this.startService(service, ServiceItem.ServiceLevel.OPTIONAL, deployOSGiResources);
    }

    private void startService(String service, ServiceItem.ServiceLevel level, boolean deployOSGiResources) throws Exception {
        if (this.isServiceStopped(service)) {
            if (this.configurationManager.matchService(service)) {
                ServiceItem serviceItem = this.getServiceItem(service);
                if (serviceItem == null) {
                    serviceItem = this.createServiceItem(service, level);
                    this.addServiceItem(serviceItem);
                }
                serviceItem.setState(J2EEServiceState.STARTING);
                this.configurationManager.updateServiceConfiguration(service);
            }
            if (deployOSGiResources) {
                if ("ejb3".equals(service) || "jaxws".equals(service) || "ejb3-client".equals(service)) {
                    this.deployEasyBeans();
                }
                if (!"ejb3-client".equals(service)) {
                    this.deploymentPlanDeployer.deploy(service);
                }
            }
        } else {
            this.logger.debug((Object)"Service ''{0}'' is already starting or running", new Object[]{service});
        }
    }

    public void startRequiredServices(IDeployable<?> deployable) {
        IArchiveMetadata metadata;
        if (this.serverProperties.isDevelopment()) {
            String service;
            if (EARDeployable.class.isInstance(deployable)) {
                for (IDeployable internalDeployable : ((EARDeployable)EARDeployable.class.cast(deployable)).getAllDeployables()) {
                    this.startRequiredServices(internalDeployable);
                }
            }
            if ((service = DeployableEnumeration.getService(deployable)) != null) {
                try {
                    if (this.isServiceStopped(service)) {
                        this.startService(service, ServiceItem.ServiceLevel.REQUIRED, true);
                        this.waitForServiceRegistration(service);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)"Cannot start required service ''{0}''", new Object[]{service, e});
                }
            }
        }
        if ((metadata = deployable.getArchive().getMetadata()) != null) {
            String services = metadata.get(REQUIRE_JONAS_SERVICES);
            for (String service : this.convertToList(services)) {
                try {
                    this.startService(service, ServiceItem.ServiceLevel.REQUIRED, true);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Cannot start required service ''{0}''", new Object[]{service, e});
                }
            }
        }
    }

    public void stopService(String service) throws Exception {
        try {
            this.configurationManager.deleteServiceConfiguration(service);
        }
        catch (Exception e) {
            this.logger.error((Object)"Cannot delete configuration for the ''{0 }}' service", new Object[]{service});
        }
    }

    public void startServices() {
        this.startServices(true);
    }

    private void startServices(boolean updateServiceStates) {
        if (updateServiceStates) {
            this.updateServiceItems();
        }
        new Thread(){

            public void run() {
                if (ServiceManagerImpl.this.serverProperties.isDevelopment()) {
                    try {
                        ServiceManagerImpl.this.startService("wc", true);
                    }
                    catch (Exception e) {
                        ServiceManagerImpl.this.logger.error((Object)"Cannot start the work cleaner service", new Object[]{e});
                    }
                }
                for (String service : ServiceManagerImpl.this.getOptionalServices()) {
                    try {
                        ServiceManagerImpl.this.startService(service, true);
                    }
                    catch (Exception e) {
                        ServiceManagerImpl.this.logger.error((Object)"Cannot start the ''{0}'' service", new Object[]{service, e});
                    }
                }
                try {
                    ServiceManagerImpl.this.checkServiceStates = true;
                    Thread.sleep(20000L);
                    ServiceManagerImpl.this.checkServiceStates();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void stopServices() {
        List<String> services = this.getOptionalServices();
        if (services.contains("ear")) {
            services.remove("ear");
            services.add(0, "ear");
        }
        if (services.contains("depmonitor")) {
            services.remove("depmonitor");
            services.add(0, "depmonitor");
        }
        for (String service : services) {
            try {
                this.stopService(service);
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot stop the ''{}'' service", new Object[]{e});
            }
        }
    }

    private ServiceItem createServiceItem(String service, ServiceItem.ServiceLevel serviceLevel) {
        return this.createServiceItem(service, serviceLevel, J2EEServiceState.STOPPED);
    }

    private ServiceItem createServiceItem(String name, ServiceItem.ServiceLevel serviceLevel, J2EEServiceState state) {
        ServiceItem serviceItem = new ServiceItem();
        serviceItem.setName(name);
        serviceItem.setDescription(name + " description ...");
        serviceItem.setState(state);
        serviceItem.setServiceLevel(serviceLevel);
        return serviceItem;
    }

    public void bindJ2EEServer(J2EEServerService j2eeServer) {
        this.j2eeServer = j2eeServer;
    }

    public void unbindJ2EEServer(J2EEServerService j2eeServer) {
        this.j2eeServer = null;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void setDeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        this.deploymentPlanDeployer = deploymentPlanDeployer;
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void disableServiceStatesCheck() {
        this.checkServiceStates = false;
    }

    private void updateServiceItems() {
        this.updateServiceItems(false);
    }

    private void updateServiceItems(boolean startServiceListener) {
        this.deleteAllServiceItems();
        for (String service : this.configurationManager.getMandatoryServices()) {
            this.addServiceItem(this.createServiceItem(service, ServiceItem.ServiceLevel.MANDATORY));
        }
        for (String service : this.configurationManager.getOptionalServices()) {
            this.addServiceItem(this.createServiceItem(service, ServiceItem.ServiceLevel.OPTIONAL));
        }
        if (startServiceListener) {
            ServiceTracker listener = new ServiceTracker(this);
            this.bundleContext.addServiceListener((ServiceListener)listener);
        }
        try {
            List<String> runningServices = ServiceUtil.getRunningServices(this.bundleContext);
            for (String service : runningServices) {
                this.setServiceState(service, J2EEServiceState.RUNNING);
            }
        }
        catch (InvalidSyntaxException e) {
            this.logger.error((Object)"Unable to get running services", new Object[]{e});
        }
    }

    private List<String> convertToList(String param) {
        ArrayList<String> result = new ArrayList<String>();
        if (param != null && !param.equals("")) {
            for (String element : param.split(",")) {
                result.add(element);
            }
        }
        return result;
    }

    private void checkServiceStates() {
        if (this.checkServiceStates && !this.getNonRunningServices().isEmpty()) {
            this.logger.error((Object)"JOnAS server cannot reach the RUNNING state", new Object[0]);
            for (String service : this.getNonRunningServices()) {
                this.logger.error((Object)"Service ''{0}'' is not running", new Object[]{service});
            }
            this.logger.error((Object)"Please check the JOnAS server configuration.", new Object[0]);
        }
    }

    private void deployEasyBeans() throws Exception {
        String[] providers;
        this.deploymentPlanDeployer.deploy("easybeans-core");
        String jpaProviders = (String)this.configurationManager.getServiceProperties("ejb3").get(JPA_PROVIDER);
        if (jpaProviders == null && "".equals(jpaProviders)) {
            return;
        }
        for (String jpaProvider : providers = jpaProviders.split(",")) {
            this.deploymentPlanDeployer.deploy("easybeans-persistence-".concat(jpaProvider.trim()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForServiceRegistration(String service) {
        long endTime = System.currentTimeMillis() + 10000L;
        ServiceManagerImpl serviceManagerImpl = this;
        synchronized (serviceManagerImpl) {
            while (!this.isServiceStarted(service)) {
                long timeout = endTime - System.currentTimeMillis();
                if (timeout > 0L) {
                    try {
                        this.wait(timeout);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                this.logger.error((Object)"Timout expired waiting for ''{0}'' service registration", new Object[]{service});
                return;
            }
        }
    }

    protected boolean isServiceStarted(String service) {
        return this.getServiceItem(service) != null && this.getServiceItem(service).getState() == J2EEServiceState.RUNNING;
    }

    protected boolean isServiceStopped(String service) {
        return this.getServiceItem(service) == null || this.getServiceItem(service).getState() == J2EEServiceState.STOPPED;
    }

    private ServiceItem getServiceItem(String service) {
        for (ServiceItem serviceItem : this.serviceItems) {
            if (!serviceItem.getName().equals(service)) continue;
            return serviceItem;
        }
        return null;
    }
}

