/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.service.manager;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.configuration.DeploymentPlanDeployer;
import org.ow2.jonas.depmonitor.MonitoringService;
import org.ow2.jonas.lib.management.javaee.J2EEServiceState;
import org.ow2.jonas.lib.service.manager.RequireJOnASServicesHandler;
import org.ow2.jonas.lib.service.manager.ServiceItem;
import org.ow2.jonas.lib.service.manager.ServiceTracker;
import org.ow2.jonas.lib.service.manager.ServiceUtil;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.management.ServiceManager;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.archive.api.IArchiveMetadata;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManagerCallback;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerImpl
implements ServiceManager,
Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private boolean __FserviceStates;
    private Map<String, ServiceItem> serviceStates;
    private boolean __FbundleContext;
    private BundleContext bundleContext;
    private boolean __FconfigurationManager;
    private ConfigurationManager configurationManager;
    private boolean __Fj2eeServer;
    private J2EEServerService j2eeServer;
    private boolean __FdeployerManager;
    private IDeployerManager deployerManager;
    private boolean __FdeploymentPlanDeployer;
    private DeploymentPlanDeployer deploymentPlanDeployer;
    private boolean __FdeployerManagerCallback;
    private IDeployerManagerCallback deployerManagerCallback;
    private boolean __FserverProperties;
    private ServerProperties serverProperties;
    private static final String JONAS_BOOTSTRAP = "jonas.bootstrap";
    private static final String REQUIRE_JONAS_SERVICES = "Require-JOnAS-Services";
    private static final String JPA_PROVIDER = "jpa.provider";
    private static final String EASYBANS_PREFIX_SYMBOLIC_NAME = "org.ow2.easybeans.core.for.jonas.";
    private static final int WAITING_TIME = 10000;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MaddService$org_ow2_jonas_lib_service_manager_ServiceItem;
    private boolean __MdeleteAllServices;
    private boolean __MgetAllServices;
    private boolean __MgetOptionalServices;
    private boolean __MsetServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState;
    private boolean __MgetServiceState$java_lang_String;
    private boolean __MgetServiceDescription$java_lang_String;
    private boolean __MgetNonRunningServices;
    private boolean __MallOptionalServicesStopped;
    private boolean __McheckServerState$java_lang_String;
    private boolean __MstartMonitoring;
    private boolean __MdepMonitorRunning;
    private boolean __MdepMonitorReference;
    private boolean __MupdateServiceStates;
    private boolean __MstartService$java_lang_String;
    private boolean __MstartRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MstopService$java_lang_String;
    private boolean __MstartServices;
    private boolean __MstartServices$boolean;
    private boolean __MstopServices;
    private boolean __McreateServiceItem$java_lang_String$boolean;
    private boolean __McreateServiceItem$java_lang_String$boolean$org_ow2_jonas_lib_management_javaee_J2EEServiceState;
    private boolean __MbindJ2EEServer$org_ow2_jonas_management_J2EEServerService;
    private boolean __MunbindJ2EEServer$org_ow2_jonas_management_J2EEServerService;
    private boolean __MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager;
    private boolean __MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager;
    private boolean __MsetDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer;
    private boolean __MsetServerProperties$org_ow2_jonas_properties_ServerProperties;
    private boolean __MconvertToList$java_lang_String;
    private boolean __MreverseList$java_util_List;
    private boolean __McheckServiceStates;
    private boolean __MdeployEasyBeans;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    Map __getserviceStates() {
        if (!this.__FserviceStates) {
            return this.serviceStates;
        }
        return (Map)this.__IM.onGet((Object)this, "serviceStates");
    }

    void __setserviceStates(Map map) {
        if (!this.__FserviceStates) {
            this.serviceStates = map;
            return;
        }
        this.__IM.onSet((Object)this, "serviceStates", (Object)map);
    }

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    ConfigurationManager __getconfigurationManager() {
        if (!this.__FconfigurationManager) {
            return this.configurationManager;
        }
        return (ConfigurationManager)this.__IM.onGet((Object)this, "configurationManager");
    }

    void __setconfigurationManager(ConfigurationManager configurationManager) {
        if (!this.__FconfigurationManager) {
            this.configurationManager = configurationManager;
            return;
        }
        this.__IM.onSet((Object)this, "configurationManager", (Object)configurationManager);
    }

    J2EEServerService __getj2eeServer() {
        if (!this.__Fj2eeServer) {
            return this.j2eeServer;
        }
        return (J2EEServerService)this.__IM.onGet((Object)this, "j2eeServer");
    }

    void __setj2eeServer(J2EEServerService j2EEServerService) {
        if (!this.__Fj2eeServer) {
            this.j2eeServer = j2EEServerService;
            return;
        }
        this.__IM.onSet((Object)this, "j2eeServer", (Object)j2EEServerService);
    }

    IDeployerManager __getdeployerManager() {
        if (!this.__FdeployerManager) {
            return this.deployerManager;
        }
        return (IDeployerManager)this.__IM.onGet((Object)this, "deployerManager");
    }

    void __setdeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__FdeployerManager) {
            this.deployerManager = iDeployerManager;
            return;
        }
        this.__IM.onSet((Object)this, "deployerManager", (Object)iDeployerManager);
    }

    DeploymentPlanDeployer __getdeploymentPlanDeployer() {
        if (!this.__FdeploymentPlanDeployer) {
            return this.deploymentPlanDeployer;
        }
        return (DeploymentPlanDeployer)this.__IM.onGet((Object)this, "deploymentPlanDeployer");
    }

    void __setdeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        if (!this.__FdeploymentPlanDeployer) {
            this.deploymentPlanDeployer = deploymentPlanDeployer;
            return;
        }
        this.__IM.onSet((Object)this, "deploymentPlanDeployer", (Object)deploymentPlanDeployer);
    }

    IDeployerManagerCallback __getdeployerManagerCallback() {
        if (!this.__FdeployerManagerCallback) {
            return this.deployerManagerCallback;
        }
        return (IDeployerManagerCallback)this.__IM.onGet((Object)this, "deployerManagerCallback");
    }

    void __setdeployerManagerCallback(IDeployerManagerCallback iDeployerManagerCallback) {
        if (!this.__FdeployerManagerCallback) {
            this.deployerManagerCallback = iDeployerManagerCallback;
            return;
        }
        this.__IM.onSet((Object)this, "deployerManagerCallback", (Object)iDeployerManagerCallback);
    }

    ServerProperties __getserverProperties() {
        if (!this.__FserverProperties) {
            return this.serverProperties;
        }
        return (ServerProperties)this.__IM.onGet((Object)this, "serverProperties");
    }

    void __setserverProperties(ServerProperties serverProperties) {
        if (!this.__FserverProperties) {
            this.serverProperties = serverProperties;
            return;
        }
        this.__IM.onSet((Object)this, "serverProperties", (Object)serverProperties);
    }

    public ServiceManagerImpl(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ServiceManagerImpl(InstanceManager _manager, BundleContext bc) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(J2EEServerService.class));
        this.__setserviceStates(null);
        this.__setconfigurationManager(null);
        this.__setj2eeServer(null);
        this.__setdeployerManager(null);
        this.__setdeploymentPlanDeployer(null);
        this.__setdeployerManagerCallback(null);
        this.__setserverProperties(null);
        this.__setbundleContext(bc);
        this.__setserviceStates(new LinkedHashMap());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() {
        this.__setdeployerManagerCallback(new RequireJOnASServicesHandler(this));
        this.__getdeployerManager().addCallback(this.__getdeployerManagerCallback());
        this.updateServiceStates();
        if (!Boolean.getBoolean(JONAS_BOOTSTRAP)) {
            this.startServices(false);
        }
        ServiceTracker listener = new ServiceTracker(this);
        this.__getbundleContext().addServiceListener((ServiceListener)listener);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() {
        this.__getdeployerManager().removeCallback(this.__getdeployerManagerCallback());
    }

    private void addService(ServiceItem serviceItem) {
        if (!this.__MaddService$org_ow2_jonas_lib_service_manager_ServiceItem) {
            this.__addService(serviceItem);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addService$org_ow2_jonas_lib_service_manager_ServiceItem", new Object[]{serviceItem});
            this.__addService(serviceItem);
            this.__IM.onExit((Object)this, "addService$org_ow2_jonas_lib_service_manager_ServiceItem", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addService$org_ow2_jonas_lib_service_manager_ServiceItem", throwable);
            throw throwable;
        }
    }

    private void __addService(ServiceItem serviceItem) {
        this.__getserviceStates().put(serviceItem.getName(), serviceItem);
    }

    private void deleteAllServices() {
        if (!this.__MdeleteAllServices) {
            this.__deleteAllServices();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deleteAllServices", new Object[0]);
            this.__deleteAllServices();
            this.__IM.onExit((Object)this, "deleteAllServices", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deleteAllServices", throwable);
            throw throwable;
        }
    }

    private void __deleteAllServices() {
        this.__getserviceStates().clear();
    }

    public List<String> getAllServices() {
        List<String> list;
        if (!this.__MgetAllServices) {
            return this.__getAllServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getAllServices", new Object[0]);
            list = this.__getAllServices();
            this.__IM.onExit((Object)this, "getAllServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAllServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getAllServices() {
        ArrayList<String> result = new ArrayList<String>();
        for (ServiceItem serviceItem : this.__getserviceStates().values()) {
            result.add(serviceItem.getName());
        }
        return result;
    }

    public List<String> getOptionalServices() {
        List<String> list;
        if (!this.__MgetOptionalServices) {
            return this.__getOptionalServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getOptionalServices", new Object[0]);
            list = this.__getOptionalServices();
            this.__IM.onExit((Object)this, "getOptionalServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOptionalServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getOptionalServices() {
        ArrayList<String> result = new ArrayList<String>();
        for (ServiceItem serviceItem : this.__getserviceStates().values()) {
            if (serviceItem.isMandatory()) continue;
            result.add(serviceItem.getName());
        }
        return result;
    }

    public J2EEServiceState setServiceState(String string, J2EEServiceState j2EEServiceState) {
        J2EEServiceState j2EEServiceState2;
        if (!this.__MsetServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState) {
            return this.__setServiceState(string, j2EEServiceState);
        }
        try {
            this.__IM.onEntry((Object)this, "setServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState", new Object[]{string, j2EEServiceState});
            j2EEServiceState2 = this.__setServiceState(string, j2EEServiceState);
            this.__IM.onExit((Object)this, "setServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState", (Object)j2EEServiceState2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState", throwable);
            throw throwable;
        }
        return j2EEServiceState2;
    }

    private J2EEServiceState __setServiceState(String serviceName, J2EEServiceState state) {
        ServiceItem serviceItem = (ServiceItem)this.__getserviceStates().get(serviceName);
        if (serviceItem == null) {
            this.__getlogger().error((Object)("Service " + serviceName + " not known"), new Object[0]);
            return null;
        }
        serviceItem.setState(state);
        if (!serviceItem.isMandatory()) {
            this.checkServerState(serviceName);
        }
        return state;
    }

    public String getServiceState(String string) {
        String string2;
        if (!this.__MgetServiceState$java_lang_String) {
            return this.__getServiceState(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceState$java_lang_String", new Object[]{string});
            string2 = this.__getServiceState(string);
            this.__IM.onExit((Object)this, "getServiceState$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceState$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getServiceState(String serviceName) {
        ServiceItem serviceItem = (ServiceItem)this.__getserviceStates().get(serviceName);
        if (serviceItem != null) {
            return serviceItem.getState().toString();
        }
        this.__getlogger().error((Object)("getServiceState called but service " + serviceName + " not known"), new Object[0]);
        return null;
    }

    public String getServiceDescription(String string) {
        String string2;
        if (!this.__MgetServiceDescription$java_lang_String) {
            return this.__getServiceDescription(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getServiceDescription$java_lang_String", new Object[]{string});
            string2 = this.__getServiceDescription(string);
            this.__IM.onExit((Object)this, "getServiceDescription$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServiceDescription$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getServiceDescription(String serviceName) {
        ServiceItem serviceItem = (ServiceItem)this.__getserviceStates().get(serviceName);
        if (serviceItem != null) {
            return serviceItem.getDescription();
        }
        this.__getlogger().error((Object)("getServiceDescription called but service " + serviceName + " not known"), new Object[0]);
        return null;
    }

    private List<String> getNonRunningServices() {
        List<String> list;
        if (!this.__MgetNonRunningServices) {
            return this.__getNonRunningServices();
        }
        try {
            this.__IM.onEntry((Object)this, "getNonRunningServices", new Object[0]);
            list = this.__getNonRunningServices();
            this.__IM.onExit((Object)this, "getNonRunningServices", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNonRunningServices", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getNonRunningServices() {
        ArrayList<String> services = new ArrayList<String>();
        for (ServiceItem serviceItem : this.__getserviceStates().values()) {
            J2EEServiceState state = serviceItem.getState();
            if (state.equals((Object)J2EEServiceState.RUNNING)) continue;
            services.add(serviceItem.getName());
        }
        return services;
    }

    private boolean allOptionalServicesStopped() {
        boolean bl;
        if (!this.__MallOptionalServicesStopped) {
            return this.__allOptionalServicesStopped();
        }
        try {
            this.__IM.onEntry((Object)this, "allOptionalServicesStopped", new Object[0]);
            bl = this.__allOptionalServicesStopped();
            this.__IM.onExit((Object)this, "allOptionalServicesStopped", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "allOptionalServicesStopped", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __allOptionalServicesStopped() {
        for (ServiceItem serviceItem : this.__getserviceStates().values()) {
            J2EEServiceState state = serviceItem.getState();
            if (serviceItem.isMandatory() || state.equals((Object)J2EEServiceState.STOPPED)) continue;
            return false;
        }
        return true;
    }

    private void checkServerState(String string) {
        if (!this.__McheckServerState$java_lang_String) {
            this.__checkServerState(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "checkServerState$java_lang_String", new Object[]{string});
            this.__checkServerState(string);
            this.__IM.onExit((Object)this, "checkServerState$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkServerState$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __checkServerState(String serviceName) {
        if (this.__getj2eeServer() != null) {
            if (this.__getj2eeServer().isStarting() && this.getNonRunningServices().isEmpty() && !this.startMonitoring()) {
                this.__getj2eeServer().setRunning();
            }
            if (this.__getj2eeServer().isRunning() && "depmonitor".equals(serviceName) && this.depMonitorRunning()) {
                this.startMonitoring();
            }
            if ((this.__getj2eeServer().isRunning() || this.__getj2eeServer().isStopping()) && this.allOptionalServicesStopped()) {
                this.__getj2eeServer().setStopped();
            }
        }
    }

    private boolean startMonitoring() {
        boolean bl;
        if (!this.__MstartMonitoring) {
            return this.__startMonitoring();
        }
        try {
            this.__IM.onEntry((Object)this, "startMonitoring", new Object[0]);
            bl = this.__startMonitoring();
            this.__IM.onExit((Object)this, "startMonitoring", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startMonitoring", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __startMonitoring() {
        ServiceReference reference = this.depMonitorReference();
        if (reference != null) {
            MonitoringService monitoringService = (MonitoringService)this.__getbundleContext().getService(reference);
            monitoringService.startMonitoring();
            return true;
        }
        return false;
    }

    private boolean depMonitorRunning() {
        boolean bl;
        if (!this.__MdepMonitorRunning) {
            return this.__depMonitorRunning();
        }
        try {
            this.__IM.onEntry((Object)this, "depMonitorRunning", new Object[0]);
            bl = this.__depMonitorRunning();
            this.__IM.onExit((Object)this, "depMonitorRunning", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "depMonitorRunning", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __depMonitorRunning() {
        return this.depMonitorReference() != null;
    }

    private ServiceReference depMonitorReference() {
        ServiceReference serviceReference;
        if (!this.__MdepMonitorReference) {
            return this.__depMonitorReference();
        }
        try {
            this.__IM.onEntry((Object)this, "depMonitorReference", new Object[0]);
            serviceReference = this.__depMonitorReference();
            this.__IM.onExit((Object)this, "depMonitorReference", (Object)serviceReference);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "depMonitorReference", throwable);
            throw throwable;
        }
        return serviceReference;
    }

    private ServiceReference __depMonitorReference() {
        return this.__getbundleContext().getServiceReference(MonitoringService.class.getName());
    }

    public void updateServiceStates() {
        if (!this.__MupdateServiceStates) {
            this.__updateServiceStates();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateServiceStates", new Object[0]);
            this.__updateServiceStates();
            this.__IM.onExit((Object)this, "updateServiceStates", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateServiceStates", throwable);
            throw throwable;
        }
    }

    private void __updateServiceStates() {
        this.deleteAllServices();
        for (String service : this.__getconfigurationManager().getMandatoryServices()) {
            this.addService(this.createServiceItem(service, Boolean.TRUE));
        }
        for (String service : this.__getconfigurationManager().getOptionalServices()) {
            this.addService(this.createServiceItem(service, Boolean.FALSE));
        }
        try {
            List<String> runningServices = ServiceUtil.getRunningServices(this.__getbundleContext());
            for (String service : runningServices) {
                this.setServiceState(service, J2EEServiceState.RUNNING);
            }
        }
        catch (InvalidSyntaxException e) {
            this.__getlogger().error((Object)"Unable to get running services", new Object[]{e});
        }
    }

    public void startService(String string) throws Exception {
        if (!this.__MstartService$java_lang_String) {
            this.__startService(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startService$java_lang_String", new Object[]{string});
            this.__startService(string);
            this.__IM.onExit((Object)this, "startService$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startService$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __startService(String service) throws Exception {
        if (this.__getserviceStates().get(service) == null || ((ServiceItem)this.__getserviceStates().get(service)).getState() == J2EEServiceState.STOPPED) {
            if (this.__getconfigurationManager().matchService(service)) {
                this.addService(this.createServiceItem(service, false, J2EEServiceState.STARTING));
                this.__getconfigurationManager().updateServiceConfiguration(service);
            }
            if (service.equals("ejb3") || service.equals("jaxws")) {
                this.deployEasyBeans();
            }
            this.__getdeploymentPlanDeployer().deploy(service);
        } else {
            this.__getlogger().debug((Object)"Service ''{0}'' is already starting or running", new Object[]{service});
        }
    }

    public void startRequiredServices(IDeployable<?> iDeployable) {
        if (!this.__MstartRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this.__startRequiredServices(iDeployable);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            this.__startRequiredServices(iDeployable);
            this.__IM.onExit((Object)this, "startRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
    }

    private void __startRequiredServices(IDeployable<?> deployable) {
        IArchiveMetadata metadata = deployable.getArchive().getMetadata();
        if (metadata != null) {
            String services = metadata.get(REQUIRE_JONAS_SERVICES);
            for (String service : this.convertToList(services)) {
                try {
                    this.startService(service);
                }
                catch (Exception e) {
                    this.__getlogger().error((Object)"Cannot start required service ''{0}''", new Object[]{service, e});
                }
            }
        }
    }

    public void stopService(String string) throws Exception {
        if (!this.__MstopService$java_lang_String) {
            this.__stopService(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopService$java_lang_String", new Object[]{string});
            this.__stopService(string);
            this.__IM.onExit((Object)this, "stopService$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopService$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __stopService(String service) throws Exception {
        try {
            this.__getconfigurationManager().deleteServiceConfiguration(service);
        }
        catch (Exception e) {
            this.__getlogger().error((Object)"Cannot delete configuration for the ''{0 }}' service", new Object[]{service});
        }
    }

    public void startServices() {
        if (!this.__MstartServices) {
            this.__startServices();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startServices", new Object[0]);
            this.__startServices();
            this.__IM.onExit((Object)this, "startServices", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startServices", throwable);
            throw throwable;
        }
    }

    private void __startServices() {
        this.startServices(true);
    }

    private void startServices(boolean bl) {
        if (!this.__MstartServices$boolean) {
            this.__startServices(bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startServices$boolean", new Object[]{new Boolean(bl)});
            this.__startServices(bl);
            this.__IM.onExit((Object)this, "startServices$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startServices$boolean", throwable);
            throw throwable;
        }
    }

    private void __startServices(boolean updateServiceStates) {
        if (updateServiceStates) {
            this.updateServiceStates();
        }
        new Thread(){

            public void run() {
                if (ServiceManagerImpl.this.__getserverProperties().isDevelopment()) {
                    try {
                        ServiceManagerImpl.this.startService("wc");
                    }
                    catch (Exception e) {
                        ServiceManagerImpl.this.__getlogger().error((Object)"Cannot start the work cleaner service", new Object[]{e});
                    }
                }
                for (String service : ServiceManagerImpl.this.getOptionalServices()) {
                    try {
                        ServiceManagerImpl.this.startService(service);
                    }
                    catch (Exception e) {
                        ServiceManagerImpl.this.__getlogger().error((Object)"Cannot start the ''{0}'' service", new Object[]{service, e});
                    }
                }
                try {
                    Thread.sleep(10000L);
                    ServiceManagerImpl.this.checkServiceStates();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void stopServices() {
        if (!this.__MstopServices) {
            this.__stopServices();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopServices", new Object[0]);
            this.__stopServices();
            this.__IM.onExit((Object)this, "stopServices", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopServices", throwable);
            throw throwable;
        }
    }

    private void __stopServices() {
        for (String service : this.reverseList(this.getOptionalServices())) {
            try {
                this.stopService(service);
            }
            catch (Exception e) {
                this.__getlogger().error((Object)"Cannot stop the ''{}'' service", new Object[]{e});
            }
        }
    }

    private ServiceItem createServiceItem(String string, boolean bl) {
        ServiceItem serviceItem;
        if (!this.__McreateServiceItem$java_lang_String$boolean) {
            return this.__createServiceItem(string, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "createServiceItem$java_lang_String$boolean", new Object[]{string, new Boolean(bl)});
            serviceItem = this.__createServiceItem(string, bl);
            this.__IM.onExit((Object)this, "createServiceItem$java_lang_String$boolean", (Object)serviceItem);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createServiceItem$java_lang_String$boolean", throwable);
            throw throwable;
        }
        return serviceItem;
    }

    private ServiceItem __createServiceItem(String service, boolean mandatory) {
        return this.createServiceItem(service, mandatory, J2EEServiceState.STOPPED);
    }

    private ServiceItem createServiceItem(String string, boolean bl, J2EEServiceState j2EEServiceState) {
        ServiceItem serviceItem;
        if (!this.__McreateServiceItem$java_lang_String$boolean$org_ow2_jonas_lib_management_javaee_J2EEServiceState) {
            return this.__createServiceItem(string, bl, j2EEServiceState);
        }
        try {
            this.__IM.onEntry((Object)this, "createServiceItem$java_lang_String$boolean$org_ow2_jonas_lib_management_javaee_J2EEServiceState", new Object[]{string, new Boolean(bl), j2EEServiceState});
            serviceItem = this.__createServiceItem(string, bl, j2EEServiceState);
            this.__IM.onExit((Object)this, "createServiceItem$java_lang_String$boolean$org_ow2_jonas_lib_management_javaee_J2EEServiceState", (Object)serviceItem);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createServiceItem$java_lang_String$boolean$org_ow2_jonas_lib_management_javaee_J2EEServiceState", throwable);
            throw throwable;
        }
        return serviceItem;
    }

    private ServiceItem __createServiceItem(String service, boolean mandatory, J2EEServiceState state) {
        ServiceItem serviceItem = new ServiceItem();
        serviceItem.setName(service);
        serviceItem.setDescription(service + " description ...");
        serviceItem.setState(state);
        serviceItem.setMandatory(mandatory);
        return serviceItem;
    }

    public void bindJ2EEServer(J2EEServerService j2EEServerService) {
        if (!this.__MbindJ2EEServer$org_ow2_jonas_management_J2EEServerService) {
            this.__bindJ2EEServer(j2EEServerService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindJ2EEServer$org_ow2_jonas_management_J2EEServerService", new Object[]{j2EEServerService});
            this.__bindJ2EEServer(j2EEServerService);
            this.__IM.onExit((Object)this, "bindJ2EEServer$org_ow2_jonas_management_J2EEServerService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindJ2EEServer$org_ow2_jonas_management_J2EEServerService", throwable);
            throw throwable;
        }
    }

    private void __bindJ2EEServer(J2EEServerService j2eeServer) {
        this.__setj2eeServer(j2eeServer);
    }

    public void unbindJ2EEServer(J2EEServerService j2EEServerService) {
        if (!this.__MunbindJ2EEServer$org_ow2_jonas_management_J2EEServerService) {
            this.__unbindJ2EEServer(j2EEServerService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindJ2EEServer$org_ow2_jonas_management_J2EEServerService", new Object[]{j2EEServerService});
            this.__unbindJ2EEServer(j2EEServerService);
            this.__IM.onExit((Object)this, "unbindJ2EEServer$org_ow2_jonas_management_J2EEServerService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindJ2EEServer$org_ow2_jonas_management_J2EEServerService", throwable);
            throw throwable;
        }
    }

    private void __unbindJ2EEServer(J2EEServerService j2eeServer) {
        this.__setj2eeServer(null);
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        if (!this.__MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager) {
            this.__setConfigurationManager(configurationManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", new Object[]{configurationManager});
            this.__setConfigurationManager(configurationManager);
            this.__IM.onExit((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager", throwable);
            throw throwable;
        }
    }

    private void __setConfigurationManager(ConfigurationManager configurationManager) {
        this.__setconfigurationManager(configurationManager);
    }

    public void setDeployerManager(IDeployerManager iDeployerManager) {
        if (!this.__MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager) {
            this.__setDeployerManager(iDeployerManager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", new Object[]{iDeployerManager});
            this.__setDeployerManager(iDeployerManager);
            this.__IM.onExit((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager", throwable);
            throw throwable;
        }
    }

    private void __setDeployerManager(IDeployerManager deployerManager) {
        this.__setdeployerManager(deployerManager);
    }

    public void setDeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        if (!this.__MsetDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer) {
            this.__setDeploymentPlanDeployer(deploymentPlanDeployer);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer", new Object[]{deploymentPlanDeployer});
            this.__setDeploymentPlanDeployer(deploymentPlanDeployer);
            this.__IM.onExit((Object)this, "setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer", throwable);
            throw throwable;
        }
    }

    private void __setDeploymentPlanDeployer(DeploymentPlanDeployer deploymentPlanDeployer) {
        this.__setdeploymentPlanDeployer(deploymentPlanDeployer);
    }

    public void setServerProperties(ServerProperties serverProperties) {
        if (!this.__MsetServerProperties$org_ow2_jonas_properties_ServerProperties) {
            this.__setServerProperties(serverProperties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", new Object[]{serverProperties});
            this.__setServerProperties(serverProperties);
            this.__IM.onExit((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setServerProperties$org_ow2_jonas_properties_ServerProperties", throwable);
            throw throwable;
        }
    }

    private void __setServerProperties(ServerProperties serverProperties) {
        this.__setserverProperties(serverProperties);
    }

    private List<String> convertToList(String string) {
        List<String> list;
        if (!this.__MconvertToList$java_lang_String) {
            return this.__convertToList(string);
        }
        try {
            this.__IM.onEntry((Object)this, "convertToList$java_lang_String", new Object[]{string});
            list = this.__convertToList(string);
            this.__IM.onExit((Object)this, "convertToList$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convertToList$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __convertToList(String param) {
        ArrayList<String> result = new ArrayList<String>();
        if (param != null && !param.equals("")) {
            for (String element : param.split(",")) {
                result.add(element);
            }
        }
        return result;
    }

    private List<String> reverseList(List<String> list) {
        List<String> list2;
        if (!this.__MreverseList$java_util_List) {
            return this.__reverseList(list);
        }
        try {
            this.__IM.onEntry((Object)this, "reverseList$java_util_List", new Object[]{list});
            list2 = this.__reverseList(list);
            this.__IM.onExit((Object)this, "reverseList$java_util_List", list2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reverseList$java_util_List", throwable);
            throw throwable;
        }
        return list2;
    }

    private List<String> __reverseList(List<String> list) {
        ArrayList<String> reversedList = new ArrayList<String>();
        for (String element : list) {
            reversedList.add(0, element);
        }
        return reversedList;
    }

    private void checkServiceStates() {
        if (!this.__McheckServiceStates) {
            this.__checkServiceStates();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "checkServiceStates", new Object[0]);
            this.__checkServiceStates();
            this.__IM.onExit((Object)this, "checkServiceStates", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "checkServiceStates", throwable);
            throw throwable;
        }
    }

    private void __checkServiceStates() {
        if (!this.getNonRunningServices().isEmpty()) {
            this.__getlogger().error((Object)"JOnAS server cannot reach the RUNNING state", new Object[0]);
            for (String service : this.getNonRunningServices()) {
                this.__getlogger().error((Object)"Service ''{0}'' is not running", new Object[]{service});
            }
            this.__getlogger().error((Object)"Please check the JOnAS server configuration.", new Object[0]);
        }
    }

    private void deployEasyBeans() throws Exception {
        if (!this.__MdeployEasyBeans) {
            this.__deployEasyBeans();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "deployEasyBeans", new Object[0]);
            this.__deployEasyBeans();
            this.__IM.onExit((Object)this, "deployEasyBeans", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "deployEasyBeans", throwable);
            throw throwable;
        }
    }

    private void __deployEasyBeans() throws Exception {
        Bundle[] bundles;
        String jpaProvider = (String)this.__getconfigurationManager().getServiceProperties("ejb3").get(JPA_PROVIDER);
        for (Bundle bundle : bundles = this.__getbundleContext().getBundles()) {
            String symbolicName = bundle.getSymbolicName();
            if (!symbolicName.startsWith(EASYBANS_PREFIX_SYMBOLIC_NAME) || symbolicName.endsWith(jpaProvider)) continue;
            bundle.uninstall();
        }
        this.__getdeploymentPlanDeployer().deploy("easybeans-".concat(jpaProvider));
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("deploymentPlanDeployer")) {
                this.__FdeploymentPlanDeployer = true;
            }
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("deployerManagerCallback")) {
                this.__FdeployerManagerCallback = true;
            }
            if (set.contains("serverProperties")) {
                this.__FserverProperties = true;
            }
            if (set.contains("deployerManager")) {
                this.__FdeployerManager = true;
            }
            if (set.contains("j2eeServer")) {
                this.__Fj2eeServer = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("configurationManager")) {
                this.__FconfigurationManager = true;
            }
            if (set.contains("serviceStates")) {
                this.__FserviceStates = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("addService$org_ow2_jonas_lib_service_manager_ServiceItem")) {
                this.__MaddService$org_ow2_jonas_lib_service_manager_ServiceItem = true;
            }
            if (set.contains("deleteAllServices")) {
                this.__MdeleteAllServices = true;
            }
            if (set.contains("getAllServices")) {
                this.__MgetAllServices = true;
            }
            if (set.contains("getOptionalServices")) {
                this.__MgetOptionalServices = true;
            }
            if (set.contains("setServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState")) {
                this.__MsetServiceState$java_lang_String$org_ow2_jonas_lib_management_javaee_J2EEServiceState = true;
            }
            if (set.contains("getServiceState$java_lang_String")) {
                this.__MgetServiceState$java_lang_String = true;
            }
            if (set.contains("getServiceDescription$java_lang_String")) {
                this.__MgetServiceDescription$java_lang_String = true;
            }
            if (set.contains("getNonRunningServices")) {
                this.__MgetNonRunningServices = true;
            }
            if (set.contains("allOptionalServicesStopped")) {
                this.__MallOptionalServicesStopped = true;
            }
            if (set.contains("checkServerState$java_lang_String")) {
                this.__McheckServerState$java_lang_String = true;
            }
            if (set.contains("startMonitoring")) {
                this.__MstartMonitoring = true;
            }
            if (set.contains("depMonitorRunning")) {
                this.__MdepMonitorRunning = true;
            }
            if (set.contains("depMonitorReference")) {
                this.__MdepMonitorReference = true;
            }
            if (set.contains("updateServiceStates")) {
                this.__MupdateServiceStates = true;
            }
            if (set.contains("startService$java_lang_String")) {
                this.__MstartService$java_lang_String = true;
            }
            if (set.contains("startRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MstartRequiredServices$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("stopService$java_lang_String")) {
                this.__MstopService$java_lang_String = true;
            }
            if (set.contains("startServices")) {
                this.__MstartServices = true;
            }
            if (set.contains("startServices$boolean")) {
                this.__MstartServices$boolean = true;
            }
            if (set.contains("stopServices")) {
                this.__MstopServices = true;
            }
            if (set.contains("createServiceItem$java_lang_String$boolean")) {
                this.__McreateServiceItem$java_lang_String$boolean = true;
            }
            if (set.contains("createServiceItem$java_lang_String$boolean$org_ow2_jonas_lib_management_javaee_J2EEServiceState")) {
                this.__McreateServiceItem$java_lang_String$boolean$org_ow2_jonas_lib_management_javaee_J2EEServiceState = true;
            }
            if (set.contains("bindJ2EEServer$org_ow2_jonas_management_J2EEServerService")) {
                this.__MbindJ2EEServer$org_ow2_jonas_management_J2EEServerService = true;
            }
            if (set.contains("unbindJ2EEServer$org_ow2_jonas_management_J2EEServerService")) {
                this.__MunbindJ2EEServer$org_ow2_jonas_management_J2EEServerService = true;
            }
            if (set.contains("setConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager")) {
                this.__MsetConfigurationManager$org_ow2_jonas_configuration_ConfigurationManager = true;
            }
            if (set.contains("setDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager")) {
                this.__MsetDeployerManager$org_ow2_util_ee_deploy_api_deployer_IDeployerManager = true;
            }
            if (set.contains("setDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer")) {
                this.__MsetDeploymentPlanDeployer$org_ow2_jonas_configuration_DeploymentPlanDeployer = true;
            }
            if (set.contains("setServerProperties$org_ow2_jonas_properties_ServerProperties")) {
                this.__MsetServerProperties$org_ow2_jonas_properties_ServerProperties = true;
            }
            if (set.contains("convertToList$java_lang_String")) {
                this.__MconvertToList$java_lang_String = true;
            }
            if (set.contains("reverseList$java_util_List")) {
                this.__MreverseList$java_util_List = true;
            }
            if (set.contains("checkServiceStates")) {
                this.__McheckServiceStates = true;
            }
            if (set.contains("deployEasyBeans")) {
                this.__MdeployEasyBeans = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

