/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2007-2008 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServiceItem.java 14329 2008-06-19 14:54:32Z fornacif $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.service.manager;

import java.io.Serializable;

import org.ow2.jonas.lib.management.javaee.J2EEServiceState;

/**
 * @author Adriana Danes
 */
public class ServiceItem implements Serializable {

    private static final long serialVersionUID = 1L;

    private String name;
    private J2EEServiceState state;
    private String description;
    private boolean mandatory;

    public ServiceItem() {

    }
    public String getName() {
        return name;
    }
    public void setName(final String name) {
        this.name = name;
    }
    public J2EEServiceState getState() {
        return state;
    }
    public void setState(final J2EEServiceState state) {
        this.state = state;
    }
    public String getDescription() {
        return description;
    }
    public void setDescription(final String description) {
        this.description = description;
    }
    public boolean isMandatory() {
        return mandatory;
    }
    public void setMandatory(final boolean mandatory) {
        this.mandatory = mandatory;
    }
}
