/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2007 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JTAResourceMBean.java 12246 2007-12-09 21:42:38Z benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.tm.jotm.mbean;

import javax.management.MBeanException;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

import org.apache.commons.modeler.BaseModelMBean;

/**
 * MBean class for JTA resource management.
 * @author Adriana Danes
 */

public class JTAResourceMBean extends BaseModelMBean {

    // -----------------------------  Contructors

    public JTAResourceMBean() throws MBeanException {
        super();
    }

    // ------------------------------- Public methods

    /**
     * Add a new listener.
     * @param pListener Listener to notify
     * @param pFilter Notification filter
     * @param pHandback handback object reference
     * @throws java.lang.IllegalArgumentException Listener parameter is null
     */
    public void addNotificationListener(NotificationListener pListener, NotificationFilter pFilter,
            java.lang.Object pHandback) throws java.lang.IllegalArgumentException {
        ((NotificationEmitter) (this.resource)).addNotificationListener(pListener, pFilter, pHandback);
    }
}