/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.tm.jotm;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.XATerminator;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionFactoryImpl;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.rmi.interceptor.spi.JInitializer;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.TransactionManager;
import org.ow2.jonas.tm.TransactionService;
import org.ow2.jonas.tm.jotm.JOTMTransactionManager;
import org.ow2.jonas.tm.jotm.jta.rmi.JTAInterceptorInitializer;
import org.ow2.jonas.tm.jotm.mbean.JTAResource;

public class JOTMTransactionService
extends AbsServiceImpl
implements TransactionService {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.server");
    private static final int DEFAULT_TIMEOUT = 60;
    private static final int TM_LOOKUP_WAIT_TIME = 2000;
    private static final String TRANSACTION_PROPAGATION = "jonas.transaction.propagation";
    private TransactionFactory tmFactory = null;
    private JOTMTransactionManager current = null;
    private int timeout = 60;
    private boolean jtmlocal;
    private InitialContext ictx;
    private JmxService jmxService = null;
    private RegistryService registryService;
    private ObjectName onJTAResource = null;
    private List<Class<? extends JInitializer>> jrmpInterceptors = null;

    public void setRemote(boolean remote) {
        this.jtmlocal = !remote;
    }

    public void doStart() throws ServiceException {
        logger.log(BasicLevel.DEBUG, (Object)"Starting JOTMTransaction Service");
        this.jrmpInterceptors = new ArrayList<Class<? extends JInitializer>>();
        try {
            boolean transaction = Boolean.parseBoolean(this.getServerProperties().getValue(TRANSACTION_PROPAGATION));
            if (transaction) {
                this.jrmpInterceptors.add(JTAInterceptorInitializer.class);
            }
            for (Class<? extends JInitializer> interceptor : this.jrmpInterceptors) {
                ConfigurationRepository.addInterceptors((String)"jrmp", interceptor);
            }
        }
        catch (ConfigurationException e) {
            throw new ServiceException("Cannot init JTA interceptor for Carol", (Throwable)e);
        }
        super.initLogger(Log.getLogger((String)"org.ow2.jonas.management"));
        if (this.jmxService != null) {
            this.jmxService.loadDescriptors(((Object)((Object)this)).getClass().getPackage().getName(), ((Object)((Object)this)).getClass().getClassLoader());
        }
        this.ictx = this.getRegistryService().getRegistryContext();
        if (this.jtmlocal) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"working with a colocated Transaction Manager ");
            }
            try {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Create and register TM factory");
                }
                this.tmFactory = new TransactionFactoryImpl();
                this.ictx.rebind("TMFactory", (Object)this.tmFactory);
            }
            catch (RemoteException e) {
                logger.log(BasicLevel.ERROR, (Object)("TransactionService: Cannot create TransactionFactory:\n" + e));
                throw new ServiceException("TransactionService: Cannot create TransactionFactory", (Throwable)e);
            }
            catch (NamingException e) {
                logger.log(BasicLevel.ERROR, (Object)("TransactionService: Cannot rebind TM:\n" + e));
                throw new ServiceException("TransactionService: Cannot rebind TM", (Throwable)e);
            }
        } else {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"working with a remote Transaction Manager ");
            }
            int maxloops = 5;
            for (int i = 0; i <= 5; ++i) {
                try {
                    IExecution<TransactionFactory> tmFactoryBuilder = new IExecution<TransactionFactory>(){

                        public TransactionFactory execute() throws Exception {
                            return (TransactionFactory)JOTMTransactionService.this.ictx.lookup("TMFactory");
                        }
                    };
                    ExecutionResult tmFactoryResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)tmFactoryBuilder);
                    if (tmFactoryResult.hasException()) {
                        throw new NamingException("TransactionService: Cannot get TM factory");
                    }
                    this.tmFactory = (TransactionFactory)tmFactoryResult.getResult();
                    break;
                }
                catch (NamingException e) {
                    if (i < 5) {
                        logger.log(BasicLevel.WARN, (Object)"Cannot get TM factory - retrying...");
                        try {
                            Thread.sleep(2000 * (i + 1));
                            continue;
                        }
                        catch (InterruptedException e2) {
                            throw new ServiceException("Cannot get TM factory", (Throwable)e2);
                        }
                    }
                    logger.log(BasicLevel.ERROR, (Object)("TransactionService: Cannot get TM factory:\n" + e));
                    throw new ServiceException("TransactionService: Cannot get TM factory", (Throwable)e);
                }
            }
        }
        int portNumber = 0;
        String hostName = null;
        try {
            portNumber = this.tmFactory.getPortNumber();
            hostName = this.tmFactory.getHostName();
        }
        catch (RemoteException e) {
            logger.log(BasicLevel.ERROR, (Object)("TransactionService: Cannot access TransactionFactorywhen trying to get configuration parameters:\n" + e));
            throw new ServiceException("TransactionService: Cannot access TransactionFactory", (Throwable)e);
        }
        this.current = new JOTMTransactionManager(this.tmFactory);
        this.setTimeout(this.timeout);
        try {
            this.jmxService.registerModelMBean((Object)this, JonasObjectName.transactionService((String)this.getDomainName()));
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot register TransactionService MBean", (Throwable)e);
        }
        String sJTAResourceName = "JTAResource";
        this.onJTAResource = J2eeObjectName.JTAResource((String)this.getDomainName(), (String)this.getJonasServerName(), (String)sJTAResourceName);
        JTAResource jtaResourceMBean = new JTAResource(this.onJTAResource.toString(), this, new Integer(this.timeout), new Boolean(this.jtmlocal), new Integer(portNumber), hostName);
        try {
            this.jmxService.registerModelMBean((Object)jtaResourceMBean, this.onJTAResource);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(BasicLevel.ERROR, (Object)"Cannot register JTAResource MBean", (Throwable)e);
        }
        logger.log(BasicLevel.INFO, (Object)("TransactionService started, default timeout= " + this.timeout));
    }

    public void doStop() throws ServiceException {
        if (this.jmxService != null) {
            this.jmxService.unregisterModelMBean(this.onJTAResource);
            this.jmxService.unregisterModelMBean(JonasObjectName.transactionService((String)this.getDomainName()));
        }
        try {
            for (Class<? extends JInitializer> interceptor : this.jrmpInterceptors) {
                ConfigurationRepository.removeInterceptors((String)"jrmp", interceptor);
            }
            this.jrmpInterceptors.clear();
        }
        catch (ConfigurationException e) {
            throw new ServiceException("Cannot remove security interceptors for Carol", (Throwable)e);
        }
        logger.log(BasicLevel.INFO, (Object)"TransactionService stopped");
    }

    public TransactionManager getTransactionManager() {
        return this.current;
    }

    public XATerminator getXATerminator() throws XAException {
        return this.current.getXATerminator();
    }

    public UserTransaction getUserTransaction() {
        return this.current;
    }

    public void startResourceManagerRecovery() throws XAException {
        Current.getTransactionRecovery().startResourceManagerRecovery();
    }

    public int getTimeout() {
        return this.current.getDefaultTimeout();
    }

    public void setTimeout(int t) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("" + t));
        }
        this.timeout = t;
        if (this.current != null) {
            this.current.setDefaultTimeout(t);
            if (this.jtmlocal) {
                try {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"Register UserTransactionFactory");
                    }
                    this.ictx.rebind("javax.transaction.UserTransaction", (Object)this.current);
                }
                catch (NamingException e) {
                    logger.log(BasicLevel.ERROR, (Object)("Cannot rebind UserTransaction:" + e));
                }
            }
        }
    }

    public int getTotalBegunTransactions() {
        return this.current.getTotalBegunTransactions();
    }

    public int getTotalCommittedTransactions() {
        return this.current.getTotalCommittedTransactions();
    }

    public int getTotalCurrentTransactions() {
        return this.current.getTotalCurrentTransactions();
    }

    public int getTotalExpiredTransactions() {
        return this.current.getTotalExpiredTransactions();
    }

    public int getTotalRolledbackTransactions() {
        return this.current.getTotalRolledbackTransactions();
    }

    public void resetAllTxTotalCounters() {
        this.current.resetAllTxTotalCounters();
    }

    public Xid[] getAllActiveXids() {
        return this.current.getAllXid();
    }

    public String[] getAllActiveTx() {
        String[] mysArray = this.current.getAllTx();
        return mysArray;
    }

    public String[] getAllRecoveryTx() {
        String[] mysArray = this.current.getAllRcTx();
        return mysArray;
    }

    public String[] getAllXAResource(String xtx) {
        String[] mysArray = this.current.getAllXaTx(xtx);
        return mysArray;
    }

    public int commitXAResource(String xatx) {
        int commiterror = this.current.actionXAResource("commit", xatx);
        return commiterror;
    }

    public int rollbackXAResource(String xatx) {
        int rollbackerror = this.current.actionXAResource("rollback", xatx);
        return rollbackerror;
    }

    public int forgetXAResource(String xatx) {
        int forgeterror = this.current.actionXAResource("forget", xatx);
        return forgeterror;
    }

    public void attachTransaction(Xid xid, long timeout) throws NotSupportedException, SystemException {
        this.current.begin(xid, timeout);
    }

    public void detachTransaction() {
        this.current.clearThreadTx();
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setRegistryService(RegistryService registry) {
        this.registryService = registry;
    }

    private RegistryService getRegistryService() {
        return this.registryService;
    }
}

