/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.NamingException;
import org.apache.AnnotationProcessor;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.DefaultAnnotationProcessor;
import org.apache.catalina.util.ServerInfo;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.asm.ClassReader;
import org.ow2.jonas.asm.ClassVisitor;
import org.ow2.jonas.asm.ClassWriter;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.BaseWebContainerService;
import org.ow2.jonas.web.base.lib.PermissionManager;
import org.ow2.jonas.web.tomcat6.JCatalinaRuleSet;
import org.ow2.jonas.web.tomcat6.JOnASContextConfig;
import org.ow2.jonas.web.tomcat6.JOnASStandardContext;
import org.ow2.jonas.web.tomcat6.ResetAuthenticationValve;
import org.ow2.jonas.web.tomcat6.security.Realm;
import org.ow2.jonas.web.tomcat6.versioning.ConnectorTransformer;
import org.ow2.jonas.web.tomcat6.versioning.ContextFinder;
import org.ow2.jonas.web.tomcat6.versioning.CoyoteAdapterTransformer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tomcat6Service
extends BaseWebContainerService
implements JWebContainerService {
    private static Log logger = LogFactory.getLog(Tomcat6Service.class);
    protected static final String CONFIG_FILE = "conf" + File.separator + "tomcat6-server.xml";
    public static final String CONNECTOR_CLASS_NAME = "org.apache.catalina.connector.Connector";
    public static final String COYOTE_ADAPTER_CLASS_NAME = "org.apache.catalina.connector.CoyoteAdapter";
    private static boolean tomcatTransformed = false;
    private Server server = null;
    private ClassLoader externalLoader = null;
    private boolean tomcatStarted = false;
    private SecurityService securityService = null;

    protected void initCatalinaEnvironment() throws ServiceException {
        String jonasRoot = System.getProperty("jonas.root");
        String jonasBase = System.getProperty("jonas.base");
        String catalinaHome = System.getProperty("catalina.home");
        String catalinaBase = System.getProperty("catalina.base");
        if (catalinaHome != null && !jonasRoot.equals(catalinaHome)) {
            logger.warn((Object)"The CATALINA_HOME property was set to ''{0}'', fix it by using JONAS_ROOT ''{1}''", new Object[]{catalinaHome, jonasRoot});
        }
        System.setProperty("catalina.home", jonasRoot);
        if (catalinaBase != null && !jonasBase.equals(catalinaBase)) {
            logger.warn((Object)"The CATALINA_BASE property was set to ''{0}'', fix it by using JONAS_BASE ''{1}''", new Object[]{catalinaBase, jonasBase});
        }
        System.setProperty("catalina.base", jonasBase);
        System.setProperty("catalina.useNaming", "false");
    }

    public void doStart() throws ServiceException {
        this.initCatalinaEnvironment();
        LoaderManager lm = LoaderManager.getInstance();
        try {
            this.externalLoader = lm.getExternalLoader();
        }
        catch (Exception e1) {
            throw new ServiceException("Cannot get Application/Tomcat ClassLoader", (Throwable)e1);
        }
        ContextFinder.setParent(this);
        ContextFinder.setJmxService(this.jmxService);
        if (!tomcatTransformed) {
            this.transformCoyoteAdaptor();
            this.transformConnector();
            tomcatTransformed = true;
        }
        Digester digester = this.createServerDigester();
        File configFile = null;
        try {
            configFile = this.getConfigFile();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Cannot find the file ''{0}''", new Object[]{CONFIG_FILE, e});
            throw new ServiceException("Cannot find the configuration file", (Throwable)e);
        }
        try {
            InputSource is = new InputSource("file://" + configFile.getAbsolutePath());
            FileInputStream fis = new FileInputStream(configFile);
            is.setByteStream(fis);
            digester.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            digester.push((Object)this);
            digester.parse(is);
            fis.close();
        }
        catch (Exception e) {
            logger.error((Object)"Cannot parse the configuration file ''{0}''", new Object[]{configFile, e});
            throw new ServiceException("Cannot parse the configuration file '" + configFile + "'", (Throwable)e);
        }
        for (StandardEngine engine : this.getEngines()) {
            engine.setDomain(this.getDomainName());
            engine.setName(this.getDomainName());
        }
        IExecution<Void> startExec = new IExecution<Void>(){

            public Void execute() throws ServiceException {
                if (Tomcat6Service.this.server instanceof Lifecycle) {
                    try {
                        Tomcat6Service.this.server.initialize();
                        ((Lifecycle)Tomcat6Service.this.server).start();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Cannot start the Tomcat server", new Object[]{e});
                        throw new ServiceException("Cannot start the Tomcat server", (Throwable)e);
                    }
                }
                return null;
            }
        };
        ExecutionResult startExecResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)startExec);
        if (startExecResult.hasException()) {
            logger.error((Object)"Cannot start the Tomcat server", new Object[]{startExecResult.getException()});
            throw new ServiceException("Cannot start the Tomcat Server", (Throwable)startExecResult.getException());
        }
        this.tomcatStarted = true;
        super.doStart();
    }

    protected void doStop() throws ServiceException {
        super.doStop();
        if (this.server instanceof Lifecycle) {
            try {
                ((Lifecycle)this.server).stop();
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void doRegisterWar(javax.naming.Context ctx) throws JWebContainerServiceException {
        URL warURL = null;
        URL earURL = null;
        URL unpackedWarURL = null;
        String contextRoot = null;
        boolean java2DelegationModel = true;
        PermissionManager permissionManager = null;
        boolean inEarCase = true;
        String earAppName = null;
        String jonasDD = null;
        String userURI = null;
        try {
            warURL = (URL)ctx.lookup("warURL");
            unpackedWarURL = (URL)ctx.lookup("unpackedWarURL");
            contextRoot = (String)ctx.lookup("contextRoot");
            Boolean bool = (Boolean)ctx.lookup("java2DelegationModel");
            java2DelegationModel = bool;
            jonasDD = (String)ctx.lookup("jonasDD");
            permissionManager = (PermissionManager)ctx.lookup("permissionManager");
            userURI = (String)ctx.lookup("userURI");
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to get default parameters", new Object[]{e});
            throw new JWebContainerServiceException("Unable to get default parameters", (Throwable)e);
        }
        try {
            earAppName = (String)ctx.lookup("earAppName");
            earURL = (URL)ctx.lookup("earURL");
        }
        catch (NamingException e) {
            inEarCase = false;
            earURL = warURL;
        }
        ClassLoader webClassLoader = null;
        try {
            webClassLoader = (ClassLoader)ctx.lookup("parentCL");
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to get parentCL parameter", new Object[]{e});
            throw new JWebContainerServiceException("Unable to get parentCL parameter", (Throwable)e);
        }
        String hostName = null;
        try {
            hostName = (String)ctx.lookup("hostName");
        }
        catch (NamingException e) {
            hostName = "";
        }
        contextRoot = contextRoot.equals("/") ? "" : "/" + contextRoot;
        File fWar = new File(warURL.getFile());
        String destDir = null;
        destDir = fWar.isDirectory() ? warURL.getFile() : unpackedWarURL.getFile();
        File contextXmlFile = new File(destDir + File.separator + "META-INF" + File.separator + "context.xml");
        List<JOnASStandardContext> jonasContexts = this.getConfiguredMatchingJonasContexts(contextRoot, fWar, destDir);
        Host deployer = null;
        if (jonasContexts.isEmpty()) {
            deployer = this.findHost(hostName);
            JOnASStandardContext context = new JOnASStandardContext(false, java2DelegationModel, inEarCase);
            context.setDocBase(destDir);
            context.setPath(contextRoot);
            JOnASContextConfig config = new JOnASContextConfig();
            config.setSecurityService(this.securityService);
            context.addLifecycleListener((LifecycleListener)config);
            jonasContexts.add(context);
        }
        for (JOnASStandardContext jStdCtx : jonasContexts) {
            jStdCtx.setTomcatService(this);
            jStdCtx.setParentClassLoader(webClassLoader);
            jStdCtx.setDelegate(java2DelegationModel);
            if (Tomcat6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                Tomcat6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Webapp class loader java 2 delegation model set to " + java2DelegationModel));
            }
            jStdCtx.addValve((Valve)new ResetAuthenticationValve());
            if (contextXmlFile.exists()) {
                jStdCtx.setConfigFile(contextXmlFile.getAbsolutePath());
            }
            javax.naming.Context envCtx = null;
            try {
                envCtx = (javax.naming.Context)this.getNaming().getComponentContext(webClassLoader).lookup("comp/env");
            }
            catch (NamingException e) {
                Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)("Cannot get the context of the webapplication '" + warURL + "'."), (Throwable)e);
            }
            jStdCtx.setAnnotationProcessor((AnnotationProcessor)new DefaultAnnotationProcessor(envCtx));
            jStdCtx.setJ2EEServer(this.getJonasServerName());
            jStdCtx.setServer(J2eeObjectName.J2EEServer((String)this.getDomainName(), (String)this.getJonasServerName()).toString());
            MBeanServer mbeanServer = this.jmxService.getJmxServer();
            ObjectName j2eeServerOn = J2eeObjectName.J2EEServer((String)this.getDomainName(), (String)this.getJonasServerName());
            try {
                String[] as = (String[])mbeanServer.getAttribute(j2eeServerOn, "javaVMs");
                jStdCtx.setJavaVMs(as);
            }
            catch (Exception e) {
                Tomcat6Service.getLogger().log(BasicLevel.WARN, (Object)("Set MBean JVM error : " + e.getClass().getName() + " " + e.getMessage()));
            }
            if (earAppName != null) {
                jStdCtx.setJ2EEApplication(earAppName);
            }
            jStdCtx.setJonasDeploymentDescriptor(jonasDD);
            org.apache.catalina.Realm ctxRealm = jStdCtx.getRealm();
            if (ctxRealm == null) {
                ctxRealm = deployer.getRealm();
            }
            if (ctxRealm != null && ctxRealm instanceof Realm) {
                Realm jaccRealm = null;
                try {
                    jaccRealm = (Realm)((Realm)ctxRealm).clone();
                }
                catch (CloneNotSupportedException cnse) {
                    String err = "Cannot clone the realm used by the existing context or its parent realm";
                    Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + cnse.getMessage()));
                    throw new JWebContainerServiceException(err, (Throwable)cnse);
                }
                if (Tomcat6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Tomcat6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Setting permission manager to " + permissionManager));
                }
                jaccRealm.setPermissionManager(permissionManager);
                jaccRealm.setSecurityService(this.securityService);
                jaccRealm.setContext((Context)jStdCtx);
                jStdCtx.setRealm((org.apache.catalina.Realm)jaccRealm);
            }
            jStdCtx.setWarURL(warURL);
            if (inEarCase) {
                jStdCtx.setEarURL(earURL);
            }
            if (jStdCtx.isInServerXml()) {
                try {
                    jStdCtx.setLoader(null);
                    jStdCtx.start();
                }
                catch (LifecycleException lce) {
                    logger.error((Object)("Cannot start the context '" + (Object)((Object)jStdCtx) + "'."), new Object[]{lce});
                    throw new JWebContainerServiceException("Cannot start the context '" + (Object)((Object)jStdCtx) + "'.", (Throwable)lce);
                }
            } else {
                if (deployer == null) {
                    logger.error((Object)("No deployer found for the deployment of the context '" + (Object)((Object)jStdCtx) + "'."), new Object[0]);
                    throw new JWebContainerServiceException("No deployer found for the deployment of the context '" + (Object)((Object)jStdCtx) + "'.");
                }
                deployer.addChild((Container)jStdCtx);
            }
            this.checkStartedContext((Context)jStdCtx, permissionManager);
            try {
                ctx.rebind("WebModule", (Object)jStdCtx.createObjectName(this.getDomainName(), jStdCtx.getParentName()));
            }
            catch (Exception e) {
                String err = "Cannot rebind WebModule ObjectName in Context";
                logger.error((Object)err, new Object[]{e});
                throw new JWebContainerServiceException(err, (Throwable)e);
            }
            try {
                if (!this.isVersioningEnabled() || contextRoot.length() <= 0 || userURI.length() <= 0) continue;
                if (contextRoot.charAt(0) != '/') {
                    contextRoot = '/' + contextRoot;
                }
                if (userURI.charAt(0) != '/') {
                    userURI = '/' + userURI;
                }
                if (contextRoot.equals(userURI)) continue;
                logger.info((Object)("Deploying versioned application " + userURI + ", path for the added version is " + contextRoot), new Object[0]);
                String policy = this.getVersioningService().getDefaultPolicy();
                ContextFinder.bindContextRoot(userURI, (Context)jStdCtx, policy);
            }
            catch (Exception e) {
                throw new JWebContainerServiceException("Failed binding web context", (Throwable)e);
            }
        }
    }

    protected List<JOnASStandardContext> getConfiguredMatchingJonasContexts(String contextRoot, File fpackedWar, String destDir) {
        ArrayList<JOnASStandardContext> jonasContexts = new ArrayList<JOnASStandardContext>();
        for (Context ctx : this.getContexts()) {
            String serverCtxRoot;
            JOnASStandardContext jStdCtx;
            if (!(ctx instanceof JOnASStandardContext) || (jStdCtx = (JOnASStandardContext)ctx) == null || !jStdCtx.isInServerXml() || !(serverCtxRoot = jStdCtx.getPath()).equals(contextRoot)) continue;
            if (jStdCtx.getPrivileged()) {
                if (fpackedWar.isDirectory()) {
                    logger.error((Object)("Can deploy a privileged context '" + (Object)((Object)jStdCtx) + "' only if it's a war file (and not a directory)"), new Object[0]);
                }
                jStdCtx.setDocBase(fpackedWar.getPath());
            } else {
                jStdCtx.setDocBase(destDir);
            }
            jonasContexts.add(jStdCtx);
        }
        return jonasContexts;
    }

    protected void checkStartedContext(Context context, PermissionManager permissionManager) throws JWebContainerServiceException {
        Realm jaccRealm;
        PermissionManager ctxPerm;
        if (!context.getConfigured()) {
            throw new JWebContainerServiceException("Context '" + context + "' was not configured");
        }
        org.apache.catalina.Realm ctxRealm = context.getRealm();
        if (ctxRealm != null && ctxRealm instanceof Realm && (ctxPerm = (jaccRealm = (Realm)ctxRealm).getPermissionManager()) == null && permissionManager != null) {
            jaccRealm.setPermissionManager(permissionManager);
            jaccRealm.setContext(context);
        }
        if (Tomcat6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Tomcat6Service.getLogger().log(BasicLevel.DEBUG, (Object)("context " + context + " started"));
        }
    }

    protected synchronized List<StandardEngine> getEngines() throws JWebContainerServiceException {
        ArrayList<StandardEngine> engines = new ArrayList<StandardEngine>();
        Service[] services = this.server.findServices();
        for (int s = 0; s < services.length; ++s) {
            Container cont = services[s].getContainer();
            if (!(cont instanceof StandardEngine)) {
                String err = "The container of the service must be an engine (server.xml)";
                throw new JWebContainerServiceException(err);
            }
            engines.add((StandardEngine)cont);
        }
        return engines;
    }

    protected synchronized List<Context> getContexts() throws JWebContainerServiceException {
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (StandardEngine engine : this.getEngines()) {
            Container[] hosts = engine.findChildren();
            for (int j = 0; j < hosts.length; ++j) {
                Container[] containers = hosts[j].findChildren();
                for (int k = 0; k < containers.length; ++k) {
                    Container container = containers[k];
                    if (!(container instanceof Context)) continue;
                    contexts.add((Context)container);
                }
            }
        }
        return contexts;
    }

    protected void doUnRegisterWar(javax.naming.Context ctx) throws JWebContainerServiceException {
        String contextRoot = null;
        try {
            contextRoot = (String)ctx.lookup("contextRoot");
        }
        catch (NamingException e) {
            throw new JWebContainerServiceException("Unable to find the contextRoot parameter", (Throwable)e);
        }
        contextRoot = contextRoot.equals("/") ? "" : "/" + contextRoot;
        String hostName = null;
        try {
            hostName = (String)ctx.lookup("hostName");
        }
        catch (NamingException e) {
            logger.debug((Object)"No hostname was defined for this context", new Object[0]);
        }
        if (hostName == null) {
            boolean found = false;
            for (Context context : this.getContexts()) {
                String serverCtxRoot = context.getPath();
                if (!serverCtxRoot.equals(contextRoot)) continue;
                this.removeContext(context);
                found = true;
                break;
            }
            if (!found) {
                throw new JWebContainerServiceException("Unable to remove a context with the context name '" + contextRoot + "'.");
            }
        } else {
            Host host = this.findHost(hostName);
            Context context = host.map(contextRoot);
            if (context != null) {
                this.removeContext(context);
            } else {
                throw new JWebContainerServiceException("Unable to find a context for the given hostname '" + hostName + "'.");
            }
        }
        try {
            if (this.isVersioningEnabled() && contextRoot.length() > 0) {
                if (contextRoot.charAt(0) != '/') {
                    contextRoot = '/' + contextRoot;
                }
                if (ContextFinder.unbindContextRoot(contextRoot)) {
                    logger.info((Object)("Undeployed version " + contextRoot), new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new JWebContainerServiceException("Failed binding web context", (Throwable)e);
        }
    }

    public synchronized void removeContext(Context context) throws JWebContainerServiceException {
        boolean found = false;
        Iterator<Context> it = this.getContexts().iterator();
        while (it.hasNext() && !found) {
            if (context != it.next()) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        if (context instanceof JOnASStandardContext) {
            JOnASStandardContext jctx = (JOnASStandardContext)context;
            if (jctx.isInServerXml()) {
                try {
                    ((JOnASStandardContext)context).stop();
                }
                catch (LifecycleException le) {
                    throw new JWebContainerServiceException("Cannot stop context (" + le.getMessage() + ")");
                }
            } else {
                context.getParent().removeChild((Container)context);
                try {
                    this.jmxService.getJmxServer().unregisterMBean(jctx.getJmxName());
                }
                catch (Exception e) {
                    Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)("Cannot remove the MBean for the WebModule " + jctx.getObjectName() + " : " + e.getMessage()));
                }
            }
        } else {
            context.getParent().removeChild((Container)context);
            if (context instanceof StandardContext) {
                StandardContext ctx = (StandardContext)context;
                try {
                    this.jmxService.getJmxServer().unregisterMBean(ctx.getJmxName());
                }
                catch (Exception e) {
                    Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)("Cannot remove the MBean for the WebModule " + ctx.getObjectName() + " : " + e.getMessage()));
                }
            }
        }
    }

    public boolean isTomcatStarted() {
        return this.tomcatStarted;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    protected File getConfigFile() throws FileNotFoundException {
        String fileName = System.getProperty("catalina.base");
        File file = new File(fileName = fileName + File.separator + CONFIG_FILE);
        if (!file.exists()) {
            throw new FileNotFoundException("The configuration file '" + fileName + "' does not exists.");
        }
        return file;
    }

    public Host findHost(String hostName) throws JWebContainerServiceException {
        Service[] services = this.server.findServices();
        if (services.length < 1) {
            String err = "At least one service must be define in the server.xml of Tomcat";
            throw new JWebContainerServiceException(err);
        }
        if (hostName == null || hostName.equals("")) {
            Service service = services[0];
            Container cont = service.getContainer();
            if (!(cont instanceof Engine)) {
                String err = "The container of the service must be an engine";
                throw new JWebContainerServiceException(err);
            }
            Engine engine = (Engine)cont;
            String defaultHost = engine.getDefaultHost();
            if (defaultHost == null) {
                String err = "Default host must be specified in server.xml or host must be specified in jonas-web.xml";
                throw new JWebContainerServiceException(err);
            }
            Container child = engine.findChild(defaultHost);
            if (child instanceof Host) {
                return (Host)child;
            }
            String err = "Default host " + defaultHost + " not found";
            throw new JWebContainerServiceException(err);
        }
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (int s = 0; s < services.length; ++s) {
            Container cont = services[s].getContainer();
            if (!(cont instanceof Engine)) {
                String err = "The container of a service must be an engine";
                throw new JWebContainerServiceException(err);
            }
            Engine engine = (Engine)cont;
            Container child = engine.findChild(hostName);
            if (!(child instanceof Host)) continue;
            hosts.add((Host)child);
        }
        if (hosts.size() == 0) {
            String err = "Host " + hostName + " not found in all services/Engine of server.xml";
            throw new JWebContainerServiceException(err);
        }
        return (Host)hosts.get(0);
    }

    protected Digester createServerDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addRuleSet((RuleSet)new JCatalinaRuleSet(this.externalLoader, this.securityService));
        digester.setUseContextClassLoader(true);
        return digester;
    }

    protected void updateServerInfos() {
        String infos = ServerInfo.getServerInfo();
        StringTokenizer st = new StringTokenizer(infos, "/");
        if (st.countTokens() != 2) {
            this.setServerName(infos);
            this.setServerVersion("");
        } else {
            this.setServerName(st.nextToken());
            this.setServerVersion(st.nextToken());
        }
    }

    public String getDefaultHost() throws JWebContainerServiceException {
        Engine engine = (Engine)this.getFirstService().getContainer();
        return engine.getDefaultHost();
    }

    public String getDefaultHttpPort() throws JWebContainerServiceException {
        return String.valueOf(this.getPort("http"));
    }

    public String getDefaultHttpsPort() throws JWebContainerServiceException {
        return String.valueOf(this.getPort("https"));
    }

    protected int getPort(String scheme) throws JWebContainerServiceException {
        Service svc = this.getFirstService();
        ArrayList<Connector> conn = new ArrayList<Connector>();
        for (Connector c : svc.findConnectors()) {
            if (!c.getScheme().equalsIgnoreCase(scheme)) continue;
            conn.add(c);
        }
        if (conn.isEmpty()) {
            throw new JWebContainerServiceException("No Connectors found for scheme '" + scheme + "' in " + CONFIG_FILE);
        }
        Connector c = (Connector)conn.get(0);
        if (conn.size() > 1 && Tomcat6Service.getLogger().isLoggable(BasicLevel.WARN)) {
            Tomcat6Service.getLogger().log(BasicLevel.WARN, (Object)("Found multiple Connectors for scheme '" + scheme + "' in " + CONFIG_FILE + ", using first by default! (port:" + c.getPort() + ")"));
        }
        return c.getPort();
    }

    protected Service getFirstService() {
        Service[] svc = this.server.findServices();
        if (svc == null || svc.length == 0) {
            throw new JWebContainerServiceException("No Services found in " + CONFIG_FILE);
        }
        if (svc.length > 1 && Tomcat6Service.getLogger().isLoggable(BasicLevel.WARN)) {
            Tomcat6Service.getLogger().log(BasicLevel.WARN, (Object)("Found multiple Services in " + CONFIG_FILE + ", using first by default!"));
        }
        return svc[0];
    }

    public void registerWar(String fileName) throws RemoteException, JWebContainerServiceException {
        ClassLoader old = null;
        try {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.externalLoader);
            super.registerWar(fileName);
        }
        catch (Exception e) {
            throw new ServiceException("Exception during registering war", (Throwable)e);
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public void unRegisterWar(String fileName) throws RemoteException, JWebContainerServiceException {
        ClassLoader old = null;
        try {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.externalLoader);
            super.unRegisterWar(fileName);
        }
        catch (Exception e) {
            throw new ServiceException("Exception during unregistering war", (Throwable)e);
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected void transformConnector() throws ServiceException {
        this.transformClass(CONNECTOR_CLASS_NAME, ConnectorTransformer.class);
    }

    protected void transformCoyoteAdaptor() throws ServiceException {
        this.transformClass(COYOTE_ADAPTER_CLASS_NAME, CoyoteAdapterTransformer.class);
    }

    protected void transformClass(String from, Class to) throws ServiceException {
        String resource = from.replace('.', '/').concat(".class");
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(resource);
        if (null == inputStream) {
            throw new ServiceException("Cannot open stream to resource " + resource);
        }
        byte[] originalClass = null;
        try {
            originalClass = new byte[inputStream.available()];
            inputStream.read(originalClass);
        }
        catch (IOException e) {
            throw new ServiceException("Cannot read resource " + resource, (Throwable)e);
        }
        ClassReader cr = new ClassReader(originalClass);
        ClassWriter cw = new ClassWriter(cr, 0);
        try {
            Constructor co = to.getConstructor(ClassVisitor.class);
            ClassVisitor cv = (ClassVisitor)co.newInstance(cw);
            cr.accept(cv, 0);
        }
        catch (Exception e) {
            throw new ServiceException("Cannot get ClassVisitor constructor : " + to, (Throwable)e);
        }
        byte[] modifiedClass = cw.toByteArray();
        try {
            Method defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            Object[] args = new Object[]{from, modifiedClass, 0, modifiedClass.length};
            defineClassMethod.setAccessible(true);
            defineClassMethod.invoke((Object)classLoader, args);
        }
        catch (Exception e) {
            throw new ServiceException("Cannot inject bytecode for class " + from, (Throwable)e);
        }
        logger.debug((Object)("transformClass for class " + from + " into " + to + " OK."), new Object[0]);
    }
}

