/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.versioning;

import java.net.MalformedURLException;
import java.net.URL;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.web.tomcat6.versioning.ContextFinder;
import org.ow2.jonas.web.tomcat6.versioning.VirtualContextMBean;

public abstract class AbsVirtualContext
implements VirtualContextMBean {
    private static Log logger = LogFactory.getLog(AbsVirtualContext.class);
    protected Context defaultContext = null;
    protected String userURI;
    private String mBeanName;
    private JmxService jmxService = null;

    public AbsVirtualContext(JmxService jmxService, String userURI, Context contextInstance) {
        this.userURI = userURI;
        this.addContext(contextInstance, "Default");
        Host host = (Host)contextInstance.getParent();
        this.mBeanName = jmxService.getDomainName() + ":j2eeType=WebModule,name=//" + host.getName() + userURI + ",J2EEApplication=none,J2EEServer=" + jmxService.getJonasServerName() + ",virtualContext=true";
        logger.debug((Object)("New VirtualContext: registering MBean with name : " + this.mBeanName));
        jmxService.registerMBean((Object)this, this.mBeanName);
        this.jmxService = jmxService;
    }

    protected abstract void addContextInternal(Context var1, String var2) throws IllegalArgumentException;

    protected Context findContextObject(String versionedPath) {
        if (this.defaultContext != null && versionedPath.equals(this.defaultContext.getPath())) {
            return this.defaultContext;
        }
        return null;
    }

    public void addContext(Context contextInstance, String policy) throws IllegalArgumentException {
        if (this.findContextObject(contextInstance.getPath()) != null) {
            throw new IllegalArgumentException("Context " + contextInstance + " already bound!");
        }
        if ("Default".equals(policy)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Addind default context " + contextInstance.getPath() + " for userURI " + this.userURI));
            }
            if (null != this.defaultContext) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting default context " + this.defaultContext.getPath() + " as disabled"));
                }
                this.addContextInternal(this.defaultContext, "Disabled");
            }
            this.defaultContext = contextInstance;
        } else {
            this.addContextInternal(contextInstance, policy);
        }
    }

    public boolean removeVirtualContext() {
        try {
            this.jmxService.unregisterMBean(ObjectName.getInstance(this.mBeanName));
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)("Error unbinding VirtualContext for URI " + this.userURI + ", MBean name " + this.mBeanName), (Throwable)e);
            return false;
        }
        return ContextFinder.unbindVirtualContext(this.userURI);
    }

    public boolean removeContext(String versionedPath) {
        if (this.defaultContext != null && versionedPath.equals(this.defaultContext.getPath())) {
            this.defaultContext = null;
            return true;
        }
        return false;
    }

    public boolean hasContext(String versionedPath) {
        return this.defaultContext != null && versionedPath.equals(this.defaultContext.getPath());
    }

    public String getMBeanName() {
        return this.mBeanName;
    }

    public Context findMappingObject() {
        return null;
    }

    public DirContext findStaticResources() {
        return null;
    }

    public String[] getwelcomeFiles() {
        return new String[0];
    }

    public URL getwarURL() {
        try {
            return new URL("file:///dev/null/VirtualWebContainer-" + this.userURI);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot create URL", e);
        }
    }
}

