/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.apache.jk.config.WebXml2Jk;
import org.w3c.dom.Node;

public class GeneratorApache2
implements WebXml2Jk.MappingGenerator {
    WebXml2Jk wxml;
    String vhost;
    String cpath;
    String worker;
    PrintWriter out;

    public void setWebXmlReader(WebXml2Jk wxml) {
        this.wxml = wxml;
        this.vhost = wxml.vhost;
        this.cpath = wxml.cpath;
        this.worker = wxml.worker;
    }

    public void generateStart() throws IOException {
        File base = this.wxml.getJkDir();
        File outF = new File(base, "jk2.conf");
        this.out = new PrintWriter(new FileWriter(outF));
        this.out.println("# Must be included in a virtual host context for " + this.vhost);
        this.out.println("Alias " + this.cpath + " \"" + this.wxml.docBase + "\"");
        this.out.println("<Directory \"" + this.wxml.docBase + "\" >");
        this.out.println("  Options Indexes FollowSymLinks");
        this.generateMimeMapping(this.out);
        this.generateWelcomeFiles(this.out);
        this.out.println("  AddHandler jakarta-servlet2 .jsp");
        this.out.println("</Directory>");
        this.out.println();
        this.out.println("<Location \"" + this.cpath + "/WEB-INF\" >");
        this.out.println("  AllowOverride None");
        this.out.println("  Deny from all");
        this.out.println("</Location>");
        this.out.println();
        this.out.println("<Location \"" + this.cpath + "/META-INF\" >");
        this.out.println("  AllowOverride None");
        this.out.println("  Deny from all");
        this.out.println("</Location>");
        this.out.println();
    }

    private void generateWelcomeFiles(PrintWriter out) {
        Vector wf = this.wxml.getWellcomeFiles();
        out.print("  DirectoryIndex ");
        for (int i = 0; i < wf.size(); ++i) {
            out.print(" " + (String)wf.elementAt(i));
        }
        out.println();
    }

    private void generateMimeMapping(PrintWriter out) {
        Node webN = this.wxml.getWebXmlNode();
        Node mapN = WebXml2Jk.getChild(webN, "mime-mapping");
        while (mapN != null) {
            String ext = WebXml2Jk.getChildContent(mapN, "extension");
            String type = WebXml2Jk.getChildContent(mapN, "mime-type");
            out.println("  AddType " + type + " " + ext);
            mapN = WebXml2Jk.getNext(mapN);
        }
    }

    public void generateEnd() {
        this.out.close();
    }

    public void generateServletMapping(String servlet, String url) {
        this.out.println("<Location \"" + this.cpath + url + "\" >");
        this.out.println("  SetHandler jakarta-servlet2");
        this.out.println("  JkUriSet group " + this.worker);
        this.out.println("  JkUriSet servlet " + servlet);
        this.out.println("  JkUriSet host " + this.vhost);
        this.out.println("  JkUriSet context " + this.cpath);
        this.out.println("</Location>");
        this.out.println();
    }

    public void generateFilterMapping(String servlet, String url) {
        this.out.println("<Location \"" + this.cpath + url + "\" >");
        this.out.println("  SetHandler jakarta-servlet2");
        this.out.println("  JkUriSet group " + this.worker);
        this.out.println("  JkUriSet servlet " + servlet);
        this.out.println("  JkUriSet host " + this.vhost);
        this.out.println("  JkUriSet context " + this.cpath);
        this.out.println("</Location>");
        this.out.println();
    }

    public void generateLoginConfig(String loginPage, String errPage, String authM) {
        this.out.println("<Location \"" + this.cpath + loginPage + "\" >");
        this.out.println("  SetHandler jakarta-servlet2");
        this.out.println("  JkUriSet group " + this.worker);
        this.out.println("  JkUriSet host " + this.vhost);
        this.out.println("  JkUriSet context " + this.cpath);
        this.out.println("</Location>");
        this.out.println();
    }

    public void generateErrorPage(int err, String location) {
    }

    public void generateConstraints(Vector urls, Vector methods, Vector roles, boolean isSSL) {
        for (int i = 0; i < urls.size(); ++i) {
            int j;
            String url = (String)urls.elementAt(i);
            this.out.println("<Location \"" + this.cpath + url + "\" >");
            if (methods.size() > 0) {
                this.out.print("  <Limit ");
                for (j = 0; j < methods.size(); ++j) {
                    String m = (String)methods.elementAt(j);
                    this.out.print(" " + m);
                }
                this.out.println(" >");
            }
            this.out.println("    AuthType basic");
            this.out.print("    Require group ");
            for (j = 0; j < roles.size(); ++j) {
                String role = (String)roles.elementAt(j);
                this.out.print(" " + role);
            }
            this.out.println();
            if (methods.size() > 0) {
                this.out.println("  </Limit>");
            }
            this.out.println("</Location>");
        }
    }
}

