/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.ws;

import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.ow2.jonas.ws.jaxws.PortMetaData;

public class URLUtils {
    static String getEndpointURL(PortMetaData portMetadata, Host host) {
        int proxyPort;
        int port;
        String hostname = host.getName();
        String pattern = portMetadata.getUrlPattern();
        Engine engine = (Engine)host.getParent();
        Service service = engine.getService();
        Connector[] connectors = service.findConnectors();
        Connector httpConnector = null;
        Connector httpsConnector = null;
        for (Connector connector : connectors) {
            String scheme = connector.getScheme();
            if ("https".equals(scheme)) {
                httpsConnector = connector;
            }
            if (!"http".equals(scheme)) continue;
            httpConnector = connector;
        }
        StringBuffer sb = new StringBuffer();
        if (httpConnector != null) {
            sb.append("http://");
            sb.append(hostname);
            sb.append(":");
            port = httpConnector.getPort();
            proxyPort = httpConnector.getProxyPort();
            if (proxyPort != 0) {
                port = proxyPort;
            }
            sb.append(port);
            sb.append(URLUtils.getContextRoot(portMetadata));
            sb.append(pattern);
            return sb.toString();
        }
        if (httpsConnector != null) {
            sb.append("https://");
            sb.append(hostname);
            sb.append(":");
            port = httpsConnector.getPort();
            proxyPort = httpsConnector.getProxyPort();
            if (proxyPort != 0) {
                port = proxyPort;
            }
            sb.append(port);
            sb.append(URLUtils.getContextRoot(portMetadata));
            sb.append(pattern);
            return sb.toString();
        }
        return null;
    }

    protected static String getContextRoot(PortMetaData portMetadata) {
        String contextName = portMetadata.getContextRoot();
        if (!contextName.startsWith("/")) {
            contextName = "/" + contextName;
        }
        return contextName;
    }

    public static String findValidUrlPattern(String[] mappings) {
        if (mappings == null || mappings.length == 0) {
            return null;
        }
        for (String mapping : mappings) {
            if (!URLUtils.containsNoWildcards(mapping)) continue;
            return mapping;
        }
        return null;
    }

    private static boolean containsNoWildcards(String mapping) {
        return mapping.indexOf(42) == -1;
    }
}

