/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometFilter;
import org.apache.catalina.comet.CometFilterChain;
import org.apache.catalina.filters.FilterBase;

public abstract class RequestFilter
extends FilterBase
implements CometFilter {
    protected Pattern allow = null;
    protected Pattern deny = null;
    private static final String PLAIN_TEXT_MIME_TYPE = "text/plain";

    public String getAllow() {
        if (this.allow == null) {
            return null;
        }
        return this.allow.toString();
    }

    public void setAllow(String allow) {
        this.allow = allow == null || allow.length() == 0 ? null : Pattern.compile(allow);
    }

    public String getDeny() {
        if (this.deny == null) {
            return null;
        }
        return this.deny.toString();
    }

    public void setDeny(String deny) {
        this.deny = deny == null || deny.length() == 0 ? null : Pattern.compile(deny);
    }

    public abstract void doFilter(ServletRequest var1, ServletResponse var2, FilterChain var3) throws IOException, ServletException;

    protected void process(String property, ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isAllowed(property)) {
            chain.doFilter(request, response);
        } else if (response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).sendError(403);
        } else {
            this.sendErrorWhenNotHttp(response);
        }
    }

    protected void processCometEvent(String property, CometEvent event, CometFilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = event.getHttpServletResponse();
        if (this.isAllowed(property)) {
            chain.doFilterEvent(event);
        } else {
            response.sendError(403);
            event.close();
        }
    }

    private boolean isAllowed(String property) {
        if (this.deny != null && this.deny.matcher(property).matches()) {
            return false;
        }
        if (this.allow != null & this.allow.matcher(property).matches()) {
            return true;
        }
        return this.deny != null && this.allow == null;
    }

    private void sendErrorWhenNotHttp(ServletResponse response) throws IOException {
        response.setContentType(PLAIN_TEXT_MIME_TYPE);
        response.getWriter().write(sm.getString("http.403"));
        response.getWriter().flush();
    }
}

