/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.Http11Processor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Protocol
extends AbstractHttp11JsseProtocol {
    private static final Log log = LogFactory.getLog(Http11Protocol.class);
    protected Http11ConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public Http11Protocol() {
        this.endpoint = new JIoEndpoint();
        this.cHandler = new Http11ConnectionHandler(this);
        ((JIoEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
        this.setProcessorCache(200);
    }

    @Override
    protected String getNamePrefix() {
        return "http-bio";
    }

    protected static class Http11ConnectionHandler
    implements JIoEndpoint.Handler {
        protected Http11Protocol proto;
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<SocketWrapper<Socket>, Http11Processor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<Http11Processor> recycledProcessors = new ConcurrentLinkedQueue<Http11Processor>(){
            private static final long serialVersionUID = 1L;
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(Http11Processor processor) {
                boolean offer = Http11ConnectionHandler.this.proto.getProcessorCache() == -1 ? true : this.size.get() < Http11ConnectionHandler.this.proto.getProcessorCache();
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    Http11ConnectionHandler.this.unregister(processor);
                }
                return result;
            }

            @Override
            public Http11Processor poll() {
                Http11Processor result = (Http11Processor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                Http11Processor next = this.poll();
                while (next != null) {
                    Http11ConnectionHandler.this.unregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };

        Http11ConnectionHandler(Http11Protocol proto) {
            this.proto = proto;
        }

        @Override
        public Object getGlobal() {
            return this.global;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return this.proto.sslImplementation;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socket) {
            return this.process(socket, SocketStatus.OPEN);
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socket, SocketStatus status) {
            Http11Processor processor = this.connections.remove(socket);
            try {
                AbstractEndpoint.Handler.SocketState state;
                if (processor == null) {
                    processor = this.recycledProcessors.poll();
                }
                if (processor == null) {
                    processor = this.createProcessor();
                }
                if (this.proto.isSSLEnabled() && this.proto.sslImplementation != null) {
                    processor.setSSLSupport(this.proto.sslImplementation.getSSLSupport(socket.getSocket()));
                } else {
                    processor.setSSLSupport(null);
                }
                AbstractEndpoint.Handler.SocketState socketState = state = socket.isAsync() ? processor.asyncDispatch(status) : processor.process(socket);
                if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    socket.setAsync(true);
                    return processor.asyncPostProcess();
                }
                this.connections.remove(socket);
                socket.setAsync(false);
                this.recycledProcessors.offer(processor);
                return state;
            }
            catch (SocketException e) {
                log.debug(AbstractHttp11Protocol.sm.getString("http11protocol.proto.socketexception.debug"), e);
            }
            catch (IOException e) {
                log.debug(AbstractHttp11Protocol.sm.getString("http11protocol.proto.ioexception.debug"), e);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                log.error(AbstractHttp11Protocol.sm.getString("http11protocol.proto.error"), e);
            }
            this.recycledProcessors.offer(processor);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        protected Http11Processor createProcessor() {
            Http11Processor processor = new Http11Processor(this.proto.getMaxHttpHeaderSize(), (JIoEndpoint)this.proto.endpoint, this.proto.getMaxTrailerSize());
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.getMaxKeepAliveRequests());
            processor.setKeepAliveTimeout(this.proto.getKeepAliveTimeout());
            processor.setConnectionUploadTimeout(this.proto.getConnectionUploadTimeout());
            processor.setDisableUploadTimeout(this.proto.getDisableUploadTimeout());
            processor.setCompressionMinSize(this.proto.getCompressionMinSize());
            processor.setCompression(this.proto.getCompression());
            processor.setNoCompressionUserAgents(this.proto.getNoCompressionUserAgents());
            processor.setCompressableMimeTypes(this.proto.getCompressableMimeTypes());
            processor.setRestrictedUserAgents(this.proto.getRestrictedUserAgents());
            processor.setSocketBuffer(this.proto.getSocketBuffer());
            processor.setMaxSavePostSize(this.proto.getMaxSavePostSize());
            processor.setServer(this.proto.getServer());
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(Http11Processor processor) {
            if (this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        final RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(this.global);
                        final ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=HttpRequest" + count);
                        if (log.isDebugEnabled()) {
                            log.debug("Register " + rpName);
                        }
                        if (Constants.IS_SECURITY_ENABLED) {
                            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                                @Override
                                public Void run() {
                                    try {
                                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                                    }
                                    catch (Exception e) {
                                        log.warn("Error registering request");
                                    }
                                    return null;
                                }
                            });
                        } else {
                            Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        }
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        log.warn("Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(Http11Processor processor) {
            if (this.proto.getDomain() != null) {
                Http11ConnectionHandler http11ConnectionHandler = this;
                synchronized (http11ConnectionHandler) {
                    try {
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(null);
                        ObjectName rpName = rp.getRpName();
                        if (log.isDebugEnabled()) {
                            log.debug("Unregister " + rpName);
                        }
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        log.warn("Error unregistering request", e);
                    }
                }
            }
        }
    }
}

