/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;

public class InternalOutputBuffer
extends AbstractOutputBuffer
implements ByteChunk.ByteOutputChannel {
    protected OutputStream outputStream;
    protected ByteChunk socketBuffer;
    protected boolean useSocketBuffer = false;

    public InternalOutputBuffer(Response response, int headerBufferSize) {
        this.response = response;
        this.buf = new byte[headerBufferSize];
        this.outputStreamOutputBuffer = new OutputStreamOutputBuffer();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.socketBuffer = new ByteChunk();
        this.socketBuffer.setByteOutputChannel(this);
        this.committed = false;
        this.finished = false;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setSocketBuffer(int socketBufferSize) {
        if (socketBufferSize > 500) {
            this.useSocketBuffer = true;
            this.socketBuffer.allocate(socketBufferSize, socketBufferSize);
        } else {
            this.useSocketBuffer = false;
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.useSocketBuffer) {
            this.socketBuffer.flushBuffer();
        }
    }

    @Override
    public void recycle() {
        super.recycle();
        this.socketBuffer.recycle();
        this.outputStream = null;
    }

    @Override
    public void nextRequest() {
        super.nextRequest();
        this.socketBuffer.recycle();
    }

    @Override
    public void endRequest() throws IOException {
        super.endRequest();
        if (this.useSocketBuffer) {
            this.socketBuffer.flushBuffer();
        }
    }

    @Override
    public void sendAck() throws IOException {
        if (!this.committed) {
            this.outputStream.write(Constants.ACK_BYTES);
        }
    }

    @Override
    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            if (this.useSocketBuffer) {
                this.socketBuffer.append(this.buf, 0, this.pos);
            } else {
                this.outputStream.write(this.buf, 0, this.pos);
            }
        }
    }

    @Override
    public void realWriteBytes(byte[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            this.outputStream.write(cbuf, off, len);
        }
    }

    protected class OutputStreamOutputBuffer
    implements OutputBuffer {
        protected OutputStreamOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            int length = chunk.getLength();
            if (InternalOutputBuffer.this.useSocketBuffer) {
                InternalOutputBuffer.this.socketBuffer.append(chunk.getBuffer(), chunk.getStart(), length);
            } else {
                InternalOutputBuffer.this.outputStream.write(chunk.getBuffer(), chunk.getStart(), length);
            }
            InternalOutputBuffer.this.byteCount += (long)chunk.getLength();
            return chunk.getLength();
        }

        @Override
        public long getBytesWritten() {
            return InternalOutputBuffer.this.byteCount;
        }
    }
}

