/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Context;
import org.apache.catalina.util.Extension;
import org.apache.catalina.util.ManifestResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.resources.Resource;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public final class ExtensionValidator {
    private static final Log log = LogFactory.getLog(ExtensionValidator.class);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.util");
    private static volatile ArrayList<Extension> containerAvailableExtensions = null;
    private static ArrayList<ManifestResource> containerManifestResources = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean validateApplication(DirContext dirContext, Context context) throws IOException {
        Binding binding;
        String appName = context.getName();
        ArrayList<ManifestResource> appManifestResources = new ArrayList<ManifestResource>();
        if (dirContext == null) {
            return false;
        }
        InputStream inputStream = null;
        try {
            NamingEnumeration<Binding> wne = dirContext.listBindings("/META-INF/");
            binding = (Binding)wne.nextElement();
            if (binding.getName().toUpperCase(Locale.ENGLISH).equals("MANIFEST.MF")) {
                Resource resource = (Resource)dirContext.lookup("/META-INF/" + binding.getName());
                inputStream = resource.streamContent();
                Manifest manifest = new Manifest(inputStream);
                inputStream.close();
                inputStream = null;
                ManifestResource mre = new ManifestResource(sm.getString("extensionValidator.web-application-manifest"), manifest, 2);
                appManifestResources.add(mre);
            }
        }
        catch (NamingException nex) {
        }
        catch (NoSuchElementException nse) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
            }
        }
        NamingEnumeration<Binding> ne = null;
        try {
            ne = dirContext.listBindings("WEB-INF/lib/");
            while (ne != null && ne.hasMoreElements()) {
                Resource resource;
                Manifest jmanifest;
                Object obj;
                binding = (Binding)ne.nextElement();
                if (!binding.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || !((obj = dirContext.lookup("/WEB-INF/lib/" + binding.getName())) instanceof Resource) || (jmanifest = ExtensionValidator.getManifest(inputStream = (resource = (Resource)obj).streamContent())) == null) continue;
                ManifestResource mre = new ManifestResource(binding.getName(), jmanifest, 3);
                appManifestResources.add(mre);
            }
        }
        catch (NamingException nex) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
            }
        }
        return ExtensionValidator.validateManifestResources(appName, appManifestResources);
    }

    public static void addSystemResource(File jarFile) throws IOException {
        Manifest manifest = ExtensionValidator.getManifest(new FileInputStream(jarFile));
        if (manifest != null) {
            ManifestResource mre = new ManifestResource(jarFile.getAbsolutePath(), manifest, 1);
            containerManifestResources.add(mre);
        }
    }

    private static boolean validateManifestResources(String appName, ArrayList<ManifestResource> resources) {
        boolean passes = true;
        int failureCount = 0;
        ArrayList<Extension> availableExtensions = null;
        for (ManifestResource mre : resources) {
            ArrayList<Extension> requiredList = mre.getRequiredExtensions();
            if (requiredList == null) continue;
            if (availableExtensions == null) {
                availableExtensions = ExtensionValidator.buildAvailableExtensionsList(resources);
            }
            if (containerAvailableExtensions == null) {
                containerAvailableExtensions = ExtensionValidator.buildAvailableExtensionsList(containerManifestResources);
            }
            Iterator<Extension> rit = requiredList.iterator();
            while (rit.hasNext()) {
                boolean found = false;
                Extension requiredExt = rit.next();
                if (availableExtensions != null) {
                    for (Extension targetExt : availableExtensions) {
                        if (!targetExt.isCompatibleWith(requiredExt)) continue;
                        requiredExt.setFulfilled(true);
                        found = true;
                        break;
                    }
                }
                if (!found && containerAvailableExtensions != null) {
                    for (Extension targetExt : containerAvailableExtensions) {
                        if (!targetExt.isCompatibleWith(requiredExt)) continue;
                        requiredExt.setFulfilled(true);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                log.info(sm.getString("extensionValidator.extension-not-found-error", appName, mre.getResourceName(), requiredExt.getExtensionName()));
                passes = false;
                ++failureCount;
            }
        }
        if (!passes) {
            log.info(sm.getString("extensionValidator.extension-validation-error", appName, failureCount + ""));
        }
        return passes;
    }

    private static ArrayList<Extension> buildAvailableExtensionsList(ArrayList<ManifestResource> resources) {
        ArrayList<Extension> availableList = null;
        for (ManifestResource mre : resources) {
            ArrayList<Extension> list = mre.getAvailableExtensions();
            if (list == null) continue;
            for (Extension ext : list) {
                if (availableList == null) {
                    availableList = new ArrayList<Extension>();
                    availableList.add(ext);
                    continue;
                }
                availableList.add(ext);
            }
        }
        return availableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(InputStream inStream) throws IOException {
        Manifest manifest = null;
        JarInputStream jin = null;
        try {
            jin = new JarInputStream(inStream);
            manifest = jin.getManifest();
            jin.close();
            jin = null;
        }
        finally {
            if (jin != null) {
                try {
                    jin.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
            }
        }
        return manifest;
    }

    private static void addFolderList(String property) {
        String extensionsDir = System.getProperty(property);
        if (extensionsDir != null) {
            StringTokenizer extensionsTok = new StringTokenizer(extensionsDir, File.pathSeparator);
            while (extensionsTok.hasMoreTokens()) {
                File targetDir = new File(extensionsTok.nextToken());
                if (!targetDir.isDirectory()) continue;
                File[] files = targetDir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || !files[i].isFile()) continue;
                    try {
                        ExtensionValidator.addSystemResource(files[i]);
                        continue;
                    }
                    catch (IOException e) {
                        log.error(sm.getString("extensionValidator.failload", files[i]), e);
                    }
                }
            }
        }
    }

    static {
        String systemClasspath = System.getProperty("java.class.path");
        StringTokenizer strTok = new StringTokenizer(systemClasspath, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            File item;
            String classpathItem = strTok.nextToken();
            if (!classpathItem.toLowerCase(Locale.ENGLISH).endsWith(".jar") || !(item = new File(classpathItem)).isFile()) continue;
            try {
                ExtensionValidator.addSystemResource(item);
            }
            catch (IOException e) {
                log.error(sm.getString("extensionValidator.failload", item), e);
            }
        }
        ExtensionValidator.addFolderList("java.ext.dirs");
        ExtensionValidator.addFolderList("catalina.ext.dirs");
    }
}

