/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat7.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;
import org.apache.catalina.startup.TldConfig;
import org.apache.jasper.servlet.JspServlet;
import org.ow2.jonas.web.tomcat7.osgi.OSGiInstanceTldCacheListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiTldListener
implements LifecycleListener {
    private TldConfig tldConfig;
    private List<URL> resourcesToMonitor = null;
    private Method tldScanStreamMethod = null;

    public OSGiTldListener(List<URL> resourcesToMonitor) {
        this.resourcesToMonitor = resourcesToMonitor;
        this.tldConfig = new TldConfig();
        try {
            this.tldScanStreamMethod = this.tldConfig.getClass().getDeclaredMethod("tldScanStream", InputStream.class);
            this.tldScanStreamMethod.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unable to find the given method", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to find the given method", e);
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        Context context = null;
        try {
            context = (Context)event.getLifecycle();
        }
        catch (ClassCastException e) {
            return;
        }
        if (event.getType().equals("after_init")) {
            this.tldConfig.lifecycleEvent(event);
        } else if (event.getType().equals("configure_start")) {
            String[] listeners;
            if (this.resourcesToMonitor != null) {
                for (URL url : this.resourcesToMonitor) {
                    try {
                        URLConnection urlConnection = url.openConnection();
                        urlConnection.setDefaultUseCaches(false);
                        this.tldScanStreamMethod.invoke((Object)this.tldConfig, urlConnection.getInputStream());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Unable to add the TLD", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Unable to add the TLD", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException("Unable to add the TLD", e);
                    }
                }
            }
            if ((listeners = this.tldConfig.getTldListeners()) != null) {
                for (String listener : listeners) {
                    context.addApplicationListener(listener);
                }
            }
            this.addTldIntoCache(context);
        } else if (event.getType().equals("stop")) {
            this.tldConfig.lifecycleEvent(event);
        }
    }

    protected void addTldIntoCache(Context context) {
        Container[] childs = context.findChildren();
        if (childs != null) {
            for (Container child : childs) {
                Wrapper wrapper = (Wrapper)child;
                String servletClass = wrapper.getServletClass();
                if (!JspServlet.class.getName().equals(servletClass)) continue;
                wrapper.addInstanceListener(new OSGiInstanceTldCacheListener(this.resourcesToMonitor));
            }
        }
    }
}

