/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.net.InetAddress;
import java.util.concurrent.Executor;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractProtocolHandler
implements ProtocolHandler,
MBeanRegistration {
    protected static final StringManager sm = StringManager.getManager("org.apache.coyote");
    protected ObjectName rgOname = null;
    protected ObjectName tpOname = null;
    protected AbstractEndpoint endpoint = null;
    protected Adapter adapter;
    protected int processorCache = 200;
    protected String clientCertProvider = null;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public boolean setProperty(String name, String value) {
        return this.endpoint.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.endpoint.getProperty(name);
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String s) {
        this.clientCertProvider = s;
    }

    @Override
    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public int getMaxConnections() {
        return this.endpoint.getMaxConnections();
    }

    public void setMaxConnections(int maxConnections) {
        this.endpoint.setMaxConnections(maxConnections);
    }

    public int getMinSpareThreads() {
        return this.endpoint.getMinSpareThreads();
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.endpoint.setMinSpareThreads(minSpareThreads);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.endpoint.setBacklog(backlog);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.endpoint.setSoLinger(soLinger);
    }

    public int getKeepAliveTimeout() {
        return this.endpoint.getKeepAliveTimeout();
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.endpoint.setKeepAliveTimeout(keepAliveTimeout);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public int getConnectionTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setConnectionTimeout(int timeout) {
        this.endpoint.setSoTimeout(timeout);
    }

    public int getSoTimeout() {
        return this.getConnectionTimeout();
    }

    public void setSoTimeout(int timeout) {
        this.setConnectionTimeout(timeout);
    }

    public String getName() {
        StringBuilder name = new StringBuilder(this.getNamePrefix());
        name.append('-');
        if (this.getAddress() != null) {
            name.append(this.getAddress());
            name.append('-');
        }
        name.append(this.endpoint.getPort());
        return ObjectName.quote(name.toString());
    }

    protected abstract Log getLog();

    protected abstract String getNamePrefix();

    protected abstract AbstractEndpoint.Handler getHandler();

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    private ObjectName createObjectName() throws MalformedObjectNameException {
        this.domain = this.adapter.getDomain();
        if (this.domain == null) {
            return null;
        }
        StringBuilder name = new StringBuilder(this.getDomain());
        name.append(":type=ProtocolHandler,port=");
        name.append(this.getPort());
        InetAddress address = this.getAddress();
        if (address != null) {
            name.append(",address=");
            name.append(ObjectName.quote(address.toString()));
        }
        return new ObjectName(name.toString());
    }

    @Override
    public void init() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.init", this.getName()));
        }
        if (this.oname == null) {
            this.oname = this.createObjectName();
            if (this.oname != null) {
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
        }
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.endpoint, this.tpOname, null);
            }
            catch (Exception e) {
                this.getLog().error(sm.getString("abstractProtocolHandler.mbeanRegistrationFailed", this.tpOname, this.getName()), e);
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent(this.getHandler().getGlobal(), this.rgOname, null);
        }
        this.endpoint.setName(this.getName());
        try {
            this.endpoint.init();
        }
        catch (Exception ex) {
            this.getLog().error(sm.getString("abstractProtocolHandler.initError", this.getName()), ex);
            throw ex;
        }
    }

    @Override
    public void start() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.start", this.getName()));
        }
        try {
            this.endpoint.start();
        }
        catch (Exception ex) {
            this.getLog().error(sm.getString("abstractProtocolHandler.startError", this.getName()), ex);
            throw ex;
        }
    }

    @Override
    public void pause() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.pause", this.getName()));
        }
        try {
            this.endpoint.pause();
        }
        catch (Exception ex) {
            this.getLog().error(sm.getString("abstractProtocolHandler.pauseError", this.getName()), ex);
            throw ex;
        }
    }

    @Override
    public void resume() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.resume", this.getName()));
        }
        try {
            this.endpoint.resume();
        }
        catch (Exception ex) {
            this.getLog().error(sm.getString("abstractProtocolHandler.resumeError", this.getName()), ex);
            throw ex;
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.stop", this.getName()));
        }
        try {
            this.endpoint.stop();
        }
        catch (Exception ex) {
            this.getLog().error(sm.getString("abstractProtocolHandler.stopError", this.getName()), ex);
            throw ex;
        }
    }

    @Override
    public void destroy() {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(sm.getString("abstractProtocolHandler.destroy", this.getName()));
        }
        try {
            this.endpoint.destroy();
        }
        catch (Exception e) {
            this.getLog().error(sm.getString("abstractProtocolHandler.destroyError", this.getName()), e);
        }
        if (this.oname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
        }
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }
}

