/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Locale;
import java.util.concurrent.Executor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Processor
extends AbstractHttp11Processor {
    private static final Log log = LogFactory.getLog(Http11Processor.class);
    protected InternalInputBuffer inputBuffer = null;
    protected InternalOutputBuffer outputBuffer = null;
    protected SSLSupport sslSupport;
    protected SocketWrapper<Socket> socket;
    protected JIoEndpoint endpoint;
    private int disableKeepAlivePercentage = 75;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11Processor(int headerBufferSize, JIoEndpoint endpoint, int maxTrailerSize) {
        this.endpoint = endpoint;
        this.request = new Request();
        this.inputBuffer = new InternalInputBuffer(this.request, headerBufferSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.response = new Response();
        this.response.setHook(this);
        this.outputBuffer = new InternalOutputBuffer(this.response, headerBufferSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters(maxTrailerSize);
        HexUtils.load();
    }

    @Override
    protected AbstractEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setSSLSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    public int getDisableKeepAlivePercentage() {
        return this.disableKeepAlivePercentage;
    }

    public void setDisableKeepAlivePercentage(int disableKeepAlivePercentage) {
        this.disableKeepAlivePercentage = disableKeepAlivePercentage;
    }

    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socketWrapper) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localAddr = null;
        this.localName = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.socket = socketWrapper;
        this.inputBuffer.setInputStream(this.socket.getSocket().getInputStream());
        this.outputBuffer.setOutputStream(this.socket.getSocket().getOutputStream());
        this.error = false;
        this.keepAlive = true;
        if (this.maxKeepAliveRequests > 0) {
            socketWrapper.decrementKeepAlive();
        }
        int soTimeout = this.endpoint.getSoTimeout();
        int threadRatio = -1;
        if (this.endpoint.getCurrentThreadsBusy() > 0 && this.endpoint.getMaxThreads() > 0) {
            threadRatio = this.endpoint.getCurrentThreadsBusy() * 100 / this.endpoint.getMaxThreads();
        }
        if (threadRatio > this.getDisableKeepAlivePercentage()) {
            socketWrapper.setKeepAliveLeft(0);
        }
        try {
            this.socket.getSocket().setSoTimeout(soTimeout);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.debug(sm.getString("http11processor.socket.timeout"), t);
            this.error = true;
        }
        boolean keptAlive = socketWrapper.isKeptAlive();
        while (!this.error && this.keepAlive && !this.endpoint.isPaused()) {
            try {
                int standardTimeout = 0;
                if (keptAlive) {
                    if (this.keepAliveTimeout > 0) {
                        standardTimeout = this.keepAliveTimeout;
                    } else if (soTimeout > 0) {
                        standardTimeout = soTimeout;
                    }
                }
                if (this.inputBuffer.lastValid == 0 && socketWrapper.getLastAccess() > -1L && standardTimeout > 0) {
                    long queueTime = System.currentTimeMillis() - socketWrapper.getLastAccess();
                    int firstReadTimeout = queueTime >= (long)standardTimeout ? 1 : standardTimeout - (int)queueTime;
                    this.socket.getSocket().setSoTimeout(firstReadTimeout);
                    if (!this.inputBuffer.fill()) {
                        throw new EOFException(sm.getString("iib.eof.error"));
                    }
                }
                if (standardTimeout > 0) {
                    this.socket.getSocket().setSoTimeout(standardTimeout);
                }
                this.inputBuffer.parseRequestLine(false);
                if (this.endpoint.isPaused()) {
                    this.response.setStatus(503);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                } else {
                    this.request.setStartTime(System.currentTimeMillis());
                    keptAlive = true;
                    if (this.disableUploadTimeout) {
                        this.socket.getSocket().setSoTimeout(soTimeout);
                    } else {
                        this.socket.getSocket().setSoTimeout(this.connectionUploadTimeout);
                    }
                    this.inputBuffer.parseHeaders();
                }
            }
            catch (IOException e) {
                this.error = true;
                break;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("http11processor.header.parse"), t);
                }
                this.response.setStatus(400);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            if (!this.error) {
                rp.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("http11processor.request.prepare"), t);
                    }
                    this.response.setStatus(400);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            if (socketWrapper.getKeepAliveLeft() == 0) {
                this.keepAlive = false;
            }
            if (!this.error) {
                try {
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                    if (this.keepAlive && !this.error) {
                        this.error = this.response.getErrorException() != null || this.statusDropsConnection(this.response.getStatus());
                    }
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    log.error(sm.getString("http11processor.request.process"), t);
                    this.response.setStatus(500);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            try {
                rp.setStage(4);
                if (this.error && !this.isAsync()) {
                    this.inputBuffer.setSwallowInput(false);
                }
                if (!this.isAsync()) {
                    this.endRequest();
                }
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.error(sm.getString("http11processor.request.finish"), t);
                this.response.setStatus(500);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            try {
                rp.setStage(5);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.error(sm.getString("http11processor.response.finish"), t);
                this.error = true;
            }
            if (this.error) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            rp.setStage(6);
            if (!this.isAsync() || this.error) {
                this.inputBuffer.nextRequest();
                this.outputBuffer.nextRequest();
            }
            if (this.isAsync() || this.error || this.inputBuffer.lastValid == 0) break;
            if (this.maxKeepAliveRequests <= 0) continue;
            socketWrapper.decrementKeepAlive();
        }
        rp.setStage(7);
        if (this.error || this.endpoint.isPaused()) {
            this.recycle();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.recycle();
        if (!this.keepAlive) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus status) {
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            this.error = !this.adapter.asyncDispatch(this.request, this.response, status);
        }
        catch (InterruptedIOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error(sm.getString("http11processor.request.process"), t);
            this.response.setStatus(500);
            this.adapter.log(this.request, this.response, 0L);
            this.error = true;
        }
        rp.setStage(7);
        if (this.error) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        if (!this.keepAlive) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    @Override
    protected void recycleInternal() {
        this.socket = null;
        this.sslSupport = null;
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.CLOSE) {
            try {
                this.outputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.REQ_SSL_ATTRIBUTE) {
            try {
                if (this.sslSupport != null) {
                    Object sslO = this.sslSupport.getCipherSuite();
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                    }
                    this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
                }
            }
            catch (Exception e) {
                log.warn(sm.getString("http11processor.socket.ssl"), e);
            }
        } else if (actionCode == ActionCode.REQ_HOST_ADDR_ATTRIBUTE) {
            InetAddress inetAddr;
            if (this.remoteAddr == null && this.socket != null && (inetAddr = this.socket.getSocket().getInetAddress()) != null) {
                this.remoteAddr = inetAddr.getHostAddress();
            }
            this.request.remoteAddr().setString(this.remoteAddr);
        } else if (actionCode == ActionCode.REQ_LOCAL_NAME_ATTRIBUTE) {
            InetAddress inetAddr;
            if (this.localName == null && this.socket != null && (inetAddr = this.socket.getSocket().getLocalAddress()) != null) {
                this.localName = inetAddr.getHostName();
            }
            this.request.localName().setString(this.localName);
        } else if (actionCode == ActionCode.REQ_HOST_ATTRIBUTE) {
            if (this.remoteHost == null && this.socket != null) {
                InetAddress inetAddr = this.socket.getSocket().getInetAddress();
                if (inetAddr != null) {
                    this.remoteHost = inetAddr.getHostName();
                }
                if (this.remoteHost == null) {
                    if (this.remoteAddr != null) {
                        this.remoteHost = this.remoteAddr;
                    } else {
                        this.request.remoteHost().recycle();
                    }
                }
            }
            this.request.remoteHost().setString(this.remoteHost);
        } else if (actionCode == ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE) {
            if (this.localAddr == null) {
                this.localAddr = this.socket.getSocket().getLocalAddress().getHostAddress();
            }
            this.request.localAddr().setString(this.localAddr);
        } else if (actionCode == ActionCode.REQ_REMOTEPORT_ATTRIBUTE) {
            if (this.remotePort == -1 && this.socket != null) {
                this.remotePort = this.socket.getSocket().getPort();
            }
            this.request.setRemotePort(this.remotePort);
        } else if (actionCode == ActionCode.REQ_LOCALPORT_ATTRIBUTE) {
            if (this.localPort == -1 && this.socket != null) {
                this.localPort = this.socket.getSocket().getLocalPort();
            }
            this.request.setLocalPort(this.localPort);
        } else if (actionCode == ActionCode.REQ_SSL_CERTIFICATE) {
            if (this.sslSupport != null) {
                InputFilter[] inputFilters = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilters[3]);
                try {
                    Object[] sslO = this.sslSupport.getPeerCertificateChain(true);
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                }
                catch (Exception e) {
                    log.warn(sm.getString("http11processor.socket.ssl"), e);
                }
            }
        } else if (actionCode == ActionCode.ASYNC_COMPLETE) {
            if (this.asyncStateMachine.asyncComplete()) {
                this.endpoint.processSocketAsync(this.socket, SocketStatus.OPEN);
            }
        } else if (actionCode == ActionCode.ASYNC_SETTIMEOUT) {
            if (param == null) {
                return;
            }
            long timeout = (Long)param;
            this.socket.setTimeout(timeout);
        } else if (actionCode == ActionCode.ASYNC_DISPATCH && this.asyncStateMachine.asyncDispatch()) {
            this.endpoint.processSocketAsync(this.socket, SocketStatus.OPEN);
        }
    }

    protected void prepareRequest() {
        long contentLength;
        ByteChunk uriBC;
        MessageBytes userAgentValueMB;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        this.expectation = false;
        if (this.sslSupport != null) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.error = true;
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("http11processor.request.prepare") + " Unsupported HTTP version \"" + protocolMB + "\"");
            }
            this.response.setStatus(505);
            this.adapter.log(this.request, this.response, 0L);
        }
        MessageBytes methodMB = this.request.method();
        if (methodMB.equals("GET")) {
            methodMB.setString("GET");
        } else if (methodMB.equals("POST")) {
            methodMB.setString("POST");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
            } else if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
            }
        }
        MessageBytes expectMB = null;
        if (this.http11) {
            expectMB = headers.getValue("expect");
        }
        if (expectMB != null && expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
            this.inputBuffer.setSwallowInput(false);
            this.expectation = true;
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive) && (userAgentValueMB = headers.getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            if (this.restrictedUserAgents != null && this.restrictedUserAgents.matcher(userAgentValue).matches()) {
                this.http11 = false;
                this.keepAlive = false;
            }
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = headers.getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos).toLowerCase(Locale.ENGLISH).trim();
                if (!this.addInputFilter(inputFilters, encodingName)) {
                    this.error = true;
                    this.response.setStatus(501);
                    this.adapter.log(this.request, this.response, 0L);
                }
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos).toLowerCase(Locale.ENGLISH).trim();
            if (!this.addInputFilter(inputFilters, encodingName)) {
                this.error = true;
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("http11processor.request.prepare") + " Unsupported transfer encoding \"" + encodingName + "\"");
                }
                this.response.setStatus(501);
                this.adapter.log(this.request, this.response, 0L);
            }
        }
        if ((contentLength = this.request.getContentLengthLong()) >= 0L && !this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[0]);
            this.contentDelimitation = true;
        }
        MessageBytes valueMB = headers.getValue("host");
        if (this.http11 && valueMB == null) {
            this.error = true;
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("http11processor.request.prepare") + " host header missing");
            }
            this.response.setStatus(400);
            this.adapter.log(this.request, this.response, 0L);
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilters) {
        Exception e = new Exception();
        log.error(sm.getString("http11processor.neverused"), e);
        return false;
    }

    protected void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(this.socket.getSocket().getLocalPort());
            InetAddress localAddress = this.socket.getSocket().getLocalAddress();
            this.request.serverName().setString(localAddress.getHostName());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (this.sslSupport == null) {
                this.request.setServerPort(80);
            } else {
                this.request.setServerPort(443);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.getDec(valueB[i + valueS]);
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    this.adapter.log(this.request, this.response, 0L);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    @Override
    protected AbstractInputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public void setSocketBuffer(int socketBuffer) {
        super.setSocketBuffer(socketBuffer);
        this.outputBuffer.setSocketBuffer(socketBuffer);
    }

    @Override
    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }
}

