/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.joram.admin;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.objectweb.joram.client.connector.JoramAdapterMBean;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component(name="JoramQueueConnectionFactory", immediate=false)
public class JoramQueueConnectionFactory {
    private static Log logger = LogFactory.getLog(JoramQueueConnectionFactory.class);
    @Property(name="jndi.name", mandatory=true)
    private String jndiName;
    @Requires
    private JoramAdapterMBean service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validate
    public void start() {
        ClassLoader old = null;
        try {
            ClassLoader ext = this.getClass().getClassLoader();
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ext);
            this.service.createQueueCF(this.jndiName);
            logger.info((Object)("Create the queue CF '" + this.jndiName + "'"), new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)("Error when creating the queue CF '" + this.jndiName + "'"), new Object[]{e});
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    @Invalidate
    public void stop() {
        logger.warn((Object)("Unable to remove the queue CF '" + this.jndiName + "' - Feature not supported"), new Object[0]);
    }
}

