/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.joram.admin;

import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.annotations.Validate;
import org.objectweb.joram.client.connector.JoramAdapterMBean;
import org.objectweb.joram.client.jms.TopicMBean;
import org.osgi.framework.ServiceReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component(name="JoramTopic", immediate=false)
public class JoramTopic {
    private static Log logger = LogFactory.getLog(JoramTopic.class);
    @Property(name="jndi.name", mandatory=true)
    private String jndiName;
    @Requires
    private JoramAdapterMBean service;
    private TopicMBean topic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validate
    public void start() {
        ClassLoader old = null;
        try {
            ClassLoader ext = this.getClass().getClassLoader();
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ext);
            String res = this.service.createTopic(this.jndiName);
            logger.info((Object)("Create the topic '" + this.jndiName + "' : " + res), new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)("Error when creating the topic '" + this.jndiName + "'"), new Object[]{e});
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    @Invalidate
    public void stop() {
        try {
            if (this.topic != null) {
                this.topic.delete();
                logger.info((Object)("Remove the topic '" + this.jndiName + "'"), new Object[0]);
            } else {
                logger.warn((Object)("Unable to remove the topic service '" + this.jndiName + "'. Service unavailable"), new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error when removing the topic '" + this.jndiName + "'"), new Object[]{e});
        }
    }

    @Bind(optional=true, aggregate=true)
    public void bindTopicService(TopicMBean service, ServiceReference ref) {
        String serviceName = (String)ref.getProperty("name");
        if (serviceName.startsWith(this.jndiName + "[#")) {
            this.topic = service;
            logger.debug((Object)("Bind TopicService - " + serviceName), new Object[0]);
        }
    }

    @Unbind
    public void unbindTopicService(ServiceReference ref) {
        String name = (String)ref.getProperty("name");
        if (name.startsWith(this.jndiName + "[#")) {
            this.topic = null;
            logger.debug((Object)("Unbind Service - " + name), new Object[0]);
        }
    }
}

