/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.joram.admin;

import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.annotations.Validate;
import org.objectweb.joram.client.connector.JoramAdapterMBean;
import org.objectweb.joram.client.jms.admin.UserMBean;
import org.osgi.framework.ServiceReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component(name="JoramUser", immediate=false)
public class JoramUser {
    private static Log logger = LogFactory.getLog(JoramUser.class);
    @Property(name="name", mandatory=true)
    private String name;
    @Property(name="password", mandatory=true)
    private String password;
    @Requires
    private JoramAdapterMBean service;
    private UserMBean user;

    @Validate
    public void start() {
        try {
            String res = this.service.createUser(this.name, this.password);
            logger.info((Object)("Create the User '" + this.name + "' : " + res), new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)("Error when creating the User '" + this.name + "'"), new Object[]{e});
        }
    }

    @Invalidate
    public void stop() {
        try {
            if (this.user != null) {
                this.user.delete();
                logger.info((Object)("Remove the user '" + this.name + "'"), new Object[0]);
            } else {
                logger.warn((Object)("Unable to remove the user service '" + this.name + "'. Service unavailable"), new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error when removing the user '" + this.name + "'"), new Object[]{e});
        }
    }

    @Bind(optional=true, aggregate=true)
    public void bindUserService(UserMBean service, ServiceReference ref) {
        String serviceName = (String)ref.getProperty("name");
        if (serviceName.startsWith(this.name + "[#")) {
            this.user = service;
            logger.debug((Object)("Bind UserService - " + serviceName), new Object[0]);
        }
    }

    @Unbind
    public void unbindUserService(ServiceReference ref) {
        String name = (String)ref.getProperty("name");
        if (name.startsWith(name + "[#")) {
            this.user = null;
            logger.debug((Object)("Unbind Service - " + name), new Object[0]);
        }
    }
}

