/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.joram.admin;

import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.annotations.Validate;
import org.objectweb.joram.client.connector.JoramAdapterMBean;
import org.objectweb.joram.client.jms.QueueMBean;
import org.osgi.framework.ServiceReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component(name="JoramQueue", immediate=false)
public class JoramQueue {
    private static Log logger = LogFactory.getLog(JoramQueue.class);
    @Property(name="jndi.name", mandatory=true)
    private String jndiName;
    @Requires
    private JoramAdapterMBean service;
    private QueueMBean queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validate
    public void start() {
        ClassLoader old = null;
        try {
            ClassLoader ext = this.getClass().getClassLoader();
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ext);
            String res = this.service.createQueue(this.jndiName);
            logger.info((Object)("Create the queue '" + this.jndiName + "' : " + res), new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)("Error when creating the queue '" + this.jndiName + "'"), new Object[]{e});
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    @Invalidate
    public void stop() {
        try {
            if (this.queue != null) {
                this.queue.delete();
                logger.info((Object)("Remove the queue '" + this.jndiName + "'"), new Object[0]);
            } else {
                logger.warn((Object)("Unable to remove the queue service '" + this.jndiName + "'. Service unavailable"), new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error when removing the queue '" + this.jndiName + "'"), new Object[]{e});
        }
    }

    @Bind(optional=true, aggregate=true)
    public void bindQueueService(QueueMBean service, ServiceReference ref) {
        String serviceName = (String)ref.getProperty("name");
        if (serviceName.startsWith(this.jndiName + "[#")) {
            this.queue = service;
            logger.debug((Object)("Bind QueueService - " + serviceName), new Object[0]);
        }
    }

    @Unbind
    public void unbindQueueService(ServiceReference ref) {
        String name = (String)ref.getProperty("name");
        if (name.startsWith(this.jndiName + "[#")) {
            this.queue = null;
            logger.debug((Object)("Unbind Service - " + name), new Object[0]);
        }
    }
}

