/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.joram.admin;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.objectweb.joram.client.connector.JoramAdapterMBean;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component(name="JoramQueueConnectionFactory", immediate=false)
public class JoramQueueConnectionFactory {
    private static Log logger = LogFactory.getLog(JoramQueueConnectionFactory.class);
    @Property(name="jndi.name", mandatory=true)
    private String jndiName;
    @Requires
    private JoramAdapterMBean service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validate
    public void start() {
        ClassLoader old = null;
        try {
            ClassLoader ext = this.getClass().getClassLoader();
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ext);
            this.service.createQueueCF(this.jndiName);
            logger.info((Object)"Joram Queue Connection Factory ''{0}'' created", new Object[]{this.jndiName});
        }
        catch (Exception e) {
            logger.error((Object)"Error when creating the queue CF ''{0}''", new Object[]{this.jndiName, e});
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Invalidate
    public void stop() {
        InitialContext ctx;
        ClassLoader ext = this.getClass().getClassLoader();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ext);
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to get InitialContext", new Object[]{e});
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        try {
            ctx.unbind(this.jndiName);
            logger.info((Object)"Joram Queue Connection Factory ''{0}'' removed", new Object[]{this.jndiName});
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to unbind Queue Connection Factory ''{0}''", new Object[]{this.jndiName, e});
        }
    }
}

