/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.joram.admin;

import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.objectweb.joram.client.connector.JoramAdapterMBean;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component(name="JoramQueueConnectionFactory", immediate=false)
public class JoramQueueConnectionFactory
implements Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(JoramQueueConnectionFactory.class);
    private boolean __FjndiName;
    @Property(name="jndi.name", mandatory=true)
    private String jndiName;
    private boolean __Fservice;
    @Requires
    private JoramAdapterMBean service;
    private boolean __Mstart;
    private boolean __Mstop;

    String __getjndiName() {
        if (!this.__FjndiName) {
            return this.jndiName;
        }
        return (String)this.__IM.onGet((Object)this, "jndiName");
    }

    void __setjndiName(String string) {
        if (!this.__FjndiName) {
            this.jndiName = string;
            return;
        }
        this.__IM.onSet((Object)this, "jndiName", (Object)string);
    }

    JoramAdapterMBean __getservice() {
        if (!this.__Fservice) {
            return this.service;
        }
        return (JoramAdapterMBean)this.__IM.onGet((Object)this, "service");
    }

    void __setservice(JoramAdapterMBean joramAdapterMBean) {
        if (!this.__Fservice) {
            this.service = joramAdapterMBean;
            return;
        }
        this.__IM.onSet((Object)this, "service", (Object)joramAdapterMBean);
    }

    public JoramQueueConnectionFactory() {
        this(null);
    }

    private JoramQueueConnectionFactory(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validate
    private void __M_start() {
        ClassLoader old = null;
        try {
            ClassLoader ext = this.getClass().getClassLoader();
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ext);
            this.__getservice().createQueueCF(this.__getjndiName());
            logger.info((Object)"Joram Queue Connection Factory ''{0}'' created", new Object[]{this.__getjndiName()});
        }
        catch (Exception e) {
            logger.error((Object)"Error when creating the queue CF ''{0}''", new Object[]{this.__getjndiName(), e});
        }
        finally {
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Invalidate
    private void __M_stop() {
        InitialContext ctx;
        ClassLoader ext = this.getClass().getClassLoader();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ext);
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to get InitialContext", new Object[]{e});
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        try {
            ctx.unbind(this.__getjndiName());
            logger.info((Object)"Joram Queue Connection Factory ''{0}'' removed", new Object[]{this.__getjndiName()});
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to unbind Queue Connection Factory ''{0}''", new Object[]{this.__getjndiName(), e});
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("jndiName")) {
                this.__FjndiName = true;
            }
            if (set.contains("service")) {
                this.__Fservice = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

