/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleRevision;
import org.osgi.framework.BundleException;

public class R4Library {
    private Logger m_logger = null;
    private BundleRevision m_revision = null;
    private String m_libraryFile = null;
    private String[] m_osnames = null;
    private String[] m_processors = null;
    private String[] m_osversions = null;
    private String[] m_languages = null;
    private String m_selectionFilter = null;

    public R4Library(Logger logger, BundleRevision revision, String libraryFile, String[] osnames, String[] processors, String[] osversions, String[] languages, String selectionFilter) {
        this.m_logger = logger;
        this.m_revision = revision;
        this.m_libraryFile = libraryFile;
        this.m_osnames = osnames;
        this.m_processors = processors;
        this.m_osversions = osversions;
        this.m_languages = languages;
        this.m_selectionFilter = selectionFilter;
    }

    public String[] getOSNames() {
        return this.m_osnames;
    }

    public String[] getProcessors() {
        return this.m_processors;
    }

    public String[] getOSVersions() {
        return this.m_osversions;
    }

    public String[] getLanguages() {
        return this.m_languages;
    }

    public String getSelectionFilter() {
        return this.m_selectionFilter;
    }

    public String getPath(String name) {
        String libname = System.mapLibraryName(name);
        if (this.m_libraryFile.indexOf(libname) >= 0) {
            try {
                return this.m_revision.findLibrary(this.m_libraryFile);
            }
            catch (Exception ex) {
                this.m_logger.log(1, "R4Library: Finding library '" + name + "'.", new BundleException("Unable to find native library '" + name + "'."));
            }
        }
        return null;
    }

    public String toString() {
        if (this.m_libraryFile != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_libraryFile);
            sb.append(';');
            for (i = 0; this.m_osnames != null && i < this.m_osnames.length; ++i) {
                sb.append("osname");
                sb.append('=');
                sb.append(this.m_osnames[i]);
                sb.append(';');
            }
            for (i = 0; this.m_processors != null && i < this.m_processors.length; ++i) {
                sb.append("processor");
                sb.append(this.m_processors[i]);
                sb.append(';');
            }
            for (i = 0; this.m_osversions != null && i < this.m_osversions.length; ++i) {
                sb.append("osversion");
                sb.append(this.m_osversions[i]);
                sb.append(';');
            }
            for (i = 0; this.m_languages != null && i < this.m_languages.length; ++i) {
                sb.append("language");
                sb.append(this.m_languages[i]);
                sb.append(';');
            }
            sb.append("selection-filter");
            sb.append('=');
            sb.append('\'');
            sb.append(this.m_selectionFilter);
            sb.append('\'');
            return sb.toString();
        }
        return "*";
    }
}

