/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.net.ContentHandler;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.FelixBundle;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.URLHandlersServiceTracker;
import org.osgi.framework.BundleContext;

class URLHandlersContentHandlerProxy
extends ContentHandler {
    private Map m_trackerMap = new HashMap();
    private String m_mimeType = null;

    public URLHandlersContentHandlerProxy(String mimeType) {
        this.m_mimeType = mimeType;
    }

    public synchronized Object getContent(URLConnection urlc) throws IOException {
        ContentHandler svc = this.getContentHandlerService();
        if (svc == null) {
            return urlc.getInputStream();
        }
        return svc.getContent(urlc);
    }

    private ContentHandler getContentHandlerService() {
        Felix framework = URLHandlers.getFrameworkFromContext();
        if (framework == null) {
            return null;
        }
        URLHandlersServiceTracker tracker = (URLHandlersServiceTracker)this.m_trackerMap.get(framework);
        if (tracker == null) {
            BundleContext context = ((FelixBundle)framework.getBundle(0L)).getInfo().getBundleContext();
            String filter = "(&(objectClass=" + ContentHandler.class.getName() + ")(" + "url.content.mimetype" + "=" + this.m_mimeType + "))";
            tracker = new URLHandlersServiceTracker(context, filter);
            this.m_trackerMap.put(framework, tracker);
        }
        return (ContentHandler)tracker.getService();
    }
}

