/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.felix.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public final class JOnASUtils {
    private static final String JONAS_ROOT_PROP = "jonas.root";
    private static final String JONAS_BASE_PROP = "jonas.base";
    public static final String JONAS_DEVELOPER_PROP = "jonas.developer";
    public static final String JONAS_PROPERTIES = "jonas.properties";
    private static File base;
    private static File root;
    private static Boolean developerMode;

    private JOnASUtils() {
    }

    public static File getJOnASBase() {
        if (base == null) {
            String jb = System.getProperty(JONAS_BASE_PROP, System.getProperty(JONAS_ROOT_PROP));
            base = new File(jb);
        }
        return base;
    }

    public static String getServerProperty(String property, String defaultValue) throws Exception {
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(JOnASUtils.getJOnASBase() + File.separator + "conf" + File.separator + JONAS_PROPERTIES);
        props.load(fis);
        return props.getProperty(property, defaultValue);
    }

    public static File getJOnASRoot() {
        if (root == null) {
            String jr = System.getProperty(JONAS_ROOT_PROP);
            if (jr == null) {
                throw new IllegalStateException("Property 'jonas.root' is not set but is required");
            }
            root = new File(jr);
        }
        return root;
    }

    public static String getVersion() {
        return JOnASUtils.class.getPackage().getImplementationVersion();
    }

    public static boolean isDeveloperMode() {
        if (developerMode == null) {
            boolean mode = Boolean.getBoolean(JONAS_DEVELOPER_PROP);
            developerMode = mode;
        }
        return developerMode;
    }

    static {
        developerMode = null;
    }
}

