/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.moduleloader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import org.apache.felix.framework.util.SecureAction;
import org.apache.felix.moduleloader.IContent;
import org.apache.felix.moduleloader.JarFileX;

public class JarContent
implements IContent {
    private static final int BUFSIZE = 4096;
    private File m_file = null;
    private JarFileX m_jarFile = null;
    private boolean m_opened = false;
    private static SecureAction m_secureAction = new SecureAction();

    public JarContent(File file) {
        this.m_file = file;
    }

    protected void finalize() {
        if (this.m_jarFile != null) {
            try {
                this.m_jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void open() {
        this.m_opened = true;
    }

    public synchronized void close() {
        try {
            if (this.m_jarFile != null) {
                this.m_jarFile.close();
            }
        }
        catch (Exception ex) {
            System.err.println("JarContent: " + ex);
        }
        this.m_jarFile = null;
        this.m_opened = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasEntry(String name) throws IllegalStateException {
        if (!this.m_opened) {
            throw new IllegalStateException("JarContent is not open");
        }
        if (this.m_jarFile == null) {
            try {
                this.openJarFile();
            }
            catch (IOException ex) {
                System.err.println("JarContent: " + ex);
                return false;
            }
        }
        try {
            ZipEntry ze = this.m_jarFile.getEntry(name);
            boolean bl = ze != null;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized byte[] getEntry(String name) throws IllegalStateException {
        ByteArrayOutputStream baos;
        InputStream is;
        block36: {
            ZipEntry ze;
            block33: {
                if (!this.m_opened) {
                    throw new IllegalStateException("JarContent is not open");
                }
                if (this.m_jarFile == null) {
                    try {
                        this.openJarFile();
                    }
                    catch (IOException ex) {
                        System.err.println("JarContent: " + ex);
                        return null;
                    }
                }
                is = null;
                baos = null;
                ze = this.m_jarFile.getEntry(name);
                if (ze != null) break block33;
                byte[] byArray = null;
                Object var9_11 = null;
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                return byArray;
            }
            is = this.m_jarFile.getInputStream(ze);
            if (is != null) break block36;
            byte[] byArray = null;
            Object var9_12 = null;
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            return byArray;
        }
        baos = new ByteArrayOutputStream(4096);
        byte[] buf = new byte[4096];
        int n = 0;
        while ((n = is.read(buf, 0, buf.length)) >= 0) {
            baos.write(buf, 0, n);
        }
        byte[] byArray = baos.toByteArray();
        Object var9_13 = null;
        try {
            if (baos != null) {
                baos.close();
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        return byArray;
        catch (Exception ex) {
            byte[] byArray2;
            try {
                byArray2 = null;
                Object var9_14 = null;
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ex2) {}
                throw throwable;
            }
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            return byArray2;
        }
    }

    public synchronized InputStream getEntryAsStream(String name) throws IllegalStateException, IOException {
        if (!this.m_opened) {
            throw new IllegalStateException("JarContent is not open");
        }
        if (this.m_jarFile == null) {
            try {
                this.openJarFile();
            }
            catch (IOException ex) {
                System.err.println("JarContent: " + ex);
                return null;
            }
        }
        InputStream is = null;
        try {
            ZipEntry ze = this.m_jarFile.getEntry(name);
            if (ze == null) {
                return null;
            }
            is = this.m_jarFile.getInputStream(ze);
            if (is == null) {
                return null;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return is;
    }

    public synchronized Enumeration getEntries() {
        EntriesEnumeration e;
        if (!this.m_opened) {
            throw new IllegalStateException("JarContent is not open");
        }
        if (this.m_jarFile == null) {
            try {
                this.openJarFile();
            }
            catch (IOException ex) {
                System.err.println("JarContent: " + ex);
                return null;
            }
        }
        return (e = new EntriesEnumeration(this.m_jarFile.entries())).hasMoreElements() ? e : null;
    }

    private void openJarFile() throws IOException {
        if (this.m_jarFile == null) {
            this.m_jarFile = m_secureAction.openJAR(this.m_file);
        }
    }

    public String toString() {
        return "JAR " + this.m_file.getPath();
    }

    public File getFile() {
        return this.m_file;
    }

    private static class EntriesEnumeration
    implements Enumeration {
        private Enumeration m_enumeration = null;

        public EntriesEnumeration(Enumeration enumeration) {
            this.m_enumeration = enumeration;
        }

        public boolean hasMoreElements() {
            return this.m_enumeration.hasMoreElements();
        }

        public Object nextElement() {
            return ((ZipEntry)this.m_enumeration.nextElement()).getName();
        }
    }
}

