/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.main.AutoActivator;

public class Main {
    public static final String SYSTEM_PROPERTIES_PROP = "felix.system.properties";
    public static final String SYSTEM_PROPERTIES_FILE_VALUE = "system.properties";
    public static final String CONFIG_PROPERTIES_PROP = "felix.config.properties";
    public static final String CONFIG_PROPERTIES_FILE_VALUE = "config.properties";
    public static final String DEFAULT_PROPERTIES_FILE_VALUE = "default.properties";
    private static Felix m_felix = null;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";
    static /* synthetic */ Class class$org$apache$felix$main$Main;

    public static void main(String[] argv) throws Exception {
        Main.loadSystemProperties();
        Properties configProps = Main.loadConfigProperties();
        Main.copySystemProperties(configProps);
        String profileName = configProps.getProperty("felix.cache.profile");
        String profileDirName = configProps.getProperty("felix.cache.profiledir");
        System.out.println("\nWelcome to Felix.");
        System.out.println("=================\n");
        if (profileName == null && profileDirName == null) {
            System.out.print("Enter profile name: ");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                profileName = in.readLine();
            }
            catch (IOException ex) {
                System.err.println("Could not read input.");
                System.exit(-1);
            }
            System.out.println("");
            if (profileName.length() != 0) {
                configProps.setProperty("felix.cache.profile", profileName);
            }
        }
        if (profileDirName == null && profileName.length() == 0) {
            System.err.println("You must specify a profile name or directory.");
            System.exit(-1);
        }
        try {
            ArrayList<AutoActivator> list = new ArrayList<AutoActivator>();
            list.add(new AutoActivator(configProps));
            StringMap configMap = new StringMap(configProps, false);
            m_felix = new Felix(configMap, list);
            m_felix.start();
        }
        catch (Exception ex) {
            System.err.println("Could not create framework: " + ex);
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public static void loadSystemProperties() {
        int start;
        URL propURL = null;
        String custom = System.getProperty(SYSTEM_PROPERTIES_PROP);
        if (custom != null) {
            try {
                propURL = new URL(custom);
            }
            catch (MalformedURLException ex) {
                System.err.print("Main: " + ex);
                return;
            }
        }
        File confDir = null;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf("felix.jar");
        if (index >= (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            confDir = new File(new File(new File(jarLocation).getAbsolutePath()).getParent(), "conf");
        } else {
            confDir = new File(System.getProperty("user.dir"));
        }
        try {
            propURL = new File(confDir, SYSTEM_PROPERTIES_FILE_VALUE).toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return;
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            System.err.println("Main: Error loading system properties from " + propURL);
            System.err.println("Main: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return;
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            System.setProperty(name, Main.substVars(props.getProperty(name), name, null, null));
        }
    }

    public static Properties loadConfigProperties() {
        int start;
        URL propURL = null;
        String custom = System.getProperty(CONFIG_PROPERTIES_PROP);
        if (custom != null) {
            try {
                propURL = new URL(custom);
            }
            catch (MalformedURLException ex) {
                System.err.print("Main: " + ex);
                return null;
            }
        }
        File confDir = null;
        String classpath = System.getProperty("java.class.path");
        int index = classpath.toLowerCase().indexOf("felix.jar");
        if (index >= (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            confDir = new File(new File(new File(jarLocation).getAbsolutePath()).getParent(), "conf");
        } else {
            confDir = new File(System.getProperty("user.dir"));
        }
        try {
            propURL = new File(confDir, CONFIG_PROPERTIES_FILE_VALUE).toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return null;
        }
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = propURL.openConnection().getInputStream();
            props.load(is);
            is.close();
        }
        catch (Exception ex) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            propURL = (class$org$apache$felix$main$Main == null ? (class$org$apache$felix$main$Main = Main.class$("org.apache.felix.main.Main")) : class$org$apache$felix$main$Main).getClassLoader().getResource(DEFAULT_PROPERTIES_FILE_VALUE);
            try {
                is = propURL.openConnection().getInputStream();
                props.load(is);
                is.close();
                System.err.println("\nUsing default configuration properties.");
            }
            catch (Exception ex2) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex3) {
                    // empty catch block
                }
                System.err.println("\nUnable to load any configuration properties.");
                return null;
            }
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            props.setProperty(name, Main.substVars(props.getProperty(name), name, null, props));
        }
        return props;
    }

    public static void copySystemProperties(Properties configProps) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("felix.") && !key.equals("org.osgi.framework.system.packages") && !key.equals("org.osgi.framework.bootdelegation")) continue;
            configProps.setProperty(key, System.getProperty(key));
        }
    }

    public static String substVars(String val, String currentKey, Map cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = Main.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

