/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.felix;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ow2.jonas.launcher.felix.IConfigurationProvider;
import org.ow2.jonas.launcher.felix.JOnAS;
import org.ow2.jonas.launcher.felix.util.IOUtils;
import org.ow2.jonas.launcher.felix.util.JOnASUtils;
import org.ow2.jonas.launcher.felix.util.Maven2Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationProvider
implements IConfigurationProvider {
    private static final String FELIX_CONFIG_FILE_PROP = "jonas.felix.configuration.file";
    private static final String FELIX_BUNDLES_CONFIG_FILE_PROP = "jonas.felix.bundles.configuration.file";
    private List<String> excluded = null;

    @Override
    public Map getConfiguration() throws IOException {
        String felixConfigFilename = System.getProperty(FELIX_CONFIG_FILE_PROP);
        Properties config = felixConfigFilename != null && this.exists(felixConfigFilename) ? DefaultConfigurationProvider.loadConfiguration(felixConfigFilename) : DefaultConfigurationProvider.loadDefaultConfiguration();
        this.findAutoDeployedBundles(config);
        File base = JOnASUtils.getJOnASBase();
        File cacheRootDir = IOUtils.getSystemFile(base, "work");
        config.put("org.osgi.framework.storage", cacheRootDir.getAbsolutePath() + File.separator + "felix-cache");
        return config;
    }

    private void findAutoDeployedBundles(Properties config) throws IOException {
        Properties levels = null;
        String felixBundlesConfigFilename = System.getProperty(FELIX_BUNDLES_CONFIG_FILE_PROP);
        levels = felixBundlesConfigFilename != null && this.exists(felixBundlesConfigFilename) ? DefaultConfigurationProvider.loadConfiguration(felixBundlesConfigFilename) : DefaultConfigurationProvider.getAutoDeployedBundles();
        for (String string : levels.keySet()) {
            String level;
            if (string.startsWith("install.level.")) {
                level = string.substring("install.level".length());
                config.put("felix.auto.install".concat(level), this.getBundleList(levels, string));
            }
            if (!string.startsWith("start.level.")) continue;
            level = string.substring("start.level".length());
            config.put("felix.auto.start".concat(level), this.getBundleList(levels, string));
        }
    }

    private String getBundleList(Properties levels, String key) throws IOException {
        String value = levels.getProperty(key);
        StringBuilder sb = new StringBuilder();
        String[] bundles = value.split(",");
        for (int i = 0; i < bundles.length; ++i) {
            String bundle = bundles[i];
            if ("".equals(bundle)) continue;
            String[] artifact = bundle.split(":");
            String groupId = artifact[0].trim();
            String artifactId = artifact[1].trim();
            String version = null;
            String classifier = null;
            if (this.getExcludedBundleList().contains(groupId + ":" + artifactId)) continue;
            if (artifact.length == 3) {
                classifier = DefaultConfigurationProvider.getClassifier(artifact[2]);
                if (classifier == null) {
                    version = artifact[2].trim();
                }
            } else if (artifact.length == 4) {
                version = artifact[2].trim();
                classifier = DefaultConfigurationProvider.getClassifier(artifact[3]);
                if (classifier == null) {
                    throw new IOException("Incorrect classifier in bundle: " + bundle);
                }
            } else if (artifact.length > 4) {
                throw new IOException("Incorrect number of parts in bundle: " + bundle);
            }
            if (version == null) {
                version = JOnASUtils.getVersion();
            }
            sb.append("reference:");
            File repository = null;
            repository = JOnASUtils.isDeveloperMode() ? Maven2Utils.getMaven2Repository() : this.getRepositoriesBundlesFile();
            sb.append(Maven2Utils.getBundleMaven2Location(repository.getPath(), groupId, artifactId, version, classifier).concat(" "));
        }
        return sb.toString();
    }

    private File getRepositoriesBundlesFile() {
        File root = JOnASUtils.getJOnASRoot();
        return IOUtils.getSystemFile(root, "repositories/bundles");
    }

    private static String getClassifier(String value) {
        String classifier = null;
        String trimmed = value.trim();
        if (trimmed.startsWith("{") && trimmed.endsWith("}")) {
            classifier = trimmed.substring(1, trimmed.length() - 1);
        }
        return classifier;
    }

    private static Properties getAutoDeployedBundles() throws IOException {
        return DefaultConfigurationProvider.getPropertiesResource("jonas-autodeploy-bundles.properties");
    }

    private static Properties loadDefaultConfiguration() throws IOException {
        return DefaultConfigurationProvider.getPropertiesResource("default-config.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadConfiguration(String configFilename) throws IOException {
        File configFile = new File(configFilename);
        Properties config = new Properties();
        FileInputStream is = new FileInputStream(configFile);
        try {
            config.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
        return config;
    }

    private static Properties getPropertiesResource(String resource) throws IOException {
        Properties config = new Properties();
        InputStream is = JOnAS.class.getResourceAsStream(resource);
        config.load(is);
        return config;
    }

    protected List<String> getExcludedBundleList() {
        if (this.excluded == null) {
            this.excluded = new ArrayList<String>();
            if (!Boolean.getBoolean("jonas.felix.tui.enabled")) {
                this.excluded.add("org.apache.felix:org.apache.felix.shell.tui");
            }
            if (!Boolean.getBoolean("jonas.felix.gui.enabled")) {
                this.excluded.add("org.apache.felix:org.apache.felix.shell.gui");
                this.excluded.add("org.apache.felix:org.apache.felix.shell.gui.plugin");
            }
        }
        return this.excluded;
    }

    private boolean exists(String Filename) {
        return new File(Filename).exists();
    }
}

