/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.Map;
import org.apache.felix.framework.BundleInfo;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleArchive;
import org.apache.felix.framework.searchpolicy.ModuleDefinition;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IModule;
import org.osgi.framework.BundleException;

class RegularBundleInfo
extends BundleInfo {
    private BundleArchive m_archive = null;
    private String m_cachedSymbolicName = null;
    private long m_cachedSymbolicNameTimestamp;

    protected RegularBundleInfo(Logger logger, IModule module, BundleArchive archive) {
        super(logger, module);
        this.m_archive = archive;
    }

    public BundleArchive getArchive() {
        return this.m_archive;
    }

    public synchronized String getSymbolicName() {
        if (this.getLastModified() > this.m_cachedSymbolicNameTimestamp) {
            this.m_cachedSymbolicName = null;
            this.m_cachedSymbolicNameTimestamp = this.getLastModified();
            try {
                ICapability moduleCap = ManifestParser.parseBundleSymbolicName(this.getCurrentHeader());
                if (moduleCap != null) {
                    this.m_cachedSymbolicName = (String)moduleCap.getProperties().get("bundle-symbolic-name");
                }
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
        return this.m_cachedSymbolicName;
    }

    public long getBundleId() {
        try {
            return this.m_archive.getId();
        }
        catch (Exception ex) {
            this.getLogger().log(1, "Error getting the identifier from bundle archive.", ex);
            return -1L;
        }
    }

    public String getLocation() {
        try {
            return this.m_archive.getLocation();
        }
        catch (Exception ex) {
            this.getLogger().log(1, "Error getting location from bundle archive.", ex);
            return null;
        }
    }

    public int getStartLevel(int defaultLevel) {
        try {
            return this.m_archive.getStartLevel();
        }
        catch (Exception ex) {
            this.getLogger().log(1, "Error reading start level from bundle archive.", ex);
            return defaultLevel;
        }
    }

    public void setStartLevel(int i) {
        try {
            this.m_archive.setStartLevel(i);
        }
        catch (Exception ex) {
            this.getLogger().log(1, "Error writing start level to bundle archive.", ex);
        }
    }

    public Map getCurrentHeader() {
        return ((ModuleDefinition)this.getCurrentModule().getDefinition()).getHeaders();
    }

    public long getLastModified() {
        try {
            return this.m_archive.getLastModified();
        }
        catch (Exception ex) {
            this.getLogger().log(1, "Error reading last modification time from bundle archive.", ex);
            return 0L;
        }
    }

    public void setLastModified(long l) {
        try {
            this.m_archive.setLastModified(l);
        }
        catch (Exception ex) {
            this.getLogger().log(1, "Error writing last modification time to bundle archive.", ex);
        }
    }

    public int getPersistentState() {
        try {
            return this.m_archive.getPersistentState();
        }
        catch (Exception ex) {
            this.getLogger().log(1, "Error reading persistent state from bundle archive.", ex);
            return 2;
        }
    }

    public void setPersistentStateInactive() {
        try {
            this.m_archive.setPersistentState(2);
        }
        catch (Exception ex) {
            this.getLogger().log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }

    public void setPersistentStateActive() {
        try {
            this.m_archive.setPersistentState(32);
        }
        catch (Exception ex) {
            this.getLogger().log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }

    public void setPersistentStateUninstalled() {
        try {
            this.m_archive.setPersistentState(1);
        }
        catch (Exception ex) {
            this.getLogger().log(1, "Error writing persistent state to bundle archive.", ex);
        }
    }
}

