/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2005 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ManagementEndpointException.java 12246 2007-12-09 21:42:38Z benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.ee.mejb;

/**
 * Custom exceptions used by the web service monitoring endpoint (mejb.ear).
 * @author Matt Wringe
 * @author Vivek Lakshmanan
 */
public class ManagementEndpointException extends Exception {

    /**
     * The type of exception.
     */
    private String exceptionType;

    /**
     * The exception message.
     */
    private String message;

    /**
     * Gets the exception type
     * @return   The exception type.
     */
    public String getExceptionType() {
        return exceptionType;
    }

    /**
     * Sets the exception type.
     * @param exceptionType The exception type.
     */
    public void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    /**
     * Gets the exception message.
     * @return   The exception message.
     */
    public String getMessage() {
        return message;
    }

    /**
     * Sets the exception message.
     * @param message    The exception message.
     */
    public void setMessage(String message) {
        this.message = message;
    }

}